<?php
/**
 * Template part for displaying search content
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 */

 $cras_options = get_option('cras_options'); ?>


<article id="post-<?php the_ID(); ?>" <?php post_class('single-blog-list blog-standard__single blog-card'); ?>  data-aos="fade-up" >

<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>	
	<div class="blog-standard__single-img blog-header-info">
		<a href="<?php esc_url( the_permalink() ); ?>" class="post-thumbnail">
			<?php the_post_thumbnail(); ?>
		</a>
	</div>
<?php endif; ?>


	<div class="entry-content blog-standard__single-content blog-body-info">
		<header class="entry-header">

		<?php if(is_sticky(get_the_ID())): ?>
			<span class="sticky-tag"><?php esc_html_e( 'Featured', 'cras' ) ?></span>
		<?php endif; ?>

		<?php if ( 'post' === get_post_type() ) : ?>
			<?php get_template_part('template-extras/post-entry-meta'); ?>
		<?php endif; ?>	

		<?php if ( is_singular() ) :
			the_title( '<h6 class="entry-title blog-title">', '</h6>' );
		else :
			the_title( '<h6 class="entry-title blog-title"><a class="blog-title" href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h6>' );
		endif; ?>	

		</header>

		<?php
			the_excerpt( sprintf(
					wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
						esc_html__( 'Read More <span class="screen-reader-text"> "%s"</span>', 'cras' ),
						array(
								'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'cras' ),
				'after'       => '</div>',
				'link_before' => '<span class="page-number">',
				'link_after'  => '</span>',
			) );
		?>
	</div><!-- .entry-content -->	

	<div class="blog-footer-info">
		<a href="<?php esc_url( the_permalink() ); ?>" class="more-btn"><?php esc_html_e('Read More', 'cras'); ?></a>
	</div>	

</article><!-- #post -->

