<?php
/**
 * Template part for displaying single posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 */
$cras_options = get_option('cras_options');
?>

<?php 
     $cras_social_share = '';
    
	 if(isset($cras_options['cras_social_share'])) {
		 $cras_social_share = $cras_options['cras_social_share'];
	 }

	 $post_date = get_the_date( 'm. j. Y' );
 ?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-blog-post' ); ?>>

		<div>
            <div class="time-title mgt-20" data-aos="fade-up" data-aos-delay="600">

                <p class="time"><?php echo esc_html($post_date); ?></p>

				<?php if ( is_singular() ) :
					the_title( '<h4 class="title">', '</h4>' );
				else :
					the_title( '<h4 class="title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h4>' );
				endif; ?>

            </div>

			<?php if ( '' !== get_the_post_thumbnail() &&  is_single() ) { ?>   
				<div class="mgtb-50" data-aos="fade-up" data-aos-delay="700">
					<?php the_post_thumbnail('post-thumbnail', ['class'=>'post-thumbnail img-fluid']); ?>
				</div>
			<?php } ?>    

        </div>

		<div class="single-blog-list"  data-aos="fade-up">

	    <!-- .post-content -->
			<?php
				the_content( sprintf(
						wp_kses(
						/* translators: %s: Name of current post. Only visible to screen readers */
								__( 'Read More<span class="screen-reader-text"> "%s"</span>', 'cras' ),
								array(
										'span' => array(
												'class' => array(),
										),
								)
						),
						get_the_title()
				) );
			?>
			
			<div class="tagcloud">
			<?php    
				//Get the categories associated with the post
				$categories = get_the_category(); 

				if ($categories) {
					foreach ($categories as $category) {
						echo '<a href="' . esc_url(get_category_link($category->term_id)) . '" class="category-tooltip" data-tooltip="' . esc_attr($category->name) . '">' . esc_html($category->name . '') . '</a>';
					}
				}
				
				
				// Get the tags associated with the post
				$tags = get_the_tags(); 

				if ($tags) {
					foreach ($tags as $tag) {
						echo '<a href="' . esc_url(get_tag_link($tag)) . '" class="tag-tooltip" data-tooltip="' . esc_attr($tag->name) . '">' . esc_html($tag->name . '') . '</a>';
					}
				}
			?>	
				</div>
			
			<?php	
				//Link paginations
				wp_link_pages( array(
					'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'cras' ),
					'after'       => '</div>',
					'link_before' => '<span class="page-number">',
					'link_after'  => '</span>',
				) );
			?>
		</div><!-- .post-content -->	

        <!-- Start SHARE POST: -->
		<?php if( $cras_social_share == 1 ) { ?>
            <div class="ak-height-30 ak-height-lg-20"></div>
    		<div class="primary-color-border"></div>
		
			<div class="cs_height_100 cs_height_lg_50"></div>
			<?php cras_social_share_buttons(); ?>
	
		 <?php } ?>

</article>
