<?php
/**
 * Template part for displaying related posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 */
$cras_options = get_option('cras_options');
?>

<?php
    $relp_title = '';
    $relp_tagline = '';
    $relp_desc = '';
    $relp_no = '';

    if(isset($cras_options['cras_relp_title'])){  
        $relp_title = $cras_options['cras_relp_title'];
    } 
    if(isset($cras_options['cras_relp_tagline'])){  
        $relp_tagline = $cras_options['cras_relp_tagline'];
    }
    if(isset($cras_options['cras_relp_desc'])){  
        $relp_desc = $cras_options['cras_relp_desc'];
    }
	if(isset($cras_options['cras_relp_no'])){  
        $relp_no = $cras_options['cras_relp_no'];
    }   
?>

<div class="ak-height-125 ak-height-lg-80"></div>
  <div class="container">

      <div class="center-section-heading" data-aos="fade-up">
          <div class="ak-section-heading ak-style-1 ak-type-1">
              <div class="background-text"><?php echo esc_html($relp_tagline); ?></div>
              <h2 class="ak-section-title"><?php echo esc_html($relp_title); ?></h2>
              <p class="ak-section-subtitle"><?php echo esc_html($relp_desc); ?></p>
          </div>
      </div>

      <div class="ak-height-50 ak-height-lg-50"></div>
      <div class="blog">

		<?php
			$post_id = get_the_ID();
			$categories = get_the_category( $post_id );
			$category_ids = array();
			
			foreach ( $categories as $category ) {
				$category_ids[] = $category->term_id;
			}
			if ( ! empty( $category_ids ) ) {
				$related_args = array(
					'post_type' => 'post', // Change this to your custom post type if needed
					'posts_per_page' => $relp_no , // Adjust the number of related posts to show
					'post__not_in' => array( $post_id ), // Exclude the current post
					'category__in' => $category_ids, // Retrieve posts within the same categories
					'orderby' => 'rand', // Display related posts in random order
				);
			
				$related_query = new WP_Query( $related_args );
			
				if ( $related_query->have_posts() ) {
					while ( $related_query->have_posts() ) {
						$related_query->the_post();

			$bl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'cras_releted');
		?>
				
			<div class="blog-card" data-aos="fade-up">
                <a href="<?php the_permalink(); ?>">
                    <div class="blog-header-info">
                        <img src="<?php echo esc_url($bl_image_port[0]); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                    </div>
                </a>
                <div class="blog-body-info">
                    <p class="blog-text"><?php the_date('m. j. Y'); ?></p>
                    <a href="<?php the_permalink(); ?>" class="blog-title"><?php the_title(); ?></a>
                </div>
                <div class="blog-footer-info">
                    <a href="<?php the_permalink(); ?>" class="more-btn"><?php esc_html_e('VIEW MORE', 'cras'); ?></a>
                </div>
            </div>

			<?php   
				}
					wp_reset_postdata(); // Reset the query
				} else {
					// If no related posts are found
					echo 'No related posts found.';
				}
			}
			?>	

		</div>
	</div>
