<?php
/**
 * Template part for displaying a message that posts cannot be found
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 * @version 1.0
 */

 $cras_options = get_option('cras_options'); ?>

<?php
	if(isset($cras_options['cras_search_btn'])) {
		$search_btn = $cras_options['cras_search_btn'];
	} 
	if(isset($cras_options['cras_search_title'])) {
		$search_title = $cras_options['cras_search_title'];
	} 
	if(isset($cras_options['cras_search_text'])) {
		$search_subtitle = $cras_options['cras_search_text'];
	} 
?>

<article id="post-<?php the_ID(); ?>" <?php post_class( 'single-blog-post' ); ?> >
	<div class="single-blog-list" data-aos="fade-up">

		<div class="blog-details__content">

		<?php if(!empty($search_title)) { ?>
			<h2 class="search-title__title search"><?php echo esc_html( $search_title ); ?></h2>
		<?php } else { ?>	
			<h2 class="search-title__title search"><?php esc_html_e( 'Nothing Found', 'cras' ); ?></h2>
		<?php } ?>	

			<div class="search-content">

			<?php if ( is_home() && current_user_can( 'publish_posts' ) ) : ?>

				<p><?php printf( esc_html__( 'Ready to publish your first post? <a href="%1$s">Get started here</a>.', 'cras' ), esc_url( admin_url( 'post-new.php' ) ) ); ?></p>

			<?php else : ?>

			<?php if(!empty($search_subtitle)) { ?>	
				<p><?php echo esc_html( $search_subtitle ); ?></p>
			<?php } else { ?>
				<p><?php esc_html_e( 'It seems we can&rsquo;t find what you&rsquo;re looking for. Perhaps searching can help.', 'cras' ); ?></p>
			<?php } ?>	
				
				<div class="search-query">

			<?php
				get_search_form();
			endif; ?>

			<?php if(!empty($search_btn)) { ?>     
				<div class="go-to-home">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="common-btn">
						<?php echo esc_html( $search_btn ); ?>
					</a>
				</div>
			<?php } else { ?>
				<div class="go-to-home">
					<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="common-btn">
						<?php esc_html_e('BACK TO HOME', 'cras'); ?>
					</a>
				</div>
			<?php } ?> 

				</div>
			</div>
		</div><!-- .page-content -->
	</div><!-- .no-results -->
</article>
