<?php
/**
 * Template part for displaying gallery posts
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('single-blog-list blog-standard__single blog-card'); ?>  data-aos="fade-up" >
<?php
    $images = get_children(
        array(
            'post_parent' => get_the_ID(),
            'post_type' => 'attachment',
            'post_mime_type' => 'image'
        ) );

    $image_ids = [];

    if(is_array($images) && !empty($images)){

        foreach ($images as $image){
            array_push($image_ids, $image->ID);
        }

    }else{
        global $post;
        $post_content = $post->post_content;
        preg_match('/\[gallery.*ids=.(.*).\]/', $post_content, $ids);
    }
?>    

<?php if ( '' !== get_the_post_thumbnail() && ! is_single() ) : ?>	
	<div class="blog-standard__single-img blog-header-info">
		<a href="<?php esc_url( the_permalink() ); ?>" class="post-thumbnail">
			<?php the_post_thumbnail(); ?>
		</a>
	</div>
<?php endif; ?>


	<div class="entry-content blog-standard__single-content blog-body-info">
		<header class="entry-header">

		<?php if(is_sticky(get_the_ID())): ?>
			<span class="sticky-tag"><?php esc_html_e( 'Featured', 'cras' ) ?></span>
		<?php endif; ?>

		<?php if ( 'post' === get_post_type() ) : ?>
			<?php get_template_part('template-extras/post-entry-meta'); ?>
		<?php endif; ?>	

		<?php if ( is_singular() ) :
			the_title( '<h6 class="entry-title blog-title">', '</h6>' );
		else :
			the_title( '<h6 class="entry-title blog-title"><a class="blog-title" href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h6>' );
		endif; ?>	

		</header>

		<?php
			the_excerpt( sprintf(
					wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
						esc_html__( 'Read More <span class="screen-reader-text"> "%s"</span>', 'cras' ),
						array(
								'span' => array(
								'class' => array(),
							),
						)
					),
					get_the_title()
			) );

			wp_link_pages( array(
				'before'      => '<div class="page-links">' . esc_html__( 'Pages:', 'cras' ),
				'after'       => '</div>',
				'link_before' => '<span class="page-number">',
				'link_after'  => '</span>',
			) );
		?>
	</div><!-- .entry-content -->	

	<div class="blog-footer-info">
		<a href="<?php esc_url( the_permalink() ); ?>" class="more-btn"><?php esc_html_e('Read More', 'cras'); ?></a>
	</div>	

</article><!-- #post -->
