<?php 
/**
 * The template for displaying the header top
 *
 * @package cras
 */
$cras_options = get_option('cras_options');
?>

<?php
$hd_mail = '';
$hd_phn = '';

if(isset($cras_options['cras_sh_mail'])) {
    $hd_mail = $cras_options['cras_sh_mail'];
}

if(isset($cras_options['cras_sh_phn'])) {  
    $hd_phn = $cras_options['cras_sh_phn'];
} 

?>

<?php if(!empty($hd_phn)) { ?> 
    <div class="ak-main-header-right">
        <a href="tel:<?php echo esc_attr($hd_phn); ?>">
            <div class="d-flex align-items-center gap-3">
                <div class="heartbeat-icon">
                    <span class="ak-heartbeat-btn"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/phone.svg" alt="<?php esc_attr(get_bloginfo('name', 'display')); ?>"></span>
                </div>
                <h6> <?php echo esc_html($hd_phn); ?></h6>
            </div>
        </a>
    </div>
<?php } elseif(!empty($hd_mail)) { ?> 
    <div class="ak-main-header-right">
        <a href="mailto:<?php echo esc_attr($hd_mail); ?>">
            <div class="d-flex align-items-center gap-3">
                <div class="heartbeat-icon">
                    <span class="ak-heartbeat-btn"><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/email.svg" alt="<?php esc_attr(get_bloginfo('name', 'display')); ?>"></span>
                </div>
                <h6> <?php echo esc_html($hd_mail); ?></h6>
            </div>
        </a>
    </div>
<?php } ?>    
