<?php
/**
 * Displays footer all styles
 *
 * @package cras
 */
$cras_options = get_option('cras_options');
?>
                        
<?php
$footer_bg = '';
$cras_footercright = '';
$footer_bg_img = '';
$footer_bg_color = '';

if(isset($cras_options['cras_footer_bg'])) {
    $footer_bg = $cras_options['cras_footer_bg'];
}

if(isset($cras_options['cras_footercright'])) {  
    $cras_footercright = $cras_options['cras_footercright'];
} 

if(isset($cras_options['cras_footer_bg']['background-image'])) {  
    $footer_bg_img = $cras_options['cras_footer_bg']['background-image'];
} 

if(isset($cras_options['cras_footer_bg']['background-color'])) {  
    $footer_bg_color = $cras_options['cras_footer_bg']['background-color'];
} ?>

<?php if( ( is_active_sidebar( 'cras-footer-widget-1' ) ) || ( is_active_sidebar( 'cras-footer-widget-2' ) ) || ( is_active_sidebar( 'cras-footer-widget-3' ) ) || ( is_active_sidebar( 'cras-footer-widget-4' ) ) ) { ?>

<?php if( !empty( ($footer_bg_img) || ($footer_bg_color) ) ) { ?>
    <footer class="footer style-1" style="
        <?php if( !empty( $cras_options['cras_footer_bg']['background-color'] ) ) { ?>     
        background-color: <?php echo '' . esc_attr($cras_options['cras_footer_bg']['background-color']) ?>;

<?php } if( !empty( $cras_options['cras_footer_bg']['background-image'] ) ) { ?>
    background-image: url(<?php echo '' . esc_url($cras_options['cras_footer_bg']['background-image']) ?>
    );

<?php } if( !empty( $cras_options['cras_footer_bg']['background-repeat'] ) ) { ?>     
    background-repeat: <?php echo '' . esc_attr($cras_options['cras_footer_bg']['background-repeat']) ?>;

<?php } if( !empty( $cras_options['cras_footer_bg']['background-position'] ) ) { ?>     
    background-position: <?php echo '' . esc_attr($cras_options['cras_footer_bg']['background-position']) ?>; 

<?php } if( !empty( $cras_options['cras_footer_bg']['background-size'] ) ) { ?>     
    background-size: <?php echo '' . esc_attr($cras_options['cras_footer_bg']['background-size']) ?>;

<?php } if( !empty( $cras_options['cras_footer_bg']['background-attachment'] ) ) { ?>     
    background-attachment: <?php echo '' . esc_attr($cras_options['cras_footer_bg']['background-attachment']) ?>;
<?php } ?>

">

<?php } else { ?>
    <footer class="footer style-1 footer-bg">
<?php } ?>
        <div class="container">

            <?php get_template_part('template-parts/footer/footer', 'subscriptions'); ?>  
            
            <div class="ak-height-70 ak-height-lg-30"></div>
        <?php if( ( is_active_sidebar( 'cras-footer-widget-1' ) ) || ( is_active_sidebar( 'cras-footer-widget-2' ) ) || ( is_active_sidebar( 'cras-footer-widget-3' ) ) || ( is_active_sidebar( 'cras-footer-widget-4' ) ) ) { ?>    
            <div class="primary-color-border"></div>
            <div class="ak-height-35 ak-height-lg-30"></div>

        <?php $footer_logo = get_theme_mod('footer_logo'); ?>
        <?php if(!empty ( $footer_logo )) { ?>
            <div class="footer-logo">

                   <a href="<?php echo esc_url( home_url( '/' ) ); ?>"> <img class="footer-logo" src="<?php echo esc_url($footer_logo); ?>" alt="<?php esc_attr(get_bloginfo('name', 'display')); ?>"></a>

                <div class="ak-height-35 ak-height-lg-10"></div>
            </div>
        <?php } ?>    

            <div class="footer-content">
                <?php get_template_part('template-parts/footer/footer', 'widgets'); ?>
            </div> 

        <?php } ?>       

            <?php get_template_part('template-parts/footer/site', 'info'); ?>

        </div>    
    </footer>   
    
<?php } else { ?>    
    
    <footer class="footer style-1 footer-bg">
        <div class="container">

            <div class="ak-height-70 ak-height-lg-30"></div>
        <div class="primary-color-border"></div>

            <div class="copy-right">

                <p class="title"><?php esc_html_e('Copyright 2024, All Right reserved @', 'cras'); ?><a href="https://themeforest.net/user/3jon"><?php esc_html_e('3jon', 'cras'); ?></a></p>

                <div class="social-icon">
                    <?php get_template_part('template-extras/social', 'connections') ?>
                </div>
            </div>

        </div>    
    </footer> 
    
<?php } ?>    



