<?php
/**
 * Displays Team Member Services
 *
 * @package cras
 */

 $cras_options = get_option('cras_options');
?>

<?php
    $tm_srv_sec_tagline = get_post_meta($post->ID,'cras_tm_srv_sec_tagline', true);
    $tm_srv_sec_title = get_post_meta($post->ID,'cras_tm_srv_sec_title', true);
    $tm_srv_sec_desc = get_post_meta($post->ID,'cras_tm_srv_sec_desc', true);
    $tm_srv_cat = get_post_meta($post->ID,'cras_tm_srv_cat', true);
    $tm_post_no = get_post_meta($post->ID,'cras_tm_post_no', true);
?>
	<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="d-flex justify-content-center">
			<div class="sticky-content container">
				<div class="content style_2">
					<div class="service">

                    <?php
                        global $post;
                        $args=array('post_type' => 'services', 'services_category'=> $tm_srv_cat, 'showposts' => $tm_post_no);
                        $query=new \WP_Query($args);
                        while($query->have_posts()) : $query->the_post();             

                        $srvs_image_port = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');
                    ?>
                        <div class="service-card" data-aos="fade-left">
                            <a href="<?php the_permalink(); ?>" class="card-img">
                                <img src="<?php echo esc_url($srvs_image_port); ?>" class="ak-bg" alt="<?php esc_attr(get_bloginfo('display', 'name')); ?>">
                            </a>
                            <div class="card-info">
                                <a href="<?php the_permalink(); ?>" class="card-title"><?php the_title(); ?></a>
                                <p class="card-desp"><?php the_excerpt(); ?></p>
                                <a href="<?php the_permalink(); ?>" class="more-btn"><?php esc_html_e('VIEW MORE', 'cras'); ?></a>
                            </div>
                        </div>
                    <?php
                        endwhile;	
                        wp_reset_postdata();
                    ?>
		        </div>
			</div>

			<div class="sidebar width-none">
				<div class="services-content">

					<div class="ak-section-heading ak-style-1">
						<div class="background-text" data-aos="fade-right" data-aos-duration="1000"><?php echo esc_html($tm_srv_sec_tagline); ?></div>
						<h2 class="ak-section-title"><?php echo esc_html($tm_srv_sec_title); ?></h2>
						<p class="ak-section-subtitle"><?php echo esc_html($tm_srv_sec_desc); ?></p>
					</div>

				</div>
			</div>

		</div>
	</div>
	<div class="scroll-end-point"></div>

