<?php 
/**
 * The template for displaying the top breadcrumb
 *
 * @package cras
 */
$cras_options = get_option('cras_options');
?>

<?php
    $single_page_title = ''; 

    if(isset($cras_options['cras_bl_single_title'])){  
        $single_page_title = $cras_options['cras_bl_single_title'];
    }  
?>

<div class="ak-height-125 ak-height-lg-80"></div>
    <div class="container">
        <div class="d-md-flex justify-content-between align-items-center">
            <div class="common-page-title">

            <?php if(!empty($single_page_title)) { ?>
                <h3 class="page-title"><?php echo esc_html($single_page_title); ?></h3>
            <?php } else { ?> 
                <h3 class="page-title"><?php esc_html_e('Blog Single Post', 'cras'); ?></h3>
            <?php } ?>       
                <div class="d-flex gap-2 align-items-center">
                    <a href="<?php echo esc_url( home_url( '/' ) ); ?>"><p><?php esc_html_e('Home /', 'cras'); ?></p></a>
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </div>
            </div>
            
            <?php // Get the previous post
                $prev_post = get_previous_post();

                // Get the next post
                $next_post = get_next_post(); 
            ?>

            <div class="pb-5 pb-md-0">
                <div class="next-prev-btn">

            <?php if ( $prev_post ) { ?>    
                    <button class="prev-btn button" onclick="document.location='<?php echo get_permalink( $prev_post->ID ); ?>'">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/prev.svg" alt="<?php echo esc_attr(get_bloginfo('display', 'name')); ?>"><span><?php esc_html_e('prev', 'cras'); ?></span>
                    </button>
                   
            <?php } if ( $next_post ) { ?>    
                    <button class="next-btn button" onclick="document.location='<?php echo get_permalink( $next_post->ID ); ?>'">
                        <span><?php esc_html_e('next', 'cras'); ?></span> <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/next.svg" alt="<?php echo esc_attr(get_bloginfo('display', 'name')); ?>">
                    </button>
            <?php } ?>
                
                </div>
            </div>     

        </div>
        <div class="primary-color-border"></div>
    </div>




