<?php
/**
 * Displays Related Post
 *
 * @package cras
 */

 $cras_options = get_option('cras_options');
?>

<?php
// Get the current post object
$current_post = get_post();

// Get the post categories
$categories = wp_get_post_categories( $current_post->ID );

// Set up the query arguments to retrieve related posts
$args = array(
    'category__in' => $categories,
    'post__not_in' => array( $current_post->ID ),
    'posts_per_page' => 3, // Change the number of related posts to display as needed
);

// Instantiate a new WP_Query instance
$related_query = new WP_Query( $args );

// Check if there are related posts found
if ( $related_query->have_posts() ) : ?>

  <div class="ak-height-125 ak-height-lg-80"></div>
  <div class="container">

      <div class="center-section-heading" data-aos="fade-up">
          <div class="ak-section-heading ak-style-1 ak-type-1">
              <div class="background-text">SIMILARBLOG</div>
              <h2 class="ak-section-title">SIMILAR BLOG</h2>
              <p class="ak-section-subtitle">Lorem Ipsum is simply dummy text of the printing and typesetting
                  industry. Lorem Ipsum has been the industrys stan.</p>
          </div>
      </div>

      <div class="ak-height-50 ak-height-lg-50"></div>
      <div class="blog">

        <?php while ( $related_query->have_posts() ) : $related_query->the_post(); 
              $blrp_img = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full'); ?>

            <div class="blog-card" data-aos="fade-up">
                <a href="<?php the_permalink(); ?>">
                    <div class="blog-header-info">
                        <img src="<?php echo esc_url($blrp_img); ?>" alt="<?php echo esc_attr(get_bloginfo('name', 'display')); ?>">
                    </div>
                </a>
                <div class="blog-body-info">
                    <p class="blog-text"><?php the_date('m. j. Y'); ?></p>
                    <a href="<?php the_permalink(); ?>" class="blog-title"><?php the_title(); ?></a>
                </div>
                <div class="blog-footer-info">
                    <a href="<?php the_permalink(); ?>" class="more-btn"><?php esc_html_e('VIEW MORE', 'cras'); ?></a>
                </div>
            </div>

        <?php endwhile; ?>

      </div>
  </div>
    <?php
    // Restore original post data
    wp_reset_postdata();
else :
    // If no related posts are found
    echo 'No Similar Posts Found.';
endif;
?>


        <!-- Post Meta End -->