<?php
/**
 * Displays Preloader
 *
 * @package cras
 */

 $cras_options = get_option('cras_options');
?>

<?php 
$cras_preloader_img = '';

if(isset($cras_options['cras_preloader_img'])){
    $cras_preloader_img = $cras_options['cras_preloader_img'] ['url'];
}
?>

<?php if(!empty($cras_preloader_img)) { ?>
    <div id="preloader" class="preloader-content ">
        <div class="loading-window">
            <div class="car car-detail">
                <div class="strike"></div>
                <div class="strike strike2"></div>
                <div class="strike strike3"></div>
                <div class="strike strike4"></div>
                <div class="strike strike5"></div>
                <img src="<?php echo esc_url($cras_preloader_img); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
            </div>
        </div>
    </div>
<?php } else { ?>
    <div id="preloader" class="preloader-content ">
        <div class="loading-window">
            <div class="car car-detail">
                <div class="strike"></div>
                <div class="strike strike2"></div>
                <div class="strike strike3"></div>
                <div class="strike strike4"></div>
                <div class="strike strike5"></div>
                <img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/preloader.png" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
            </div>
        </div>
    </div>
<?php } ?>
