a<?php 
/**
 * The template for displaying all single project post
 *
 * Template Name: single-team 

 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package cras
 */

get_header(); 
$cras_options = get_option('cras_options');
?>

<?php 
    if (have_posts()) :
    while (have_posts()) : the_post();
    global $post;
    $tm_img = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
    $project_categorypst = strip_tags( get_the_term_list($post->ID, 'team_category', '', ' , ', '') );

    $srv_single_banner_bg = '';

    if(isset($cras_options['cras_srv_single_banner_bg'])){
        $srv_single_banner_bg = $cras_options['cras_srv_single_banner_bg'] ['url'];
    }
    
    $tm_addr = get_post_meta($post->ID,'cras_tm_addr', true);
    $tm_mail = get_post_meta($post->ID,'cras_tm_email', true);
    $tm_phn = get_post_meta($post->ID,'cras_tm_phn', true);
    $tm_web = get_post_meta($post->ID,'cras_tm_web', true);
    $tm_about = get_post_meta($post->ID,'cras_tm_about', true);
    $tm_desg = get_post_meta($post->ID,'cras_tm_desg', true);
    $tm_vd = get_post_meta($post->ID,'cras_tm_vd_url', true);
?>

    <?php get_template_part('template-extras/singleteam', 'breadcrumb'); ?>

    <div class="ak-height-75 ak-height-lg-75"></div>

    <div class="container">
        <div class="ceo-content type_2">
            <div class="left-info" data-aos="fade-left" data-aos-delay="800">
              <img src="<?php echo esc_url( $tm_img[0] ); ?>" class="img-fluid" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
            </div>
            <div class="right-info" data-aos="fade-right" data-aos-delay="800">
                <div class="ceo-title">
                    <div>
                        <h5 class="title"><?php the_title(); ?></h5>

                      <?php if(!empty($tm_desg)) { ?>  
                        <p class="short-title"><?php echo esc_html($tm_desg); ?></p>
                      <?php } ?>  

                    </div>
                </div>
                <div class="ceo-desp">
                    <p class="desp"><?php the_content(); ?></p>
                    <ul class="address-list">

                    <?php if(!empty($tm_addr)) { ?> 
                        <li><span><?php esc_html_e('Address: ', 'cras'); ?></span> <?php echo esc_html($tm_addr); ?></li>
                    <?php } if(!empty($tm_mail)) { ?>   
                        <li><span><?php esc_html_e('Email: ', 'cras'); ?></span><a href = "mailto: <?php echo esc_html($tm_mail); ?>"><?php echo esc_html($tm_mail); ?></a></li>
                    <?php } if(!empty($tm_phn)) { ?>
                        <li><span><?php esc_html_e('Phone: ', 'cras'); ?></span> <?php echo esc_html($tm_phn); ?></li>
                    <?php } if(!empty($tm_web)) { ?>   
                        <li><span><?php esc_html_e('website: ', 'cras'); ?></span> <a href="<?php echo esc_html($tm_web); ?>"><?php echo esc_html($tm_web); ?></a></li>
                    <?php } ?>

                    </ul>
                </div>
              <?php if(!empty($tm_vd)) { ?>   
                <div class="d-flex gap-3 align-items-center">
                    <div>
                        <a href="<?php echo esc_url($tm_vd); ?>"
                            class="ak-video-block ak-style1 ak-video-open type_2">
                            <span class="ak-heartbeat-btn">
                                <span></span>
                            </span>
                        </a>
                    </div>
                </div>
              <?php } ?>  
            </div>
        </div>
        <div class="mt-3" data-aos="fade-left">
            <div class="d-flex align-items-center">
                <p class="me-5"><?php esc_html_e('Social Links:', 'cras'); ?></p>
                <div class="social-icon">
                  <?php get_template_part('template-extras/teamsocial', 'connections'); ?>
                </div>
            </div>
        </div>
    </div>

<!-- Slider Team Work -->   
<?php
    $gl_img1 = $dynamic_featured_image->get_featured_images();
    $gl_img2_count = count($gl_img1);
    if(!empty($gl_img1)) {
?>    
    <div class="ak-height-125 ak-height-lg-80"></div>
    <div class="team-single-page-slider ak-slider">
        <div class="swiper-wrapper">

        <?php for($i=0; $i<$gl_img2_count; $i++) { ?> 
            <div class="swiper-slide">
                <img class="slide-img" src="<?php echo esc_url( $gl_img1[$i]['full'] ); ?>" alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
            </div>
        <?php } ?>     

        </div>

        <div class="team-single-page-swiper-controll">
            <div class="button-next button-style">
                <svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41" fill="none">
                    <path
                        d="M1.82581 20.0839L7.72307 14.1866C7.93491 13.9392 8.3072 13.9104 8.55457 14.1223C8.80194 14.3341 8.83078 14.7064 8.61889 14.9538C8.59912 14.9769 8.57763 14.9984 8.55457 15.0181L3.66574 19.9129H20.0831C20.4088 19.9129 20.6729 20.1769 20.6729 20.5026C20.6729 20.8284 20.4088 21.0924 20.0831 21.0924H3.66574L8.55457 25.9812C8.80194 26.193 8.83078 26.5653 8.61889 26.8127C8.40699 27.0601 8.03475 27.0889 7.78738 26.877C7.76432 26.8572 7.74278 26.8358 7.72307 26.8127L1.82575 20.9154C1.59714 20.6854 1.59714 20.314 1.82581 20.0839Z"
                        fill="#fff" />
                </svg>
            </div>
            <div class="button-prev button-style">
                <svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41" fill="none">
                    <path
                        d="M20.5013 20.0839L14.6041 14.1866C14.3922 13.9392 14.0199 13.9104 13.7726 14.1223C13.5252 14.3341 13.4964 14.7064 13.7083 14.9538C13.728 14.9769 13.7495 14.9984 13.7726 15.0181L18.6614 19.9129H2.24401C1.91834 19.9129 1.6543 20.1769 1.6543 20.5026C1.6543 20.8284 1.91834 21.0924 2.24401 21.0924H18.6614L13.7726 25.9812C13.5252 26.193 13.4964 26.5653 13.7083 26.8127C13.9202 27.0601 14.2924 27.0889 14.5398 26.877C14.5628 26.8572 14.5844 26.8358 14.6041 26.8127L20.5014 20.9154C20.73 20.6854 20.73 20.314 20.5013 20.0839Z"
                        fill="#fff" />
                </svg>
            </div>
        </div>
    </div>
<?php } ?>

    <?php endwhile; ?>
    <?php endif; ?>

<!-- Team Member Services--> 
    <?php get_template_part('template-extras/teammember', 'services'); ?>       

    <?php get_footer(); ?>  