<?php 
/**
 * The template for displaying all single service post
 *
 * Template Name: single-service 

 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package cras
 */

get_header(); 
$cras_options = get_option('cras_options');
?>

<?php 
    if (have_posts()) :
    while (have_posts()) : the_post();
    global $post;
    $srv_img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'srv_single_thumg');

    $srv_info = get_post_meta($post->ID,'cras_srv_info', true);
    $srv_info_lst1 = get_post_meta($post->ID,'cras_srv_info_lst1', true);
    $srv_info_lst2 = get_post_meta($post->ID,'cras_srv_info_lst2', true);
    $srv_info_lst3 = get_post_meta($post->ID,'cras_srv_info_lst3', true);
    $srv_info_lst4 = get_post_meta($post->ID,'cras_srv_info_lst4', true);
    $srv_info_lst5 = get_post_meta($post->ID,'cras_srv_info_lst5', true);

    $srv_single_banner_bg = '';

    if(isset($cras_options['cras_srv_single_banner_bg'])){
        $srv_single_banner_bg = $cras_options['cras_srv_single_banner_bg'] ['url'];
    }    

?>

<!-- Start Services Breadcrumb -->
<?php get_template_part('template-extras/singleservices', 'breadcrumb'); ?>

    <!-- Start Services Content -->
    <div class="ak-height-75 ak-height-lg-80"></div>    

    <div class="d-flex justify-content-center">
        <div class="sticky-content container">
        <?php if ( is_active_sidebar( 'cras-sidebar-service' ) ) { ?>     
            <div class="content">
        <?php } else { ?>
            <div class="content content-full">
        <?php } ?>    
                <div class="single-blog-list" data-aos="fade-up">

                <?php if(!get_post_meta(get_the_ID(), 'services_category', true)):
		            wp_get_post_terms($post->ID,'services_category'); 
                    $service_category = wp_get_post_terms($post->ID,'services_category'); ?>

                <?php if(!empty($srv_img)) { ?>
                    

                    <img src="<?php echo esc_url( $srv_img[0] ); ?>" data-aos="fade-up" 
                    
                        <?php foreach($service_category as $service_cat) ?>                    
                    
                    class="img-fluid srv-img <?php echo $service_cat->slug; ?> 
                <?php //endforeach; ?>
                 
               " alt="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>">
                <?php } ?> 
                <?php endif; ?> 
                    
                    <h4 class="single-blog-title service-single-title"><?php the_title(); ?></h4>
                    
                    <div class="single-blog-desp">  
                      <?php
                        the_content( sprintf(
                            wp_kses(
                            /* translators: %s: Name of current post. Only visible to screen readers */
                                esc_html__( 'Read More<span class="screen-reader-text"> "%s"</span>', 'cras' ),
                                array(
                                    'span' => array(
                                        'class' => array(),
                                    ),
                                )
                            ),
                            get_the_title()
                        ) ); ?> 
                    </div>      

                </div>
            </div>

          <?php if ( is_active_sidebar( 'cras-sidebar-service' ) ) { ?> 
            <div class="sidebar">
                  <?php dynamic_sidebar( 'cras-sidebar-service' ); ?>
            </div>
          <?php } ?>  
          
        </div>
    </div>
    <div class="scroll-end-point"></div>

  <?php endwhile; ?>
  <?php endif; ?>

  <?php get_template_part('template-extras/page', 'contactpart'); ?>

  <?php get_footer(); ?>  