<?php
/**
 * The template for displaying all pages
 *
 * This is the template that displays all pages by default.
 * Please note that this is the WordPress construct of pages
 * and that other 'pages' on your WordPress site may use a
 * different template.
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package cras
 * @version 1.0
 */
get_header();
$cras_options = get_option('cras_options'); ?>

<?php
    $layout_choice = '';
    $comments_switch = '';
    
    if(isset($cras_options['cras_page_layout'])){
        $layout_choice = $cras_options['cras_page_layout'];
    }   
    if(isset($cras_options['cras_page_comment'])){    
        $comments_switch = $cras_options['cras_page_comment'];
    }   
?>

<?php get_template_part('template-extras/page', 'breadcrumb'); ?>
<div class="ak-height-75 ak-height-lg-60"></div>

<section class="blog-content-area blog-standard">
    <div class="container">
        <div class="row">
                    
            <div class="col-xl-8 col-lg-7">
                <div class="all-blog-post blog-standard__left">
                            
                    <?php
                        if (have_posts()) :

                            /* Start the Loop */
                            while (have_posts()) : the_post();

                                /*
                                 * Include the Post-Format-specific template for the content.
                                 * If you want to override this in a child theme, then include a file
                                 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
                                 */
                                get_template_part('template-parts/page/content', 'page');

                            endwhile; 
                    ?>
                    
                <?php if (comments_open() || get_comments_number()) { ?> 
                
                    <div class="ak-height-50 ak-height-lg-20"></div>

                    <?php comments_template(); ?>

                <?php } ?>

                <?php if ( function_exists("cras_posts_pagination") ) {  ?>
                    <div class="posts-pagination">
                        <?php cras_posts_pagination(); ?>
                    </div>
                <?php } ?>    

                    <?php
                        else :

                            get_template_part('template-parts/post/content', 'none');

                        endif; 
                    ?>

                </div>
            </div>

            <?php  get_sidebar(); ?>

        </div>
    </div>
</section>

<div class="cs_height_100 cs_height_lg_60"></div>

<?php get_footer(); ?>