<?php
/**
 * Include the TGM_Plugin_Activation class.
 */
require_once (get_template_directory().'/inc/tgmpa/class-tgm-plugin-activation.php');

add_action( 'tgmpa_register', 'cras_theme_register_required_plugins' );

function cras_theme_register_required_plugins() {

    $plugins = array(

        // Redux Framework
        array(
            'name'              => esc_html__('Redux Framework', 'cras'),
            'slug'              => 'redux-framework',
            'required'          => true,
            'force_activation'  => false,
            'force_deactivation'=> false, 
        ),

        // Meta Box
        array(
            'name'               => esc_html__('Meta Box', 'cras'),
            'slug'               => 'meta-box',
            'source'             => 'http://3jon.com/demo/nwp/plugins/meta-box.zip',
            'required'           => true,
            'force_activation'   => false,
            'force_deactivation' => false,
        ),

        // Custom Post Type
        array(
            'name'               => esc_html__('Custom Post Type', 'cras'), 
            'slug'               => 'custom-post-type', 
            'source'             => 'http://3jon.com/demo/nwp/plugins/cras/custom-post-type.zip', 
            'required'           => true,
            'version'            => '', 
            'force_activation'   => false,
            'force_deactivation' => false, 
        ),

        //  Contact Info Wodget
        array(
            'name'               => esc_html__('Contact Info Widget', 'cras'), 
            'slug'               => 'contact-info-widget', 
            'source'             => 'http://3jon.com/demo/nwp/plugins/cras/contact-info-widget.zip', 
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),

        //  Our Services Widget
        array(
            'name'               => esc_html__('Our Services Widget', 'cras'), 
            'slug'               => 'our-services-widget', 
            'source'             => 'http://3jon.com/demo/nwp/plugins/cras/our-services-widget.zip', 
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),

        //  Dynamic Featured Image
        array(
            'name'               => esc_html__('Dynamic Featured Image', 'cras'), 
            'slug'               => 'dynamic-featured-image', 
            'source'             => 'http://3jon.com/demo/nwp/plugins/cras/dynamic-featured-image.zip', 
            'required'           => true,
            'version'            => '',
            'force_activation'   => false,
            'force_deactivation' => false,
        ),
        
        // Elementor Page Builder
        array(
            'name'      => esc_html__('Elementor Page Builder', 'cras'),
            'slug'      => 'elementor',
            'required'  => true,
        ),
        
        // Contact Form 7
        array(
            'name'      => esc_html__('Contact Form 7', 'cras'),
            'slug'      => 'contact-form-7',
            'required'  => true,
        ),      
        
        // Date Time Picker for Contact Form 7
        array(
            'name'      => esc_html__('Date Time Picker for Contact Form 7', 'cras'),
            'slug'      => 'date-time-picker-for-contact-form-7',
            'required'  => true,
        ),      

        // One Click Demo Import
        array(
            'name'               => esc_html__('One Click Demo Import', 'cras'), 
            'slug'               => 'one-click-demo-import',
            'required'           => false, 
        ), 

        // Classic Editor
        array(
            'name'               => esc_html__('Classic Editor', 'cras'), 
            'slug'               => 'classic-editor',
            'required'           => false, 
        ),

        // Classic Widget
        array(
            'name'               => esc_html__('Classic Widgets', 'cras'), 
            'slug'               => 'classic-widgets',
            'required'           => false, 
        ),

        // WordPress Importer
        array(
            'name'               => esc_html__('WordPress Importer', 'cras'), 
            'slug'               => 'wordpress-importer', 
            'required'           => false, 
        ),

        // Widget Importer & Exporter
        array(
            'name'               => esc_html__('Widget Importer & Exporter', 'cras'), 
            'slug'               => 'widget-importer-exporter', 
            'required'           => false, 
        ),
        
        // Customizer Importer & Exporter
        array(
            'name'               => esc_html__('Customizer Export/Import', 'cras'), 
            'slug'               => 'customizer-export-import', 
            'required'           => false, 
        ),

        // MailChimp for WordPress
        array(
            'name'               => esc_html__('MailChimp for WordPress', 'cras'), 
            'slug'               => 'mailchimp-for-wp', 
            'required'           => false, 
        ),          
    );


    $config = array(
        'default_path' => '',                      // Default absolute path to pre-packaged plugins.
        'menu'         => 'tgmpa-install-plugins', // Menu slug.
        'has_notices'  => true,                    // Show admin notices or not.
        'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
        'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
        'is_automatic' => false,                   // Automatically activate plugins after installation or not.
        'message'      => '',                      // Message to output right before the plugins table.
        
    );

    tgmpa( $plugins, $config );

}