<?php
/**
 * Registering meta boxes
 *
 * All the definitions of meta boxes are listed below with comments.
 * Please read them CAREFULLY.
 *
 * You also should read the changelog to know what has been changed before updating.
 *
 * For more information, please visit:
 * @link http://www.deluxeblogtips.com/meta-box/docs/define-meta-boxes
 */

/********************* META BOX DEFINITIONS ***********************/

/**
 * Prefix of meta keys (optional)
 * Use underscore (_) at the beginning to make keys hidden
 * Alt.: You also can make prefix empty to disable it
 */
 
// Better has an underscore as last sign
$prefix = 'cras_';

global $cras_meta_boxes;

$cras_meta_boxes = array();

global $cras_smof_data;


/* ----------------------------------------------------- */
// Page Sections Metaboxes
/* ----------------------------------------------------- */


/* Page Section Background Settings */

$grid_array = array('2 Columns','3 Columns','4 Columns');

$pagebg_type_array = array(
	'image' => 'Image',
	'gradient' => 'Gradient',
	'color' => 'Color'
);


/* ----------------------------------------------------- */
// Page Settings
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-def-page-opt',
	'title' => 'Default Page Template Settings',
	'pages' => array( 'page'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(

		// SELECT BOX
		array(
			'name'     => esc_html__( 'Select', 'cras' ),
			'id'   => $prefix . 'default_page_format',
			'desc'  => esc_html__( 'Working only Default Page Template', 'cras' ),
			'type'     => 'image_select',
			// Array of 'value' => 'Label' pairs for select box
			'options'  => array(
				'gr_page_default' => esc_html__( get_template_directory_uri().'/inc/img/metaboxes/right.png', 'cras' ),
				'left_sidb' => esc_html__( get_template_directory_uri().'/inc/img/metaboxes/left.png', 'cras' ),
				'full_width' => esc_html__( get_template_directory_uri().'/inc/img/metaboxes/full.png', 'cras' ),
			),
			// Select multiple values, optional. Default is false.
			'multiple'    => false,
			'std'         => 'gr_page_default',
			'placeholder' => esc_html__( 'Select an Option', 'cras' ),
		),

		array(
			'name' => esc_html__( 'Header Top Bar', 'cras' ),
			'desc' => esc_html__( 'Enable Header Top Bar', 'cras' ),
			'id' => $prefix . 'top_bar',
			'type' => 'checkbox',
			'clone'		=> false,
			),

	),
);


/* ----------------------------------------------------- */
// Blog Post Settings
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-post-opt',
	'title' => 'Post Options',
	'pages' => array( 'post'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(
	
		array(
			'name'		=> esc_html__( 'Post Sub title', 'cras' ),
			'id'		=> $prefix . 'post_sub_title',
			'desc'		=> esc_html__( 'Enter Here post Sub title.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> 'Nam sollicitudin neque eu nibh pharetra mollis mauris in nisi rhoncus'
		),
		
	)
);


/* ----------------------------------------------------- */
// Gallery Settings
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-Gallery-opt3',
	'title' => 'Choose Gallery Post Type',
	'pages' => array( 'gallery'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(

		array(
			'name'		=> esc_html__( 'Select Gallery Post Type', 'cras' ),
			'id'		=> $prefix . 'gl_type',
			'desc'		=> esc_html__( 'Select Required One from Above Two Types', 'cras' ),
			//'multiple'  => true,
			'select_all_none' => true,
			'clone'		=> false,
			'inline'          => true,
			'type'		=> 'select_advanced',
			'options' => [
				''  => esc_html__( 'Normal Post', 'cras' ),
				'vertical'  => esc_html__( 'Vertical', 'cras' ),
				'horizontal' => esc_html__( 'Horizontal', 'cras')
			],
			'default' => '',
		),
		
	)
);


/* ----------------------------------------------------- */
// Projects Settings
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-projects-opt',
	'title' => 'Project Settings Area',
	'pages' => array( 'projects'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(
		array(
			'name'		=> esc_html__( 'Select Column Style', 'cras' ),
			'id'		=> $prefix . 'pro_select_clmn',
			'desc'		=> esc_html__( 'Select Required Column Style', 'cras' ),
			'multiple'  => true,
			'select_all_none' => true,
			'clone'		=> false,
			'type'		=> 'select',
			'options' => [
				'col-xl-4 col-lg-4 col-md-4'  => esc_html__( 'Select Column', 'cras' ),
				'col-xl-4 col-lg-4 col-md-4'  => esc_html__( 'Four Column', 'cras' ),
				'col-xl-3 col-lg-3 col-md-3' => esc_html__( 'Three Column', 'cras' ),
				'col-xl-8 col-lg-8 col-md-8' => esc_html__( 'Eight Column', 'cras' )
			],
			'default' => 'col-xl-4 col-lg-4 col-md-4',
		),
		array(
			'name'		=> esc_html__( 'Title', 'cras' ),
			'id'		=> $prefix . 'pr_title',
			'desc'		=> esc_html__( 'Enter Project Details Title.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Welcome Text', 'cras' ),
			'id'		=> $prefix . 'pr_wlct',
			'desc'		=> esc_html__( 'Enter Project Details Welcome Text.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Client Name', 'cras' ),
			'id'		=> $prefix . 'pr_clt',
			'desc'		=> esc_html__( 'Enter Project Details Client Name.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Start Date', 'cras' ),
			'id'		=> $prefix . 'pr_sd',
			'desc'		=> esc_html__( 'Enter Project Details Start Date.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'End Date', 'cras' ),
			'id'		=> $prefix . 'pr_ed',
			'desc'		=> esc_html__( 'Enter Project Details End Date.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Website URL', 'cras' ),
			'id'		=> $prefix . 'pr_wu',
			'desc'		=> esc_html__( 'Enter Project Details Website URL.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Select Projet Rating', 'cras' ),
			'id'		=> $prefix . 'pr_rating',
			'desc'		=> esc_html__( 'Select Required Projet Rating', 'cras' ),
			'multiple'  => true,
			'select_all_none' => true,
			'clone'		=> false,
			'type'		=> 'select',
			'options' => [
				'5'  => esc_html__( 'Five Star', 'cras' ),
				'4'  => esc_html__( 'Four Star', 'cras' ),
				'3' => esc_html__( 'Three Star', 'cras' ),
				'2' => esc_html__( 'Two Star', 'cras' ),
				'1' => esc_html__( 'One Star', 'cras' )
			],
			'default' => '5',
		)


	)
);	


/* ----------------------------------------------------- */
// Team Member Info Area
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-testimonials-opt',
	'title' => 'Team Member Info',
	'pages' => array( 'team'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(
		array(
			'name'		=> esc_html__( 'Designation', 'cras' ),
			'id'		=> $prefix . 'tm_desg',
			'desc'		=> esc_html__( 'Enter The Designation.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Team Member About Info / Description', 'cras' ),
			'id'		=> $prefix . 'tm_about',
			'desc'		=> esc_html__( 'Enter The Description.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Address', 'cras' ),
			'id'		=> $prefix . 'tm_addr',
			'desc'		=> esc_html__( 'Enter The Address.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Email', 'cras' ),
			'id'		=> $prefix . 'tm_email',
			'desc'		=> esc_html__( 'Enter The Email.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Phone Number', 'cras' ),
			'id'		=> $prefix . 'tm_phn',
			'desc'		=> esc_html__( 'Enter The Phone Number.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Website', 'cras' ),
			'id'		=> $prefix . 'tm_web',
			'desc'		=> esc_html__( 'Enter The Website URL.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Video url', 'cras' ),
			'id'		=> $prefix . 'tm_vd_url',
			'desc'		=> esc_html__( 'Enter The Video URL.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		)
	)
);

/* ----------------------------------------------------- */
// Team Member Services Area
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-team-services',
	'title' => 'Team Member Services',
	'pages' => array( 'team'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(
		array(
			'name'		=> esc_html__( 'Section Tagline', 'cras' ),
			'id'		=> $prefix . 'tm_srv_sec_tagline',
			'desc'		=> esc_html__( 'Enter The Tagline.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Section Title', 'cras' ),
			'id'		=> $prefix . 'tm_srv_sec_title',
			'desc'		=> esc_html__( 'Enter The Title.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Section Description', 'cras' ),
			'id'		=> $prefix . 'tm_srv_sec_desc',
			'desc'		=> esc_html__( 'Enter The Description.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'textarea',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Post No', 'cras' ),
			'id'		=> $prefix . 'tm_post_no',
			'desc'		=> esc_html__( 'Enter Required Post Number', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Category Name / Team Member Name', 'cras' ),
			'id'		=> $prefix . 'tm_srv_cat',
			'desc'		=> esc_html__( 'Enter Required Team Member Name.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
	)	
);



/* ----------------------------------------------------- */
// Team Social Connections
/* ----------------------------------------------------- */

$cras_meta_boxes[] = array(
	'id' => 'cras-team-opt2',
	'title' => "Team Member Social Connections",
	'pages' => array( 'team'),
	'context' => 'normal',

	// List of meta fields
	'fields' => array(
		
		array(
			'name'		=> esc_html__( 'Facebook', 'cras' ),
			'id'		=> $prefix . 'tm_fb_link',
			'desc'		=> esc_html__( 'Enter Here Facebook Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '#'
		),
		array(
			'name'		=> esc_html__( 'Twitter', 'cras' ),
			'id'		=> $prefix . 'tm_tw_link',
			'desc'		=> esc_html__( 'Enter Here Twitter Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '#'
		),
		array(
			'name'		=> esc_html__( 'Linkedin', 'cras' ),
			'id'		=> $prefix . 'tm_ld_link',
			'desc'		=> esc_html__( 'Enter Here Linkedin Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '#'
		),
		array(
			'name'		=> esc_html__( 'Google Plus', 'cras' ),
			'id'		=> $prefix . 'tm_gp_link',
			'desc'		=> esc_html__( 'Enter Here Google Plus Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '#'
		),
		array(
			'name'		=> esc_html__( 'Dribbble', 'cras' ),
			'id'		=> $prefix . 'tm_drb_link',
			'desc'		=> esc_html__( 'Enter Here Dribbble Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> '#'
		),
		array(
			'name'		=> esc_html__( 'You Tube', 'cras' ),
			'id'		=> $prefix . 'tm_yt_link',
			'desc'		=> esc_html__( 'Enter Here You Tube Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Instagram', 'cras' ),
			'id'		=> $prefix . 'tm_inst_link',
			'desc'		=> esc_html__( 'Enter Here Instagram Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Github', 'cras' ),
			'id'		=> $prefix . 'tm_git_link',
			'desc'		=> esc_html__( 'Enter Here Github Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Pinterest', 'cras' ),
			'id'		=> $prefix . 'tm_pt_link',
			'desc'		=> esc_html__( 'Enter Here Pinterest Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Skype', 'cras' ),
			'id'		=> $prefix . 'tm_skp_link',
			'desc'		=> esc_html__( 'Enter Here Skype Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Tumblr', 'cras' ),
			'id'		=> $prefix . 'tm_tmb_link',
			'desc'		=> esc_html__( 'Enter Here Tumblr Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Vimeo', 'cras' ),
			'id'		=> $prefix . 'tm_vm_link',
			'desc'		=> esc_html__( 'Enter Here Vimeo Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Behance', 'cras' ),
			'id'		=> $prefix . 'tm_be_link',
			'desc'		=> esc_html__( 'Enter Here Behance Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
		array(
			'name'		=> esc_html__( 'Flickr', 'cras' ),
			'id'		=> $prefix . 'tm_flck_link',
			'desc'		=> esc_html__( 'Enter Here Behance Link.', 'cras' ),
			'clone'		=> false,
			'type'		=> 'text',
			'std'		=> ''
		),
	
	)
);


/********************* META BOX REGISTERING ***********************/

/**
 * Register meta boxes
 *
 * @return void
 */
function cras_register_meta_boxes()
{
	global $cras_meta_boxes;

	// Make sure there's no errors when the plugin is deactivated or during upgrade
	if ( class_exists( 'RW_Meta_Box' ) )
	{
		foreach ( $cras_meta_boxes as $meta_box )
		{
			new RW_Meta_Box( $meta_box );
		}
	}
}

// Hook to 'admin_init' to make sure the meta box class is loaded before
// (in case using the meta box class in another plugin)
// This is also helpful for some conditionals like checking page template, categories, etc.
add_action( 'admin_init', 'cras_register_meta_boxes' );