<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_wcu_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-wcu';
	}
	
	public function get_title() {
		return 'Why Choose Us';
	}
	
	public function get_icon() {
		return 'eicon-checkbox';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'wcu_section',
            [
                'label' => esc_html__( 'WCU Content', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'wcu_style',
			[
				'label' => esc_html__( 'Choose Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'wcu_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'wcu_stl_2' => esc_html__( 'Style Two', 'cras' ),
				],
				'default' => 'wcu_stl_1',
			]
		);
		
		$this->add_control(
			'wcu_tagline',
			[
				'label' => esc_html__( 'Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Feature', 'cras' ),
                'placeholder' => esc_html__( 'Enter Tagline', 'cras' ),
			]
		);
		$this->add_control(
			'wcu_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Why Choose Us', 'cras' ),
                'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);
		$this->add_control(
			'wcu_sec_desc',
			[
				'label' => esc_html__( 'Section Descriptions', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
                'placeholder' => esc_html__( 'Enter Descriptions', 'cras' ),
			]
		);
		$this->add_control(
			'wcu_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'View More', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button Text', 'cras' ),
			]
		);
		$this->add_control(
			'wcu_btn_url',
			[
				'label' => esc_html__( 'Button Url', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button url', 'cras' ),
			]
		);
		$this->add_control(
			'wcu_fes_img',
			[
				'label' => esc_html__( 'Featured Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			],
		);
		$this->add_control(
			'wcu_circle_img',
			[
				'label' => esc_html__( 'Circle Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			],
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'wcu_rptr',
            [
                'label' => esc_html__( 'WCU Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'wcu_title',
                        'label' => esc_html__( 'Why Choose Us Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Certified Technicians', 'cras' ),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ wcu_title }}}',
            ],
			
        );

        $this->end_controls_section();
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

if($settings['wcu_style'] == 'wcu_stl_1') { 	
echo '<div class="ak-height-125 ak-height-lg-80"></div>
	<section class="container '. $settings['ex_class'] .'">
		<h2 class="disp">Section Heading</h2>
		<div class="choose-us-container-extents">
			<div class="choose-us-contain">
				<div class="choose-us-info" data-aos="fade-up">
					<div class="ak-section-heading ak-style-1">
						<div class="background-text">'. $settings['wcu_tagline'] .'</div>
						<h2 class="ak-section-title">'. $settings['wcu_sec_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['wcu_sec_desc'] .'</p>
					</div>
					<div class="ak-height-60 ak-height-lg-30"></div>
					<div class="stroke-heading-text">';
foreach ( $settings['wcu_rptr'] as $wcu_details ) :
	echo '<h3 class="ak-stroke-text hover-color-changes">'. $wcu_details['wcu_title'] .'</h3>';
endforeach;
echo 				'</div>
					<div class="ak-height-60 ak-height-lg-30"></div>
					<a href="'. $settings['wcu_btn_url'] .'" class="common-btn">
					'. $settings['wcu_btn_txt'] .'
					</a>
				</div>
				<div class="choose-us-img" data-aos="fade-up" data-aos-delay="150">
					<img src="'. $settings['wcu_fes_img']['url'] .'" alt="'. get_bloginfo('name', 'display') .'">
					<img class="circle-img" src="'. $settings['wcu_circle_img']['url'] .'" alt="'. get_bloginfo('name', 'display') .'">
				</div>
			</div>
		</div>
	</section>'; 
} elseif($settings['wcu_style'] == 'wcu_stl_2') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
	<section class="container '. $settings['ex_class'] .'">
		<h2 class="disp">Section Heading</h2>
		<div class="choose-us-contain style_three">
				<div class="choose-us-info" data-aos="fade-up">
					<div class="ak-section-heading ak-style-1">
						<div class="background-text">'. $settings['wcu_tagline'] .'</div>
						<h2 class="ak-section-title">'. $settings['wcu_sec_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['wcu_sec_desc'] .'</p>
					</div>
					<div class="ak-height-60 ak-height-lg-30"></div>
					<div class="stroke-heading-text">';
foreach ( $settings['wcu_rptr'] as $wcu_details ) :
	echo '<h3 class="ak-stroke-text hover-color-changes">'. $wcu_details['wcu_title'] .'</h3>';
endforeach;
echo 				'</div>
					<div class="ak-height-60 ak-height-lg-30"></div>
					<a href="'. $settings['wcu_btn_url'] .'" class="common-btn">
					'. $settings['wcu_btn_txt'] .'
					</a>
				</div>
				<div class="choose-us-img" data-aos="fade-up" data-aos-delay="150">
					<img src="'. $settings['wcu_fes_img']['url'] .'" alt="'. get_bloginfo('name', 'display') .'">
					<img class="circle-img" src="'. $settings['wcu_circle_img']['url'] .'" alt="'. get_bloginfo('name', 'display') .'">
				</div>
		</div>
	</section>'; 	
} 	

	}
	
	protected function _content_template() {

    }	
}

