<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_widget_video extends Widget_Base {
	
	public function get_name() {
		return 'widget-video';
	}
	
	public function get_title() {
		return 'Video';
	}
	
	public function get_icon() {
		return 'eicon-slider-video';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Video Content', 'cras' ),
			]
		);

		$this->add_control(
			'vd_bg',
			[
				'label' => esc_html__( 'Video Background Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'vd_url',
			[
				'label' => esc_html__( 'Video URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter Video URL', 'cras' ),
			]
		);			

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Class', 'cras' ),
			]
		);		

		$this->end_controls_section();
	}
	
	protected function render() {

    $settings = $this->get_settings_for_display();
	
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="video-home '. $settings['ex_class'] .'">
			<a href="'. $settings['vd_url'] .'"
				class="ak-video-block ak-style1 ak-video-open ak-bg ak-parallax_bg imagesZoom"
				data-src="'. $settings['vd_bg']['url'] .'" data-aos="zoom-out-down" data-aos-duration="1000"
				data-aos-delay="200">
				<span class="ak-heartbeat-btn">
					<span></span>
				</span>
			</a>
		</div>';	

	}
	
	protected function _content_template() {

    }
	
	
}