<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_Testimonials_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-testimonials';
	}
	
	public function get_title() {
		return 'Our Testimonials';
	}
	
	public function get_icon() {
		return 'eicon-review';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'testimonials_section',
            [
                'label' => esc_html__( 'Testimonials Content', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'tstm_style',
			[
				'label' => esc_html__( 'Choose Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'tstm_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'tstm_stl_2' => esc_html__( 'Style Two', 'cras' ),
				],
				'default' => 'tstm_stl_1',
			]
		);

		$this->add_control(
			'tst_sec_tagline',
			[
				'label' => esc_html__( 'Section Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Testimonials', 'cras' ),
                'placeholder' => esc_html__( 'Enter Tagline', 'cras' ),
			]
		);
		$this->add_control(
			'tst_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'SEE WHAT OUR Satisfied Customer SAYS', 'cras' ),
                'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);
		$this->add_control(
			'tst_pre_btn',
			[
				'label' => esc_html__( 'Previous Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'PREV', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button Text', 'cras' ),
			]
		);
		$this->add_control(
			'tst_nxt_btn',
			[
				'label' => esc_html__( 'Next Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'NEXT', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button Text', 'cras' ),
			]
		);
		$this->add_control(
			'tst_rt_bg',
			[
				'label' => esc_html__( 'Right Background Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'testimonials_rptr',
            [
                'label' => esc_html__( 'Testimonial Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'tst_clt_img',
						'label' => esc_html__( 'Client Image', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                    [
                        'name' => 'tst_clt_name',
                        'label' => esc_html__( 'Client Name', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Delores Olliva', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'tst_clt_country',
                        'label' => esc_html__( 'Client Place', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'From USA', 'cras' ),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'tst_clt_content',
                        'label' => esc_html__( 'Testimonial Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Welcome to our digital agency We specialize in helping business most like yours succeed online. From website design and development to digital marketing agency', 'cras' ),
                        'show_label' => false,
                    ],
					
                ],
                'title_field' => '{{{ tst_clt_name }}}',
            ],
			
        );

        $this->end_controls_section();
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

if($settings['tstm_style'] == 'tstm_stl_1') {	
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container">
			<div class="ak-testimonal-controll">
				<div class="testimonal-heading" data-aos="fade-right">
					<div class="ak-section-heading ak-style-1">
						<div class="background-text" data-aos="fade-right" data-aos-duration="1000">'. $settings['tst_sec_tagline'] .'</div>
						<h2 class="ak-section-title">'. $settings['tst_sec_title'] .'</h2>
					</div>
				</div>
				<div class="testimonal-controll" data-aos="fade-left">
					<button class="testimonal-prev button">
						<img src="'. get_template_directory_uri() .'/images/prev.svg" alt="'. get_bloginfo('display', 'name') .'"><span> '. $settings['tst_pre_btn'] .'</span>
					</button>
					<button class="testimonal-next button">
						<span>'. $settings['tst_nxt_btn'] .'</span> <img src="'. get_template_directory_uri() .'/images/next.svg" alt="'. get_bloginfo('display', 'name') .'">
					</button>
				</div>
			</div>
			<div class="ak-height-50 ak-height-lg-50"></div>
			<div class="ak-testimonal" data-aos="fade-up">
				<div class="ak-slider ak-slider-testimonal">
					<div class="swiper-wrapper">';

foreach ( $settings['testimonials_rptr'] as $tst_details ) :
	echo '<div class="swiper-slide">
			<div class="testimonal-info ak-style1">
				<div class="slider-info">
					<div class="d-flex justify-content-between align-items-end">
						<div>
							<h5 class="name">'. $tst_details['tst_clt_name'] .'</h5>
							<p class="from">'. $tst_details['tst_clt_country'] .'</p>
						</div>
						<div class="icon">
							<svg xmlns="http://www.w3.org/2000/svg" width="109" height="81"
								viewBox="0 0 109 81" fill="none">
								<g opacity="0.7" clip-path="url(#clip0_219_726)">
									<path
										d="M24.8606 80.2504C27.2135 76.6896 47.9194 44.6582 51.3233 31.1053C53.5194 22.3053 51.8096 15.5445 45.739 9.14449C36.0449 -1.09865 19.8567 -1.11431 11.0096 6.43079C1.59785 14.4622 -1.14726 29.8504 5.45666 39.2622C10.539 46.4935 15.2292 48.219 25.1586 51.4503C25.4253 56.5797 24.9861 77.0975 24.8606 80.2504Z"
										fill="#FF3D24" />
									<path
										d="M81.2214 80.2504C83.5743 76.6896 104.28 44.6582 107.668 31.1053C109.88 22.3053 108.155 15.5445 102.084 9.14449C92.4057 -1.09865 76.2175 -1.11431 67.3704 6.43079C57.9586 14.4622 55.1978 29.8504 61.8174 39.2622C66.8841 46.4935 71.5743 48.219 81.5194 51.4503C81.7861 56.5797 81.3312 77.0975 81.2214 80.2504Z"
										fill="#FF3D24" />
								</g>
								<defs>
									<clipPath>
										<rect width="108.235" height="80" fill="white"
											transform="translate(0.671997 0.966797)" />
									</clipPath>
								</defs>
							</svg>
						</div>
					</div>
					<h4 class="desp">“'. $tst_details['tst_clt_content'] .'”</h4>
				</div>
				<img src="'. $tst_details['tst_clt_img']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'">
			</div>
		</div>';
endforeach;					
			
	echo'			</div>
				</div>
				<div class="testimonal-img">
					<img src="'. $settings['tst_rt_bg']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'" />
				</div>
			</div>
		</div>';	
} elseif($settings['tstm_style'] == 'tstm_stl_2') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
	<div class="container">
		<div class="ak-testimonal-controll">
			<div class="testimonal-heading" data-aos="fade-right">
				<div class="ak-section-heading ak-style-1">
					<div class="background-text" data-aos="fade-right" data-aos-duration="1000">'. $settings['tst_sec_tagline'] .'</div>
					<h2 class="ak-section-title">'. $settings['tst_sec_title'] .'</h2>
				</div>
			</div>
			<div class="testimonal-controll" data-aos="fade-left">
				<button class="testimonal-prev button">
					<img src="'. get_template_directory_uri() .'/images/prev.svg" alt="'. get_bloginfo('display', 'name') .'"><span> '. $settings['tst_pre_btn'] .'</span>
				</button>
				<button class="testimonal-next button">
					<span>'. $settings['tst_nxt_btn'] .'</span> <img src="'. get_template_directory_uri() .'/images/next.svg" alt="'. get_bloginfo('display', 'name') .'">
				</button>
			</div>
		</div>
		<div class="ak-height-50 ak-height-lg-50"></div>
		<div class="ak-testimonal style-three" data-aos="fade-up">
			<div class="ak-slider ak-slider-testimonal">
				<div class="swiper-wrapper">';

foreach ( $settings['testimonials_rptr'] as $tst_details ) :
echo '<div class="swiper-slide">
		<div class="testimonal-info ak-style1">
			<div class="slider-info">
				<div class="d-flex justify-content-between align-items-end me-0 me-md-5">
					<div class="testimonal-title">
						<span class="border-pr"></span>
						<span class="border-wh"></span>
						<div class="title">
							<h5 class="name">'. $tst_details['tst_clt_name'] .'</h5>
							<p class="from">'. $tst_details['tst_clt_country'] .'</p>
						</div>
					</div>
					<div class="icon">
						<svg xmlns="http://www.w3.org/2000/svg" width="109" height="81"
							viewBox="0 0 109 81" fill="none">
							<g opacity="0.7" clip-path="url(#clip0_219_726)">
								<path
									d="M24.8606 80.2504C27.2135 76.6896 47.9194 44.6582 51.3233 31.1053C53.5194 22.3053 51.8096 15.5445 45.739 9.14449C36.0449 -1.09865 19.8567 -1.11431 11.0096 6.43079C1.59785 14.4622 -1.14726 29.8504 5.45666 39.2622C10.539 46.4935 15.2292 48.219 25.1586 51.4503C25.4253 56.5797 24.9861 77.0975 24.8606 80.2504Z"
									fill="#FF3D24" />
								<path
									d="M81.2214 80.2504C83.5743 76.6896 104.28 44.6582 107.668 31.1053C109.88 22.3053 108.155 15.5445 102.084 9.14449C92.4057 -1.09865 76.2175 -1.11431 67.3704 6.43079C57.9586 14.4622 55.1978 29.8504 61.8174 39.2622C66.8841 46.4935 71.5743 48.219 81.5194 51.4503C81.7861 56.5797 81.3312 77.0975 81.2214 80.2504Z"
									fill="#FF3D24" />
							</g>
							<defs>
								<clipPath>
									<rect width="108.235" height="80" fill="white"
										transform="translate(0.671997 0.966797)" />
								</clipPath>
							</defs>
						</svg>
					</div>
				</div>
				<h4 class="desp">“'. $tst_details['tst_clt_content'] .'”</h4>
			</div>
			<img src="'. $tst_details['tst_clt_img']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'">
		</div>
	</div>';
endforeach;					
		
echo'			</div>
			</div>
			<div class="testimonal-img">
				<img src="'. $settings['tst_rt_bg']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'" />
			</div>
		</div>
	</div>';
}				 

	}
	
	protected function _content_template() {

    }	
}

