<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_widget_team extends Widget_Base {
	
	public function get_name() {
		return 'team';
	}
	
	public function get_title() {
		return 'Team';
	}
	
	public function get_icon() {
		return 'eicon-integration';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Team Content', 'cras' ),
			]
		);

		$this->add_control(
			'team_style',
			[
				'label' => esc_html__( 'Team Styles', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'tm_stl_1'  => esc_html__( 'Team Style One', 'cras' ),
					'tm_stl_2' => esc_html__( 'Team Style Two', 'cras' ),
					'tm_stl_3' => esc_html__( 'Team Style Three', 'cras' )
				],
				'default' => 'tm_stl_1',
			]
		);

		$this->add_control(
			'team_tagline',
			[
				'label' => esc_html__( 'Section Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Team', 'cras' ),
                'placeholder' => esc_html__( 'Enter the tagline', 'cras' ),
				'condition' => [
					'team_style' => [ 'tm_stl_1', 'tm_stl_3' ],
				],
			]
		);
		
		$this->add_control(
			'team_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Team', 'cras' ),
				'placeholder' => esc_html__( 'Enter the title', 'cras' ),
				'condition' => [
					'team_style' => [ 'tm_stl_1', 'tm_stl_3' ],
				],
			]	
		);

		$this->add_control(
			'team_content',
			[
				'label' => esc_html__( 'Section Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
				'placeholder' => esc_html__( 'Enter the Content', 'cras' ),
				'condition' => [
					'team_style' => [ 'tm_stl_1', 'tm_stl_3' ],
				],
			]
		);

		$this->add_control(
			'team_btn',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'View MORE', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button Text', 'cras' ),
				'condition' => [
					'team_style' => 'tm_stl_1',
				],
			]
		);

		$this->add_control(
			'team_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Button URL', 'cras' ),
				'condition' => [
					'team_style' => 'tm_stl_1',
				],
			]
		);

		$this->add_control(
			'team_post_no',
			[
				'label' => esc_html__( 'Post Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::NUMBER,
                'placeholder' => esc_html__( 'Enter your required post number', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your require class', 'cras' ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {


	$settings = $this->get_settings_for_display();
	$team_title = $settings['team_title'];

if($settings['team_style'] == 'tm_stl_1') {	
	echo '<div class="ak-height-190 ak-height-lg-80"></div>
		<div class="container '. $settings['ex_class'] .'">
			<div class="team-contant">';
//if(!empty($team_title)) {			
	echo'		<div class="team-heading" data-aos="fade-right">				
					<div class="ak-section-heading ak-style-1">
						<div class="background-text" data-aos="fade-right" data-aos-duration="1000">'. $settings['team_tagline'] .'</div>
						<h2 class="ak-section-title">'. $settings['team_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['team_content'] .'</p>
					</div>
				
					<div class="ak-height-50 ak-height-lg-10"></div>
					<a href="'. $settings['team_btn_url'] .'" class="more-btn">'. $settings['team_btn'] .'</a>
				</div>';
//}				
	echo'		<div class="teams" data-aos="fade-zoom-in" data-aos-easing="ease-in-back" data-aos-delay="100" data-aos-offset="0">
					<div class="row row-cols-lg-3 row-cols-sm-2 row-cols-1 g-3 g-md-3">';

	global $post;	
	$args=array('post_type' => 'team', 'showposts' => $settings['team_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();             

	$team_image_port = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
	$tm_desg = get_post_meta($post->ID,'cras_tm_desg', true);

	echo '<div class="col">
				<div class="team-card ak-bg" data-src="'. esc_url( $team_image_port[0] ) .'">
					<div class="team-style-1">
						<div class="team-info">
							<div class="team-title">
								<a href="'. get_the_permalink() .'">'. get_the_title() .'</a>
								<p class="desp">'. $tm_desg .'</p>
							</div>
							<div class="team-info-social">';
								 get_template_part('template-extras/teamsocial', 'connections'); 
	echo'					</div>
						</div>
					</div>
				</div>
			</div>';

	endwhile;
	wp_reset_postdata();

	echo'		</div></div>
			</div>	
		</div>';		

} elseif($settings['team_style'] == 'tm_stl_2') {			
	echo'<div class="container '. $settings['ex_class'] .'">
			<div class="all-members">
				<div class="row row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1 g-4">';

	global $post;	
	$args=array('post_type' => 'team', 'showposts' => $settings['team_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();             

	$team_image_port = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
	$tm_desg = get_post_meta($post->ID,'cras_tm_desg', true);

	echo '<div class="col">
			<div class="member-card" data-aos="fade-up" data-aos-delay="0">
				<a href="'. get_the_permalink() .'">
					<img src="'. esc_url( $team_image_port[0] ) .'" class="member-img ak-bg" alt="'. get_bloginfo('name', 'display') .'" />
				</a>
				<div class="member-info">
					<div class="member-title">
						<a href="'. get_the_permalink() .'" class="title">
						'. get_the_title() .'</a>
						<p class="desp">'. $tm_desg .'</p>
					</div>
					<div class="member-info-social">';
						get_template_part('template-extras/teamsocial', 'connections');
	echo'			</div>
				</div>
			</div>
		</div>';

	endwhile;
	wp_reset_postdata();

	echo'		</div>
			</div>	
		</div>';	
} elseif($settings['team_style'] == 'tm_stl_3') {			
	echo'<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container '. $settings['ex_class'] .'">
			<div class="center-section-heading" data-aos="fade-up">
				<div class="ak-section-heading ak-style-1">
					<div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
						'. $settings['team_tagline'] .'
					</div>
					<div class="text-md-center">
						<h2 class="ak-section-title">'. $settings['team_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['team_content'] .'</p>
					</div>
				</div>
			</div>
			<div class="ak-height-50 ak-height-lg-50"></div>
			<div class="all-members">
				<div class="row row-cols-lg-3 row-cols-md-2 row-cols-sm-2 row-cols-1 g-4">';

	global $post;	
	$args=array('post_type' => 'team', 'showposts' => $settings['team_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();             

	$team_image_port = wp_get_attachment_image_src(get_post_thumbnail_id(), 'full');
	$tm_desg = get_post_meta($post->ID,'cras_tm_desg', true);

	echo '<div class="col">
			<div class="member-card" data-aos="fade-up" data-aos-delay="0">
				<a href="'. get_the_permalink() .'">
					<img src="'. esc_url( $team_image_port[0] ) .'" class="member-img ak-bg" alt="'. get_bloginfo('name', 'display') .'" />
				</a>
				<div class="member-info">
					<div class="member-title">
						<a href="'. get_the_permalink() .'" class="title">
						'. get_the_title() .'</a>
						<p class="desp">'. $tm_desg .'</p>
					</div>
					<div class="member-info-social">';
						get_template_part('template-extras/teamsocial', 'connections');
	echo'			</div>
				</div>
			</div>
		</div>';

	endwhile;
	wp_reset_postdata();

	echo'		</div>
			</div>	
		</div>';	
	}

	}
	
	protected function _content_template() {

    }
	
}