<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_widget_tab extends Widget_Base {
	
	public function get_name() {
		return 'widget-tab';
	}
	
	public function get_title() {
		return 'Tab';
	}
	
	public function get_icon() {
		return 'eicon-tabs';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {
        // Tab Title Section
        $this->start_controls_section(
            'tab_section',
            [
                'label' => esc_html__( 'Tabs Content', 'cras' ),
            ]
        );

        // Tab Title Fields
        $this->add_control(
            'tab_title1',
            [
                'label' => esc_html__( 'Tab Title', 'cras' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Mission', 'cras' ),
                'placeholder' => esc_html__( 'Enter tab title', 'cras' ),
            ]
        );
        $this->add_control(
            'tab_title2',
            [
                'label' => esc_html__( 'Tab Title', 'cras' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Mission', 'cras' ),
                'placeholder' => esc_html__( 'Enter tab title', 'cras' ),
            ]
        );
        $this->add_control(
            'tab_title3',
            [
                'label' => esc_html__( 'Tab Title', 'cras' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Mission', 'cras' ),
                'placeholder' => esc_html__( 'Enter tab title', 'cras' ),
            ]
        );
        $this->add_control(
            'tab_title4',
            [
                'label' => esc_html__( 'Tab Title', 'cras' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Mission', 'cras' ),
                'placeholder' => esc_html__( 'Enter tab title', 'cras' ),
            ]
        );
        $this->add_control(
            'tab_title5',
            [
                'label' => esc_html__( 'Tab Title', 'cras' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Mission', 'cras' ),
                'placeholder' => esc_html__( 'Enter tab title', 'cras' ),
            ]
        );

        $this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'tab_rptr',
            [
                'label' => esc_html__( 'Tab Content Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'tab_content',
                        'label' => esc_html__( 'Tab Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum is simply dummy text of the printing and typesetting industry.been the industrys stanLorem Ipsum has.', 'cras' ),
                        'label_block' => true,
                        'placeholder' => esc_html__( 'Enter tab Content', 'cras' ),
                    ],
                    [
                        'name' => 'tab_bg_txt',
                        'label' => esc_html__( 'Background Text', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'About Company', 'cras' ),
                        'label_block' => true,
                        'placeholder' => esc_html__( 'Enter tab background text', 'cras' ),
                    ],
                ],
                'title_field' => '{{{ tab_bg_txt }}}',
            ],
			
        );

        $this->end_controls_section();
    }
	
	protected function render() {
        $settings = $this->get_settings_for_display();

    echo '<div class="ak-height-125 ak-height-lg-80"></div>
        <div class="container '. $settings['ex_class'] .'">
            <div class="company-tab">
                <ul class="tabs">';
if(!empty($settings['tab_title1'])){                
    echo'                <li class="active-tab">'. $settings['tab_title1'] .'</li>';
} if(!empty($settings['tab_title2'])){    
    echo'                <li>'. $settings['tab_title2'] .'</li>';
} if(!empty($settings['tab_title3'])){     
    echo'                <li>'. $settings['tab_title3'] .'</li>';
} if(!empty($settings['tab_title4'])){     
    echo'                <li>'. $settings['tab_title4'] .'</li>';
} if(!empty($settings['tab_title5'])){     
    echo'                <li>'. $settings['tab_title5'] .'</li>';
}    
    echo'             </ul>

                <div class="tabs-content">';

foreach ( $settings['tab_rptr'] as $tab_details ) :
    echo '<div class="list">
            <div class="ak-section-heading ak-style-1 ak-type-1">
                <div class="background-text">'. $tab_details['tab_bg_txt'] .'</div>
                <h3 class="desp"> '. $tab_details['tab_content'] .' </h3>
            </div>
        </div>';
endforeach;

    echo 		'</div>
                </div>
            </div>'; 
    }
	protected function _content_template() {

    }
}
