<?php

namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_sld3 extends Widget_Base {
	
	public function get_name() {
		return 'widget-slider3';
	}
	
	public function get_title() {
		return 'Home Video Slider';
	}
	
	public function get_icon() {
		return 'eicon-slider-album';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Slider Content', 'cras' ),
			]
		);

//Social-connections
		$this->add_control(
			'home_sld_sl_title',
			[
				'label' => esc_html__( 'Social Link Area Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'FOLLOW US', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Title', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_fb',
			[
				'label' => esc_html__( 'Facebook url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Facebook url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_ld',
			[
				'label' => esc_html__( 'Linkedin url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Linkedin url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_tw',
			[
				'label' => esc_html__( 'Twitter url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Twitter url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_inst',
			[
				'label' => esc_html__( 'Instagram url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Instagram url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_drb',
			[
				'label' => esc_html__( 'Dribbble url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Dribbble url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_flc',
			[
				'label' => esc_html__( 'Flickr url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Flickr url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_tmb',
			[
				'label' => esc_html__( 'Tumblr url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Tumblr url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_pnt',
			[
				'label' => esc_html__( 'Pinterest url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Pinterest url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_gp',
			[
				'label' => esc_html__( 'Google Plus url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Twitter url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_yt',
			[
				'label' => esc_html__( 'YouTube url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required YouTube url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_vm',
			[
				'label' => esc_html__( 'Vimeo url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Vimeo url/link', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'home_sld_rptr',
            [
                'label' => esc_html__( 'Slider Item Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'home_sld_vd',
						'label' => esc_html__( 'Slide Video', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                    [
                        'name' => 'home_sld_title',
                        'label' => esc_html__( 'Slide Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Car Workshop & Wheel', 'cras' ),
                        'show_label' => true,
                    ],
					[
                        'name' => 'home_sld_title2',
                        'label' => esc_html__( 'Slide Title Two', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Services', 'cras' ),
                        'show_label' => true,
                    ],
                    [
                        'name' => 'home_sld_desc',
                        'label' => esc_html__( 'Slide Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Our skilled team of certified technicians is here to provide top-notch car repair and auto services to ensure your vehicle performs at its best. Our skilled team of certified technicians.', 'cras' ),
                        'show_label' => true,
                    ],
					[
                        'name' => 'home_sld_btn',
                        'label' => esc_html__( 'Button Text', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'APPOINTMENT', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'home_sld_btn_url',
                        'label' => esc_html__( 'Button URL', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '#', 'cras' ),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ home_sld_title }}}',
            ],
			
        );

		$this->end_controls_section();
	}
	
	protected function render() {


    $settings = $this->get_settings_for_display();
	$cras_options = get_option('cras_options');
	if(isset($cras_options['cras_addricon_color'])){
        $addricon_color = $cras_options['cras_addricon_color'];
    }

echo '<section class="ak-slider ak-slider-hero-three '. $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
			<div class="swiper-wrapper">';

		foreach ( $settings['home_sld_rptr'] as $home_sld_details ) :
			echo '<div class="swiper-slide">
					<div class="ak-hero ak-style1 slide-inner style-three">

						<video autoplay muted loop playsinline class="ak-hero-bg ak-bg object-cover">
							<source src="'. $home_sld_details['home_sld_vd']['url'] .'" type="video/mp4" />
							Your browser does not support the video tag.
						</video>

							<div class="hero-slider-info style-three">
								<div class="slider-info">
									<div class="hero-title">
										<h1 class="hero-main-title" data-swiper-parallax="300">'. $home_sld_details['home_sld_title'] .'</h1>
										<h1 class="hero-main-title-1 style-2" data-swiper-parallax="100">'. $home_sld_details['home_sld_title2'] .'</h1>
										
										<p class="mini-title" data-swiper-parallax="400">'. $home_sld_details['home_sld_desc'] .'</p>
									</div>
									<div class="ak-height-45 ak-height-lg-30"></div>
									<div data-swiper-parallax="300">
										<a href="'. $home_sld_details['home_sld_btn_url'] .'" class="common-btn">
										'. $home_sld_details['home_sld_btn'] .'
										</a>
									</div>
								</div>
							</div>
						</div>
					</div>';
		endforeach;

echo '</div>';

echo '<div class="ak-swiper-controll-hero-3">
		<div class="ak-swiper-navigation-wrap">
			<div class="ak-swiper-button-prev slider-three">
				<div class="hero-swiper-prev">
					<div class="btn-cricle ak-white-bg-1"></div>
					<div class="btn-arrow">
						<svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41"
							fill="none">
							<path
								d="M1.82581 20.0839L7.72307 14.1866C7.93491 13.9392 8.3072 13.9104 8.55457 14.1223C8.80194 14.3341 8.83078 14.7064 8.61889 14.9538C8.59912 14.9769 8.57763 14.9984 8.55457 15.0181L3.66574 19.9129H20.0831C20.4088 19.9129 20.6729 20.1769 20.6729 20.5026C20.6729 20.8284 20.4088 21.0924 20.0831 21.0924H3.66574L8.55457 25.9812C8.80194 26.193 8.83078 26.5653 8.61889 26.8127C8.40699 27.0601 8.03475 27.0889 7.78738 26.877C7.76432 26.8572 7.74278 26.8358 7.72307 26.8127L1.82575 20.9154C1.59714 20.6854 1.59714 20.314 1.82581 20.0839Z"
								fill="#fff" />
						</svg>
					</div>
				</div>
			</div>
			<div class="ak-swiper-button-next slider-three">
				<div class="hero-swiper-next">
					<div class="btn-cricle ak-white-bg-1"></div>
					<div class="btn-arrow ">
						<svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41"
							fill="none">
							<path
								d="M20.5013 20.0839L14.6041 14.1866C14.3922 13.9392 14.0199 13.9104 13.7726 14.1223C13.5252 14.3341 13.4964 14.7064 13.7083 14.9538C13.728 14.9769 13.7495 14.9984 13.7726 15.0181L18.6614 19.9129H2.24401C1.91834 19.9129 1.6543 20.1769 1.6543 20.5026C1.6543 20.8284 1.91834 21.0924 2.24401 21.0924H18.6614L13.7726 25.9812C13.5252 26.193 13.4964 26.5653 13.7083 26.8127C13.9202 27.0601 14.2924 27.0889 14.5398 26.877C14.5628 26.8572 14.5844 26.8358 14.6041 26.8127L20.5014 20.9154C20.73 20.6854 20.73 20.314 20.5013 20.0839Z"
								fill="#fff" />
						</svg>
					</div>
				</div>
			</div>
		</div>';	

echo '<div><div class="social-hero-two">';
if(!empty($settings['home_sld_sl_title'])) {
echo'	<h6 class="social-link">'. $settings['home_sld_sl_title'] .'</h6>
		<div class="social-horizontal"></div>';
	}
if(!empty($settings['home_sld_left_fb'])) {
echo'	<a href="'. $settings['home_sld_left_fb'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                            <g clip-path="url(#clip0_1730_636)">
                                <path
                                    d="M9.24482 16.3712V9.07334H11.6934L12.0608 6.2284H9.24482V4.41233C9.24482 3.58891 9.47253 3.02777 10.6546 3.02777L12.1599 3.02715V0.482539C11.8996 0.448711 11.006 0.371155 9.96603 0.371155C7.79435 0.371155 6.30758 1.69673 6.30758 4.13057V6.2284H3.85156V9.07334H6.30758V16.3712H9.24482Z"
                                    fill="white" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1730_636">
                                    <rect width="16" height="16" fill="white"
                                        transform="translate(0.00585938 0.371155)" />
                                </clipPath>
                            </defs>
                        </svg>
		</a>';
} if(!empty($settings['home_sld_left_ld'])) {
echo'	<a href="'. $settings['home_sld_left_ld'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17" fill="none">
                            <g clip-path="url(#clip0_1730_638)">
                                <path
                                    d="M16.0017 16.3712L16.0057 16.3705V10.5025C16.0057 7.63183 15.3877 5.4205 12.0317 5.4205C10.4184 5.4205 9.33571 6.30584 8.89371 7.14517H8.84704V5.6885H5.66504V16.3705H8.97837V11.0812C8.97837 9.6885 9.24237 8.34184 10.967 8.34184C12.6664 8.34184 12.6917 9.93117 12.6917 11.1705V16.3712H16.0017Z"
                                    fill="white" />
                                <path d="M0.27002 5.68915H3.58735V16.3711H0.27002V5.68915Z" fill="white" />
                                <path
                                    d="M1.92719 0.371155C0.866526 0.371155 0.00585938 1.23182 0.00585938 2.29249C0.00585938 3.35316 0.866526 4.23182 1.92719 4.23182C2.98786 4.23182 3.84853 3.35316 3.84853 2.29249C3.84786 1.23182 2.98719 0.371155 1.92719 0.371155Z"
                                    fill="white" />
                            </g>
                            <defs>
                                <clipPath id="clip0_1730_638">
                                    <rect width="16" height="16" fill="white"
                                        transform="translate(0.00585938 0.371155)" />
                                </clipPath>
                            </defs>
                        </svg>
		</a>';
} if(!empty($settings['home_sld_left_tw'])) {
	echo'	<a href="'. $settings['home_sld_left_tw'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                            <path
                                d="M11.4952 9.14606L17.3234 2.37115H15.9423L10.8816 8.25371L6.83966 2.37115L2.17773 2.37115L8.28998 11.2666L2.17773 18.3712H3.55893L8.90316 12.159L13.1718 18.3712H17.8337L11.4948 9.14606H11.4952ZM9.60342 11.345L8.98412 10.4592L4.05659 3.41089L6.17803 3.41089L10.1546 9.09911L10.7739 9.9849L15.943 17.3787H13.8215L9.60342 11.3453V11.345Z"
                                fill="white" />
                        </svg>
		</a>';

} if(!empty($settings['home_sld_left_inst'])) {
	echo'	<a href="'. $settings['home_sld_left_inst'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/instagram.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_drb'])) {
	echo'	<a href="'. $settings['home_sld_left_drb'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/dribbble.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_pnt'])) {
	echo'	<a href="'. $settings['home_sld_left_pnt'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/pinterest.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_gp'])) {
	echo'	<a href="'. $settings['home_sld_left_gp'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/google-plus.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_tmb'])) {
	echo'	<a href="'. $settings['home_sld_left_tmb'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/tumblr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_beh'])) {
	echo'	<a href="'. $settings['home_sld_left_beh'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/behance.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_flc'])) {
	echo'	<a href="'. $settings['home_sld_left_flc'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/flickr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_vm'])) {
	echo'	<a href="'. $settings['home_sld_left_vm'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/vimeo.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';	
} if(!empty($settings['home_sld_left_yt'])) {
	echo'	<a href="'. $settings['home_sld_left_yt'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/youtube.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';																				

} 		
echo'	</div>';
echo'	</div>';
echo'	</div>';	

echo '</section>';	 

	}
	
	protected function _content_template() {

    }
}