<?php

namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_sld2 extends Widget_Base {
	
	public function get_name() {
		return 'widget-slider2';
	}
	
	public function get_title() {
		return 'Home Slider Two';
	}
	
	public function get_icon() {
		return 'eicon-slider-album';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Slider Content', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'home_sld2_rptr',
            [
                'label' => esc_html__( 'Slider Item Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'home_sld2_img',
						'label' => esc_html__( 'Slide Image', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                    [
                        'name' => 'home_sld2_title',
                        'label' => esc_html__( 'Slide Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Car Repair & Auto Services', 'cras' ),
                    ],
                    [
                        'name' => 'home_sld2_desc',
                        'label' => esc_html__( 'Slide Description', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Our skilled team of certified technicians is here to provide top-notch car repair and auto services to ensure your vehicle performs at its best. Our skilled team of certified technicians.', 'cras' ),
                        
                    ],
					[
                        'name' => 'home_sld2_btn',
                        'label' => esc_html__( 'Button Text', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'APPOINTMENT', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'home_sld2_btn_url',
                        'label' => esc_html__( 'Button URL', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '#', 'cras' ),
                        'label_block' => true,
                    ],

					//Social-connections
					[
						'name' => 'home_sld2_sl_title',
						'label' => esc_html__( 'Slcial Link Area Title', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( 'FOLLOW US', 'cras' ),
						
					],
					[
						'name' => 'home_sld2_fb',
						'label' => esc_html__( 'Facebook url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_ld',
						'label' => esc_html__( 'Linkedin url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_tw',
						'label' => esc_html__( 'Twitter url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_inst',
						'label' => esc_html__( 'Instagram url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_drb',
						'label' => esc_html__( 'Dribbble url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_flc',
						'label' => esc_html__( 'Flickr url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_tmb',
						'label' => esc_html__( 'Tumblr url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_pnt',
						'label' => esc_html__( 'Pinterest url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_gp',
						'label' => esc_html__( 'Google Plus url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
						
					],
					[
						'name' => 'home_sld2_yt',
						'label' => esc_html__( 'YouTube url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
					[
						'name' => 'home_sld2_vm',
						'label' => esc_html__( 'Vimeo url', 'cras' ),
						'type' => Controls_Manager::TEXT,
						'default' => esc_html__( '#', 'cras' ),
					],
                ],
                'title_field' => '{{{ home_sld2_title }}}',
            ],
			
        );

		$this->end_controls_section();
	}
	
	protected function render() {


    $settings = $this->get_settings_for_display();

echo '<section class="ak-slider ak-slider-hero-two-1 '. $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
			<div class="swiper-wrapper">';

		foreach ( $settings['home_sld2_rptr'] as $home_sld2_details ) :
			echo '<div class="swiper-slide">
					<div class="ak-hero ak-style1 slide-inner style-two">
						<img src="'. $home_sld2_details['home_sld2_img']['url'] .'" class="ak-hero-bg ak-bg object-cover" alt="'.get_bloginfo( 'name', 'display' ).'">
						<div class="container">
							<div class="hero-slider-info style-two">
								<div class="slider-info">

									<div class="hero-title">
										<h1 class="hero-main-title style-2" data-swiper-parallax="300">'. $home_sld2_details['home_sld2_title'] .'</h1>
										
										<p class="mini-title" data-swiper-parallax="400">'. $home_sld2_details['home_sld2_desc'] .'</p>
									</div>

									<div class="ak-height-45 ak-height-lg-30"></div>
									<div data-swiper-parallax="300">
										<a href="'. $home_sld2_details['home_sld2_btn_url'] .'" class="common-btn">
										'. $home_sld2_details['home_sld2_btn'] .'
										</a>
									</div>';

echo'								<div class="social-hero-two">';
									if(!empty($home_sld2_details['home_sld2_sl_title'])) {
echo'									<h6 class="social-link">'. $home_sld2_details['home_sld2_sl_title'] .'</h6>
										<div class="social-horizontal"></div>';
									}
									if(!empty($home_sld2_details['home_sld2_fb'])) {
										echo'	<a href="'. $home_sld2_details['home_sld2_fb'] .'" class="social-icon1">
													<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17"
                                            viewBox="0 0 16 17" fill="none">
                                            <g clip-path="url(#clip0_1730_636)">
                                                <path
                                                    d="M9.24482 16.3712V9.07334H11.6934L12.0608 6.2284H9.24482V4.41233C9.24482 3.58891 9.47253 3.02777 10.6546 3.02777L12.1599 3.02715V0.482539C11.8996 0.448711 11.006 0.371155 9.96603 0.371155C7.79435 0.371155 6.30758 1.69673 6.30758 4.13057V6.2284H3.85156V9.07334H6.30758V16.3712H9.24482Z"
                                                    fill="white" />
                                            </g>
                                            <defs>
												</a>';
										} if(!empty($home_sld2_details['home_sld2_ld'])) {
										echo'	<a href="'. $home_sld2_details['home_sld2_ld'] .'" class="social-icon1">
													<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17"
                                            viewBox="0 0 16 17" fill="none">
                                            <g clip-path="url(#clip0_1730_638)">
                                                <path
                                                    d="M16.0017 16.3712L16.0057 16.3705V10.5025C16.0057 7.63183 15.3877 5.4205 12.0317 5.4205C10.4184 5.4205 9.33571 6.30584 8.89371 7.14517H8.84704V5.6885H5.66504V16.3705H8.97837V11.0812C8.97837 9.6885 9.24237 8.34184 10.967 8.34184C12.6664 8.34184 12.6917 9.93117 12.6917 11.1705V16.3712H16.0017Z"
                                                    fill="white" />
                                                <path d="M0.27002 5.68915H3.58735V16.3711H0.27002V5.68915Z"
                                                    fill="white" />
                                                <path
                                                    d="M1.92719 0.371155C0.866526 0.371155 0.00585938 1.23182 0.00585938 2.29249C0.00585938 3.35316 0.866526 4.23182 1.92719 4.23182C2.98786 4.23182 3.84853 3.35316 3.84853 2.29249C3.84786 1.23182 2.98719 0.371155 1.92719 0.371155Z"
                                                    fill="white" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_1730_638">
                                                    <rect width="16" height="16" fill="white"
                                                        transform="translate(0.00585938 0.371155)" />
                                                </clipPath>
                                            </defs>
                                        </svg>
												</a>';
										} if(!empty($home_sld2_details['home_sld2_tw'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_tw'] .'" class="social-icon1">
													<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21"
                                            viewBox="0 0 20 21" fill="none">
                                            <path
                                                d="M11.4952 9.14606L17.3234 2.37115H15.9423L10.8816 8.25371L6.83966 2.37115L2.17773 2.37115L8.28998 11.2666L2.17773 18.3712H3.55893L8.90316 12.159L13.1718 18.3712H17.8337L11.4948 9.14606H11.4952ZM9.60342 11.345L8.98412 10.4592L4.05659 3.41089L6.17803 3.41089L10.1546 9.09911L10.7739 9.9849L15.943 17.3787H13.8215L9.60342 11.3453V11.345Z"
                                                fill="white" />
                                        </svg>
												</a>';
										
										} if(!empty($home_sld2_details['home_sld2_inst'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_inst'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/instagram.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_drb'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_drb'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/dribbble.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_pnt'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_pnt'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/pinterest.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_gp'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_gp'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/google-plus.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_tmb'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_tmb'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/tumblr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_beh'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_beh'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/behance.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_flc'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_flc'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/flickr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';
										} if(!empty($home_sld2_details['home_sld2_vm'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_vm'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/vimeo.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';	
										} if(!empty($home_sld2_details['home_sld2_yt'])) {
											echo'	<a href="'. $home_sld2_details['home_sld2_yt'] .'" class="social-icon1">
														<img src="'. get_template_directory_uri().'/images/youtube.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
													</a>';									
										}	
echo'								</div>
								</div>
							</div>
						</div>
					</div>
				</div>';
		endforeach;																		
		
echo'	</div>';	

echo '</section>';	 

	}
	
	protected function _content_template() {

    }
}