<?php

namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_sld extends Widget_Base {
	
	public function get_name() {
		return 'widget-slider';
	}
	
	public function get_title() {
		return 'Home Slider';
	}
	
	public function get_icon() {
		return 'eicon-slider-album';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Slider Content', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_top_mail',
			[
				'label' => esc_html__( 'Email', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'example@email.com', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Email', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_top_addr',
			[
				'label' => esc_html__( 'Address', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '123 Maple Street Toronto, On, Canada', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Address', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_top_openhour',
			[
				'label' => esc_html__( 'Open Hours', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sun - Thu: Open 27/7', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Open Hours', 'cras' ),
			]
		);

//Social-connections
		$this->add_control(
			'home_sld_left_sl_title',
			[
				'label' => esc_html__( 'Social Link Area Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'FOLLOW US', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Title', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_fb',
			[
				'label' => esc_html__( 'Facebook url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Facebook url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_ld',
			[
				'label' => esc_html__( 'Linkedin url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Linkedin url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_tw',
			[
				'label' => esc_html__( 'Twitter url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Twitter url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_inst',
			[
				'label' => esc_html__( 'Instagram url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Instagram url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_drb',
			[
				'label' => esc_html__( 'Dribbble url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Dribbble url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_flc',
			[
				'label' => esc_html__( 'Flickr url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Flickr url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_tmb',
			[
				'label' => esc_html__( 'Tumblr url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Tumblr url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_pnt',
			[
				'label' => esc_html__( 'Pinterest url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Pinterest url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_gp',
			[
				'label' => esc_html__( 'Google Plus url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Twitter url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_yt',
			[
				'label' => esc_html__( 'YouTube url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required YouTube url/link', 'cras' ),
			]
		);
		$this->add_control(
			'home_sld_left_vm',
			[
				'label' => esc_html__( 'Vimeo url/link', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Vimeo url/link', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'home_sld_rptr',
            [
                'label' => esc_html__( 'Slider Item Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'home_sld_img',
						'label' => esc_html__( 'Slide Image', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                    [
                        'name' => 'home_sld_title',
                        'label' => esc_html__( 'Slide Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Car Repair & Auto Services', 'cras' ),
                        'show_label' => false,
                    ],
                    [
                        'name' => 'home_sld_desc',
                        'label' => esc_html__( 'Slide Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Our skilled team of certified technicians is here to provide top-notch car repair and auto services to ensure your vehicle performs at its best. Our skilled team of certified technicians.', 'cras' ),
                        'show_label' => false,
                    ],
					[
                        'name' => 'home_sld_btn',
                        'label' => esc_html__( 'Button Text', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'APPOINTMENT', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'home_sld_btn_url',
                        'label' => esc_html__( 'Button URL', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '#', 'cras' ),
                        'label_block' => true,
                    ],
                ],
                'title_field' => '{{{ home_sld_title }}}',
            ],
			
        );

		$this->end_controls_section();
	}
	
	protected function render() {


    $settings = $this->get_settings_for_display();
	$cras_options = get_option('cras_options');
	if(isset($cras_options['cras_addricon_color'])){
        $addricon_color = $cras_options['cras_addricon_color'];
    }

echo '<section class="ak-slider ak-slider-hero-1 '. $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
			<div class="swiper-wrapper">';

		foreach ( $settings['home_sld_rptr'] as $home_sld_details ) :
		$home_sld_btn = $home_sld_details['home_sld_btn'];	
			echo '<div class="swiper-slide">
					<div class="ak-hero ak-style1 slide-inner">
						<img src="'. $home_sld_details['home_sld_img']['url'] .'" class="ak-hero-bg ak-bg object-cover" alt="'.get_bloginfo( 'name', 'display' ).'">
						<div class="container">
							<div class="hero-slider-info">
								<div class="slider-info">
									<div class="hero-title">
										<h1 class="hero-main-title" data-swiper-parallax="300">'. $home_sld_details['home_sld_title'] .'</h1>
										
										<p class="mini-title" data-swiper-parallax="400">'. $home_sld_details['home_sld_desc'] .'</p>
									</div>
									<div class="ak-height-45 ak-height-lg-30"></div>
									<div data-swiper-parallax="300">';
		if(!empty($home_sld_btn)){							
			echo'						<a href="'. $home_sld_details['home_sld_btn_url'] .'" class="common-btn">
										'. $home_sld_details['home_sld_btn'] .'
										</a>';
		}								
			echo'						</div>
								</div>
							</div>
						</div>
					</div>
				</div>';
		endforeach;

echo '</div>';

echo '<div class="ak-swiper-controll-hero-1">
		<div class="ak-swiper-navigation-wrap">
			<div class="ak-swiper-button-prev">
				<div class="hero-swiper-prev">
					<div class="btn-cricle ak-white-bg-1"></div>
					<div class="btn-arrow">
						<svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41"
							fill="none">
							<path
								d="M1.82581 20.0839L7.72307 14.1866C7.93491 13.9392 8.3072 13.9104 8.55457 14.1223C8.80194 14.3341 8.83078 14.7064 8.61889 14.9538C8.59912 14.9769 8.57763 14.9984 8.55457 15.0181L3.66574 19.9129H20.0831C20.4088 19.9129 20.6729 20.1769 20.6729 20.5026C20.6729 20.8284 20.4088 21.0924 20.0831 21.0924H3.66574L8.55457 25.9812C8.80194 26.193 8.83078 26.5653 8.61889 26.8127C8.40699 27.0601 8.03475 27.0889 7.78738 26.877C7.76432 26.8572 7.74278 26.8358 7.72307 26.8127L1.82575 20.9154C1.59714 20.6854 1.59714 20.314 1.82581 20.0839Z"
								fill="#fff" />
						</svg>
					</div>
				</div>
			</div>
			<div class="ak-swiper-button-next">
				<div class="hero-swiper-next">
					<div class="btn-cricle ak-white-bg-1"></div>
					<div class="btn-arrow ">
						<svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41"
							fill="none">
							<path
								d="M20.5013 20.0839L14.6041 14.1866C14.3922 13.9392 14.0199 13.9104 13.7726 14.1223C13.5252 14.3341 13.4964 14.7064 13.7083 14.9538C13.728 14.9769 13.7495 14.9984 13.7726 15.0181L18.6614 19.9129H2.24401C1.91834 19.9129 1.6543 20.1769 1.6543 20.5026C1.6543 20.8284 1.91834 21.0924 2.24401 21.0924H18.6614L13.7726 25.9812C13.5252 26.193 13.4964 26.5653 13.7083 26.8127C13.9202 27.0601 14.2924 27.0889 14.5398 26.877C14.5628 26.8572 14.5844 26.8358 14.6041 26.8127L20.5014 20.9154C20.73 20.6854 20.73 20.314 20.5013 20.0839Z"
								fill="#fff" />
						</svg>
					</div>
				</div>
			</div>
		</div>
	</div>';

echo '<div class="container">
		<div class="hero-contact-info">';
		
if(!empty($settings['home_sld_top_mail'])) {
echo '		<a href="mailto:'. $settings['home_sld_top_mail'] .'">
				<div class="d-flex align-items-center gap-2">
					<div class="heartbeat-icon">
						<svg width="61" height="60" viewBox="0 0 61 60" fill="none"
							xmlns="http://www.w3.org/2000/svg">
							<g opacity="0.5">
								<circle opacity="0.3" cx="30.5" cy="30" r="25" fill="'. esc_attr($addricon_color) .'" />
								<circle opacity="0.3" cx="30.5" cy="30" r="30" fill="'. esc_attr($addricon_color) .'" />
								<circle cx="30.5" cy="30" r="20" fill="'. esc_attr($addricon_color) .'" />
							</g>
							<g clip-path="url(#clip0_52_92)">
								<path
									d="M39.2141 38.8572C39.6637 38.8572 40.0533 38.7087 40.3844 38.4156L34.7181 32.7491C34.5821 32.8464 34.4504 32.9411 34.3259 33.0311C33.9019 33.3435 33.5577 33.5873 33.2934 33.762C33.0292 33.9371 32.6776 34.1156 32.2388 34.2978C31.7996 34.4802 31.3905 34.5711 31.011 34.5711H30.9999H30.9888C30.6092 34.5711 30.2001 34.4803 29.761 34.2978C29.3219 34.1156 28.9703 33.9371 28.7063 33.762C28.4421 33.5873 28.0981 33.3436 27.6738 33.0311C27.5556 32.9444 27.4245 32.8493 27.2827 32.7476L21.6153 38.4156C21.9465 38.7087 22.3363 38.8572 22.7858 38.8572H39.2141Z"
									fill="white" />
								<path
									d="M22.1274 29.1809C21.7033 28.8982 21.3273 28.5744 21 28.2097V36.8309L25.9943 31.8367C24.9951 31.1391 23.7078 30.2549 22.1274 29.1809Z"
									fill="white" />
								<path
									d="M39.8839 29.1809C38.3638 30.2098 37.0718 31.0955 36.0077 31.8386L41 36.8311V28.2097C40.6799 28.5671 40.308 28.8906 39.8839 29.1809Z"
									fill="white" />
								<path
									d="M39.2141 23.1428H22.7858C22.2127 23.1428 21.772 23.3364 21.4634 23.723C21.1544 24.1099 21.0002 24.5937 21.0002 25.1739C21.0002 25.6426 21.2049 26.1504 21.614 26.6975C22.0231 27.2444 22.4584 27.6739 22.9198 27.9864C23.1727 28.1651 23.9354 28.6953 25.2078 29.5769C25.8947 30.0529 26.4921 30.4678 27.0054 30.8258C27.4429 31.1307 27.8203 31.3947 28.1318 31.6138C28.1676 31.6389 28.2238 31.6791 28.2985 31.7325C28.3789 31.7902 28.4807 31.8636 28.6063 31.9542C28.8481 32.1291 29.0489 32.2705 29.2089 32.3785C29.3687 32.4865 29.5623 32.6071 29.7894 32.7411C30.0163 32.8749 30.2303 32.9756 30.4312 33.0425C30.6321 33.1094 30.8181 33.1429 30.9892 33.1429H31.0003H31.0114C31.1824 33.1429 31.3685 33.1094 31.5694 33.0425C31.7702 32.9756 31.9841 32.8752 32.2112 32.7411C32.438 32.6071 32.6314 32.4862 32.7916 32.3785C32.9516 32.2705 33.1525 32.1291 33.3943 31.9542C33.5196 31.8636 33.6214 31.7902 33.7019 31.7327C33.7765 31.6791 33.8328 31.6391 33.8687 31.6138C34.1114 31.4449 34.4897 31.182 34.9982 30.8289C35.9234 30.186 37.2861 29.2398 39.092 27.9864C39.6351 27.6071 40.0888 27.1493 40.4535 26.6137C40.8175 26.0782 41 25.5164 41 24.9286C41 24.4375 40.8231 24.0173 40.4699 23.6673C40.1164 23.3177 39.6978 23.1428 39.2141 23.1428Z"
									fill="white" />
							</g>
							<defs>
								<clipPath id="clip0_52_92">
									<rect width="20" height="20" fill="white" transform="translate(20.5 21)" />
								</clipPath>
							</defs>
						</svg>
					</div>
					<p class="ak-font-18 ak-white-color ak-semi-bold">'. $settings['home_sld_top_mail'] .'</p>
				</div>
			</a>';
} if(!empty($settings['home_sld_top_addr'])) {
echo '		<div class="d-flex align-items-center gap-2">
				<div class="heartbeat-icon">
					<svg width="61" height="60" viewBox="0 0 61 60" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<g opacity="0.5">
							<circle opacity="0.3" cx="30.5" cy="30" r="25" fill="'. esc_attr($addricon_color) .'" />
							<circle opacity="0.3" cx="30.5" cy="30" r="30" fill="'. esc_attr($addricon_color) .'" />
							<circle cx="30.5" cy="30" r="20" fill="'. esc_attr($addricon_color) .'" />
						</g>
						<path
							d="M30.5 21C26.9857 21 24.0547 23.8309 24.0547 27.4453C24.0547 28.8204 24.4679 30.0466 25.2609 31.1955L30.0068 38.601C30.237 38.961 30.7635 38.9603 30.9932 38.601L35.7597 31.1704C36.5356 30.0734 36.9453 28.7854 36.9453 27.4453C36.9453 23.8914 34.0539 21 30.5 21ZM30.5 30.375C28.8846 30.375 27.5703 29.0607 27.5703 27.4453C27.5703 25.83 28.8846 24.5156 30.5 24.5156C32.1154 24.5156 33.4297 25.83 33.4297 27.4453C33.4297 29.0607 32.1154 30.375 30.5 30.375Z"
							fill="white" />
						<path
							d="M35.0806 34.4646L32.1302 39.0774C31.3665 40.2681 29.6293 40.2642 28.8692 39.0786L25.914 34.4659C23.3138 35.067 21.7109 36.1683 21.7109 37.4844C21.7109 39.768 26.2394 41 30.5 41C34.7606 41 39.2891 39.768 39.2891 37.4844C39.2891 36.1674 37.6839 35.0655 35.0806 34.4646Z"
							fill="white" />
					</svg>
				</div>
				<p class="ak-font-18 ak-white-color ak-semi-bold">'. $settings['home_sld_top_addr'] .'</p>
			</div>';
} if(!empty($settings['home_sld_top_openhour'])) {
echo'		<div class="d-flex align-items-center gap-2">
				<div class="heartbeat-icon">
					<svg width="61" height="60" viewBox="0 0 61 60" fill="none" xmlns="http://www.w3.org/2000/svg">
						<g opacity="0.5">
							<circle opacity="0.3" cx="30.5" cy="30" r="25" fill="'. esc_attr($addricon_color) .'" />
							<circle opacity="0.3" cx="30.5" cy="30" r="30" fill="'. esc_attr($addricon_color) .'" />
							<circle cx="30.5" cy="30" r="20" fill="'. esc_attr($addricon_color) .'" />
						</g>
						<g clip-path="url(#clip0_52_110)">
							<path
								d="M25 22.6667C25.0884 22.6667 25.1732 22.6316 25.2357 22.569C25.2982 22.5065 25.3334 22.4217 25.3334 22.3333V21C25.3334 20.9116 25.2982 20.8268 25.2357 20.7643C25.1732 20.7018 25.0884 20.6667 25 20.6667C24.9116 20.6667 24.8268 20.7018 24.7643 20.7643C24.7018 20.8268 24.6667 20.9116 24.6667 21V22.3333C24.6667 22.4217 24.7018 22.5065 24.7643 22.569C24.8268 22.6316 24.9116 22.6667 25 22.6667Z"
								fill="white" />
							<path
								d="M29 22.6667C29.0884 22.6667 29.1732 22.6316 29.2357 22.569C29.2982 22.5065 29.3334 22.4217 29.3334 22.3333V21C29.3334 20.9116 29.2982 20.8268 29.2357 20.7643C29.1732 20.7018 29.0884 20.6667 29 20.6667C28.9116 20.6667 28.8268 20.7018 28.7643 20.7643C28.7018 20.8268 28.6667 20.9116 28.6667 21V22.3333C28.6667 22.4217 28.7018 22.5065 28.7643 22.569C28.8268 22.6316 28.9116 22.6667 29 22.6667Z"
								fill="white" />
							<path
								d="M37 22.6667C37.0884 22.6667 37.1732 22.6316 37.2357 22.569C37.2982 22.5065 37.3334 22.4217 37.3334 22.3333V21C37.3334 20.9116 37.2982 20.8268 37.2357 20.7643C37.1732 20.7018 37.0884 20.6667 37 20.6667C36.9116 20.6667 36.8268 20.7018 36.7643 20.7643C36.7018 20.8268 36.6667 20.9116 36.6667 21V22.3333C36.6667 22.4217 36.7018 22.5065 36.7643 22.569C36.8268 22.6316 36.9116 22.6667 37 22.6667Z"
								fill="white" />
							<path
								d="M33 22.6667C33.0884 22.6667 33.1732 22.6316 33.2357 22.569C33.2982 22.5065 33.3334 22.4217 33.3334 22.3333V21C33.3334 20.9116 33.2982 20.8268 33.2357 20.7643C33.1732 20.7018 33.0884 20.6667 33 20.6667C32.9116 20.6667 32.8268 20.7018 32.7643 20.7643C32.7018 20.8268 32.6667 20.9116 32.6667 21V22.3333C32.6667 22.4217 32.7018 22.5065 32.7643 22.569C32.8268 22.6316 32.9116 22.6667 33 22.6667Z"
								fill="white" />
							<path d="M32.3333 29.9503L30.6937 32H32.3333V29.9503Z" fill="white" />
							<path
								d="M21.6667 37.6667C21.6672 38.1085 21.843 38.5322 22.1554 38.8446C22.4679 39.157 22.8915 39.3328 23.3334 39.3333H38.6667C39.1086 39.3328 39.5322 39.157 39.8446 38.8446C40.1571 38.5322 40.3328 38.1085 40.3334 37.6667V24.6667H21.6667V37.6667ZM34.6667 34V32.3333C34.6667 32.2449 34.7018 32.1601 34.7643 32.0976C34.8268 32.0351 34.9116 32 35 32C35.0884 32 35.1732 32.0351 35.2357 32.0976C35.2982 32.1601 35.3334 32.2449 35.3334 32.3333V33.0613C35.4401 33.0219 35.5529 33.0011 35.6667 33C35.9319 33 36.1863 33.1054 36.3738 33.2929C36.5613 33.4804 36.6667 33.7348 36.6667 34V34.3333C36.6667 34.4217 36.6316 34.5065 36.5691 34.569C36.5065 34.6316 36.4218 34.6667 36.3334 34.6667C36.2449 34.6667 36.1602 34.6316 36.0977 34.569C36.0351 34.5065 36 34.4217 36 34.3333V34C36 33.9116 35.9649 33.8268 35.9024 33.7643C35.8399 33.7018 35.7551 33.6667 35.6667 33.6667C35.5783 33.6667 35.4935 33.7018 35.431 33.7643C35.3685 33.8268 35.3334 33.9116 35.3334 34V34.3333C35.3334 34.4217 35.2982 34.5065 35.2357 34.569C35.1732 34.6316 35.0884 34.6667 35 34.6667C34.9116 34.6667 34.8268 34.6316 34.7643 34.569C34.7018 34.5065 34.6667 34.4217 34.6667 34.3333V34ZM29.7397 32.125L32.4064 28.7917C32.4495 28.7377 32.5084 28.6985 32.5748 28.6794C32.6412 28.6604 32.7119 28.6624 32.7771 28.6853C32.8423 28.7082 32.8987 28.7508 32.9387 28.8071C32.9786 28.8635 33.0001 28.9309 33 29V32H33.6667C33.7551 32 33.8399 32.0351 33.9024 32.0976C33.9649 32.1601 34 32.2449 34 32.3333C34 32.4217 33.9649 32.5065 33.9024 32.569C33.8399 32.6316 33.7551 32.6667 33.6667 32.6667H33V34.3333C33 34.4217 32.9649 34.5065 32.9024 34.569C32.8399 34.6316 32.7551 34.6667 32.6667 34.6667C32.5783 34.6667 32.4935 34.6316 32.431 34.569C32.3685 34.5065 32.3334 34.4217 32.3334 34.3333V32.6667H30C29.9372 32.6667 29.8757 32.649 29.8225 32.6155C29.7693 32.5821 29.7267 32.5343 29.6995 32.4777C29.6723 32.4211 29.6616 32.358 29.6687 32.2956C29.6758 32.2332 29.7004 32.174 29.7397 32.125ZM27.2667 28.6667C27.9354 28.6667 29.2 29.055 29.2 30.5237C29.2 31.9153 27.743 33.25 26.7457 34H29.6667C29.7551 34 29.8399 34.0351 29.9024 34.0976C29.9649 34.1601 30 34.2449 30 34.3333C30 34.4217 29.9649 34.5065 29.9024 34.569C29.8399 34.6316 29.7551 34.6667 29.6667 34.6667H25.6667C25.5937 34.6667 25.5227 34.6427 25.4647 34.5985C25.4066 34.5543 25.3647 34.4922 25.3453 34.4218C25.3259 34.3515 25.3302 34.2767 25.3574 34.209C25.3846 34.1413 25.4333 34.0844 25.496 34.047C26.3407 33.5433 28.5334 31.9283 28.5334 30.5237C28.5334 29.377 27.395 29.3343 27.2667 29.3333C27.1033 29.3203 26.9391 29.3417 26.7845 29.396C26.6299 29.4503 26.4883 29.5364 26.369 29.6487C26.2497 29.761 26.1552 29.8971 26.0917 30.0481C26.0281 30.1992 25.9969 30.3618 26 30.5257C25.9992 30.6136 25.9638 30.6976 25.9013 30.7594C25.8389 30.8213 25.7546 30.856 25.6667 30.856C25.5786 30.8556 25.4942 30.8203 25.4321 30.7578C25.3699 30.6953 25.335 30.6108 25.335 30.5227C25.3299 30.2711 25.377 30.0211 25.4733 29.7886C25.5695 29.5561 25.7129 29.346 25.8944 29.1716C26.0759 28.9973 26.2915 28.8624 26.5277 28.7755C26.7639 28.6886 27.0155 28.6515 27.2667 28.6667Z"
								fill="white" />
							<path
								d="M38.6667 22H38V22.3333C38 22.5985 37.8947 22.8529 37.7071 23.0404C37.5196 23.228 37.2652 23.3333 37 23.3333C36.7348 23.3333 36.4805 23.228 36.2929 23.0404C36.1054 22.8529 36 22.5985 36 22.3333V22H34V22.3333C34 22.5985 33.8947 22.8529 33.7071 23.0404C33.5196 23.228 33.2652 23.3333 33 23.3333C32.7348 23.3333 32.4805 23.228 32.2929 23.0404C32.1054 22.8529 32 22.5985 32 22.3333V22H30V22.3333C30 22.5985 29.8947 22.8529 29.7071 23.0404C29.5196 23.228 29.2652 23.3333 29 23.3333C28.7348 23.3333 28.4805 23.228 28.2929 23.0404C28.1054 22.8529 28 22.5985 28 22.3333V22H26V22.3333C26 22.5985 25.8947 22.8529 25.7071 23.0404C25.5196 23.228 25.2652 23.3333 25 23.3333C24.7348 23.3333 24.4804 23.228 24.2929 23.0404C24.1054 22.8529 24 22.5985 24 22.3333V22H23.3334C22.8915 22.0005 22.4679 22.1763 22.1554 22.4887C21.843 22.8012 21.6672 23.2248 21.6667 23.6667V24H40.3334V23.6667C40.3328 23.2248 40.1571 22.8012 39.8446 22.4887C39.5322 22.1763 39.1086 22.0005 38.6667 22Z"
								fill="white" />
						</g>
						<defs>
							<clipPath id="clip0_52_110">
								<rect width="20" height="20" fill="white" transform="translate(20.5 20)" />
							</clipPath>
						</defs>
					</svg>

				</div>
				<p class="ak-font-18 ak-white-color ak-semi-bold">'. $settings['home_sld_top_openhour'] .'</p>
			</div>';
}
echo'	</div>
	</div>';
	
echo '<div class="hero-pagination">
		<div class="hero-swiper-pagination"></div>
	</div>';	

echo '<div class="social-hero">';
if(!empty($settings['home_sld_left_fb'])) {
echo'	<a href="'. $settings['home_sld_left_fb'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21" fill="none">
				<path
					d="M9.27491 8.83093L2.5 3.00265L2.5 4.38377L8.38256 9.44446L2.5 13.4864L2.5 18.1484L11.3955 12.0361L18.5 18.1484L18.5 16.7672L12.2878 11.4229L18.5 7.15432L18.5 2.49239L9.27491 8.83127L9.27491 8.83093ZM11.4738 10.7227L10.5881 11.342L3.53974 16.2695L3.53974 14.1481L9.22795 10.1715L10.1137 9.55219L17.5075 4.38311L17.5075 6.50455L11.4742 10.7227L11.4738 10.7227Z"
					fill="white" />
			</svg>
		</a>';
} if(!empty($settings['home_sld_left_ld'])) {
echo'	<a href="'. $settings['home_sld_left_ld'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
				<g clip-path="url(#clip0_64_135)">
					<path
						d="M16.5 0.324375L16.4993 0.320374L10.6313 0.320374C7.76068 0.320374 5.54935 0.938375 5.54935 4.29437C5.54935 5.90771 6.43468 6.99037 7.27401 7.43237L7.27401 7.47904L5.81735 7.47904L5.81735 10.661L16.4993 10.661L16.4993 7.34771L11.21 7.34771C9.81735 7.34771 8.47068 7.08371 8.47068 5.35904C8.47068 3.65971 10.06 3.63437 11.2993 3.63437L16.5 3.63437L16.5 0.324375Z"
						fill="white" />
					<path d="M5.81799 16.0564L5.81799 12.739L16.5 12.739L16.5 16.0564L5.81799 16.0564Z"
						fill="white" />
					<path
						d="M0.5 14.399C0.5 15.4597 1.36067 16.3204 2.42133 16.3204C3.482 16.3204 4.36067 15.4597 4.36067 14.399C4.36067 13.3384 3.482 12.4777 2.42133 12.4777C1.36067 12.4784 0.5 13.339 0.5 14.399Z"
						fill="white" />
				</g>
				<defs>
					<clipPath id="clip0_64_135">
						<rect width="17" height="16" fill="white" transform="translate(0.5 16.3204) rotate(-90)" />
					</clipPath>
				</defs>
			</svg>
		</a>';
} if(!empty($settings['home_sld_left_tw'])) {
	echo'	<a href="'. $settings['home_sld_left_tw'] .'" class="social-icon1">
			<svg xmlns="http://www.w3.org/2000/svg" width="17" height="17" viewBox="0 0 17 17" fill="none">
				<g clip-path="url(#clip0_64_133)">
					<path
						d="M16.5 7.08128L9.20218 7.08128L9.20218 4.63269L6.35725 4.26533L6.35725 7.08128L4.54118 7.08128C3.71776 7.08128 3.15661 6.85356 3.15661 5.67145L3.15599 4.16622L0.611384 4.16622C0.577556 4.42653 0.5 5.32007 0.5 6.36007C0.5 8.53175 1.82557 10.0185 4.25942 10.0185L6.35725 10.0185L6.35725 12.4745L9.20218 12.4745L9.20218 10.0185L16.5 10.0185L16.5 7.08128Z"
						fill="white" />
				</g>
				<defs>
					<clipPath id="clip0_64_133">
						<rect width="17" height="16" fill="white" transform="translate(0.5 16.3204) rotate(-90)" />
					</clipPath>
				</defs>
			</svg>
		</a>';

} if(!empty($settings['home_sld_left_inst'])) {
	echo'	<a href="'. $settings['home_sld_left_inst'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/instagram.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_drb'])) {
	echo'	<a href="'. $settings['home_sld_left_drb'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/dribbble.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_pnt'])) {
	echo'	<a href="'. $settings['home_sld_left_pnt'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/pinterest.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_gp'])) {
	echo'	<a href="'. $settings['home_sld_left_gp'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/google-plus.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_tmb'])) {
	echo'	<a href="'. $settings['home_sld_left_tmb'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/tumblr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_beh'])) {
	echo'	<a href="'. $settings['home_sld_left_beh'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/behance.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_flc'])) {
	echo'	<a href="'. $settings['home_sld_left_flc'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/flickr.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';
} if(!empty($settings['home_sld_left_vm'])) {
	echo'	<a href="'. $settings['home_sld_left_vm'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/vimeo.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';	
} if(!empty($settings['home_sld_left_yt'])) {
	echo'	<a href="'. $settings['home_sld_left_yt'] .'" class="social-icon1">
				<img src="'. get_template_directory_uri().'/images/youtube.png" width="17" height="17" alt="'.get_bloginfo('name', 'display').'" />
			</a>';																				

} if(!empty($settings['home_sld_left_sl_title'])) {
echo'	<div class="social-horizontal"></div>
		<h6 class="social-link">'. $settings['home_sld_left_sl_title'] .'</h6>';
}		
echo'	</div>';	

echo '</section>';	 

	}
	
	protected function _content_template() {

    }
}