<?php

namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_project_sld extends Widget_Base {
	
	public function get_name() {
		return 'widget-projects-slider';
	}
	
	public function get_title() {
		return 'Projects Slider';
	}
	
	public function get_icon() {
		return 'eicon-slider-3d';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Slider Content', 'cras' ),
			]
		);

		$this->add_control(
			'projects_sld_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get expert car repair and auto services at for a smooth, safe ride.', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Title', 'cras' ),
			]
		);
		$this->add_control(
			'projects_sld_sec_desc',
			[
				'label' => esc_html__( 'Section Description', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan. Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Description', 'cras' ),
			]
		);
		$this->add_control(
			'projects_sld_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Text', 'cras' ),
			]
		);
		$this->add_control(
			'projects_sld_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'VIEW MORE', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required URL', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'projects_sld_rptr',
            [
                'label' => esc_html__( 'Slider Item Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'projects_sld_img',
						'label' => esc_html__( 'Slide Image', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
					[
                        'name' => 'projects_sld_title',
                        'label' => esc_html__( 'Slide Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Project Slide', 'cras' ),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ projects_sld_title }}}',
            ],
			
        );

		$this->end_controls_section();
	}
	
	protected function render() {


    $settings = $this->get_settings_for_display();

echo '<div class="ak-height-125 ak-height-lg-80"></div>
	<div class="team-single-page-slider ak-slider '. $settings['ex_class'] .'">
		<div class="swiper-wrapper">';

		foreach ( $settings['projects_sld_rptr'] as $projects_sld_details ) :
			echo '<div class="swiper-slide">
					<img class="slide-img" src="'. $projects_sld_details['projects_sld_img']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'" />
				</div>';
		endforeach;
echo '</div>';
echo '<div class="team-single-page-swiper-controll">
            <div class="button-next button-style">
                <svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41" fill="none">
                    <path
                        d="M1.82581 20.0839L7.72307 14.1866C7.93491 13.9392 8.3072 13.9104 8.55457 14.1223C8.80194 14.3341 8.83078 14.7064 8.61889 14.9538C8.59912 14.9769 8.57763 14.9984 8.55457 15.0181L3.66574 19.9129H20.0831C20.4088 19.9129 20.6729 20.1769 20.6729 20.5026C20.6729 20.8284 20.4088 21.0924 20.0831 21.0924H3.66574L8.55457 25.9812C8.80194 26.193 8.83078 26.5653 8.61889 26.8127C8.40699 27.0601 8.03475 27.0889 7.78738 26.877C7.76432 26.8572 7.74278 26.8358 7.72307 26.8127L1.82575 20.9154C1.59714 20.6854 1.59714 20.314 1.82581 20.0839Z"
                        fill="#fff" />
                </svg>
            </div>
            <div class="button-prev button-style">
                <svg xmlns="http://www.w3.org/2000/svg" width="29" height="41" viewBox="0 0 29 41" fill="none">
                    <path
                        d="M20.5013 20.0839L14.6041 14.1866C14.3922 13.9392 14.0199 13.9104 13.7726 14.1223C13.5252 14.3341 13.4964 14.7064 13.7083 14.9538C13.728 14.9769 13.7495 14.9984 13.7726 15.0181L18.6614 19.9129H2.24401C1.91834 19.9129 1.6543 20.1769 1.6543 20.5026C1.6543 20.8284 1.91834 21.0924 2.24401 21.0924H18.6614L13.7726 25.9812C13.5252 26.193 13.4964 26.5653 13.7083 26.8127C13.9202 27.0601 14.2924 27.0889 14.5398 26.877C14.5628 26.8572 14.5844 26.8358 14.6041 26.8127L20.5014 20.9154C20.73 20.6854 20.73 20.314 20.5013 20.0839Z"
                        fill="#fff" />
                </svg>
            </div>
        </div>
    </div>';

echo '<div class="ak-height-75 ak-height-lg-50"></div>
    <div class="container">
        <div class="play-slider-heading">
            <div class="heading-area">
                <h3 class="title">
                    '. $settings['projects_sld_sec_title'] .'
                </h3>
            </div>
            <div class="desp-area">
                <p class="desp">
                    '. $settings['projects_sld_sec_desc'] .'
                </p>
                <a href="'. $settings['projects_sld_btn_url'] .'" class="common-btn"> '. $settings['projects_sld_btn_txt'] .' </a>
            </div>
        </div>
    </div>';	

	}
	
	protected function _content_template() {

    }
}