<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_pricing extends Widget_Base {
	
	public function get_name() {
		return 'widget-pricing';
	}
	
	public function get_title() {
		return 'Price Table';
	}
	
	public function get_icon() {
		return 'eicon-price-table';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'pricing_list',
			[
				'label' => __( 'Pricing Content', 'cras' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'pricing_style',
			[
				'label' => esc_html__( 'Choose Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'pr_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'pr_stl_2' => esc_html__( 'Style Two', 'cras' ),
					'pr_stl_3' => esc_html__( 'Style Three', 'cras' )
				],
				'default' => 'pr_stl_1',
				]
			);
			
			$this->add_control(
			'pr_sec_bg',
			[
				'label' => esc_html__( 'Section Background', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
					],
				'placeholder' => esc_html__( 'Enter the Background Image', 'cras' ),
				'condition' => [
					'pricing_style' => ['pr_stl_1', 'pr_stl_1']
				],
			]
		);

		$this->add_control(
			'pr_sec_tagline',
			[
				'label' => esc_html__( 'Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Pricing', 'cras' ),
				'placeholder' => esc_html__( 'Enter the Tagline', 'cras' ),
			]
		);

		$this->add_control(
			'pr_sec_title',
			[
				'label' => esc_html__( 'Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Pricing', 'cras' ),
				'placeholder' => esc_html__( 'Enter the title', 'cras' ),
			]
		);

		$this->add_control(
			'pr_sec_content',
			[
				'label' => esc_html__( 'Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan. Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'cras' ),
				'placeholder' => esc_html__( 'Enter the Content', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Extra Class', 'cras' ),
			]
		);

		$this->add_control(
			'pr_rptr',
			[
				'label' => esc_html__( 'Pricing Plan', 'cras' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => [
					[
							'name' => 'pr_active_table',
							'label' => esc_html__( 'Active Table', 'cras' ),
							'type' => Controls_Manager::SELECT,
							'options' => [
								'active' => esc_html__( 'Yes', 'cras' ),
								''  => esc_html__( 'No', 'cras' ),
							],
							'default' => '',
                    ],
                    [
                        'name' => 'pr_title',
                        'label' => esc_html__( 'Pricing Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Total Car Care', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_price',
                        'label' => esc_html__( 'Price', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '$599.99', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_pre_price',
                        'label' => esc_html__( 'Previous Price', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '$899.99', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature1',
                        'label' => esc_html__( 'Features-1', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Performance Tuning', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature2',
                        'label' => esc_html__( 'Features-2', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Exhaust System Installation', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature3',
                        'label' => esc_html__( 'Features-3', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Performance Brake Upgrade', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature4',
                        'label' => esc_html__( 'Features-4', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Interior Exterior Detailing', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature5',
                        'label' => esc_html__( 'Features-5', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Performance Tuning', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_feature6',
                        'label' => esc_html__( 'Features-6', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
						'default' => esc_html__( 'Interior Exterior Detailing', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_btn_txt1',
                        'label' => esc_html__( 'Button Text Part One', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Get Started', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_btn_txt2',
                        'label' => esc_html__( 'Button Text Part Two', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Get Started', 'cras' ),
                        'label_block' => true,
                    ],
					[
                        'name' => 'pr_btn_url',
                        'label' => esc_html__( 'BUtton URL', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '#', 'cras' ),
                        'label_block' => true,
                    ],
				],
				'title_field' => '{{{ pr_title }}}',
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

	$settings = $this->get_settings_for_display();

if($settings['pricing_style'] == 'pr_stl_1') {
	echo '<div class="ak-height-160 ak-height-lg-50"></div>
			<div class="ak-bg" data-src="'. $settings['pr_sec_bg']['url'] .'">
				<div class="ak-height-100 ak-height-lg-50"></div>
				<div class="container">
					<div class="center-section-heading" data-aos="fade-up">
						<div class="ak-section-heading ak-style-1 ak-type-1">
							<div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
							'. $settings['pr_sec_tagline'] .'</div>
							<h2 class="ak-section-title">
							'. $settings['pr_sec_title'] .'</h2>
							<p class="ak-section-subtitle">'. $settings['pr_sec_content'] .'</p>
						</div>
					</div>
					<div class="ak-height-50 ak-height-lg-50"></div>
					<div class="pricing">'; 	

	foreach ( $settings['pr_rptr'] as $pr_details ) :
		echo '<div class="pricing-card '. $pr_details['pr_active_table'] .'" data-aos="fade-up">
		<div class="pricing-heading">
			<p class="title">'. $pr_details['pr_title'] .'</p>
			<h2 class="discount-price">'. $pr_details['pr_price'] .'</h2>
			<h5 class="main-price">'. $pr_details['pr_pre_price'] .'</h5>
		</div>
		<div class="opation-all">';
	if(!empty($pr_details['pr_feature1'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature1'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature2'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature2'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature3'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature3'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature4'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature4'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature5'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature5'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature6'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature6'] .'</p>
			</div>';
	}
	echo'</div>
		<a href="'. $pr_details['pr_btn_url'] .'" class="get-started-btn">
			<span>'. $pr_details['pr_btn_txt1'] .' <span>
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17"
						fill="none">
						<g clip-path="url(#clip0_147_83)">
							<path
								d="M8 0.273438C3.58866 0.273438 0 3.86209 0 8.27344C0 12.6848 3.58866 16.2734 8 16.2734C12.4113 16.2734 16 12.6848 16 8.27344C16 3.86209 12.4113 0.273438 8 0.273438ZM10.4713 8.74478L7.138 12.0781C7.008 12.2081 6.83734 12.2734 6.66666 12.2734C6.496 12.2734 6.32531 12.2081 6.19531 12.0781C5.93466 11.8174 5.93466 11.3961 6.19531 11.1354L9.05734 8.27344L6.19534 5.41144C5.93469 5.15078 5.93469 4.72944 6.19534 4.46878C6.456 4.20813 6.87734 4.20813 7.138 4.46878L10.4713 7.80212C10.732 8.06278 10.732 8.48409 10.4713 8.74478Z"
								fill="white" />
						</g>
						<defs>
							<clipPath>
								<rect width="16" height="16" fill="white"
									transform="translate(0 0.273438)" />
							</clipPath>
						</defs>
					</svg>
					<br>
				</span> '. $pr_details['pr_btn_txt2'] .' </span>
		</a>
	</div>';

	endforeach;

	echo' </div>
			</div>
			<div class="ak-height-100 ak-height-lg-80"></div>
		</div>';

} elseif($settings['pricing_style'] == 'pr_stl_2') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container">';
if(!empty($settings['pr_sec_title'])){
	echo'	<div class="center-section-heading" data-aos="fade-up">
				<div class="ak-section-heading ak-style-1 ak-type-1">
					<div class="background-text" data-aos="fade-left" data-aos-duration="1000">'. $settings['pr_sec_tagline'] .'</div>
					<h2 class="ak-section-title">'. $settings['pr_sec_title'] .'</h2>
					<p class="ak-section-subtitle">'. $settings['pr_sec_content'] .'</p>
				</div>
			</div>
			<div class="ak-height-50 ak-height-lg-50"></div>';
}
	echo'	<div class="pricing">'; 	

	foreach ( $settings['pr_rptr'] as $pr_details ) :
		echo '<div class="pricing-card '. $pr_details['pr_active_table'] .'" data-aos="fade-up">
		<div class="pricing-heading">
			<p class="title">'. $pr_details['pr_title'] .'</p>
			<h2 class="discount-price">'. $pr_details['pr_price'] .'</h2>
			<h5 class="main-price">'. $pr_details['pr_pre_price'] .'</h5>
		</div>
		<div class="opation-all">';
	if(!empty($pr_details['pr_feature1'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature1'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature2'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature2'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature3'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature3'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature4'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature4'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature5'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature5'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature6'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature6'] .'</p>
			</div>';
	}
	echo'</div>
		<a href="'. $pr_details['pr_btn_url'] .'" class="get-started-btn">
			<span>'. $pr_details['pr_btn_txt1'] .' <span>
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17"
						fill="none">
						<g clip-path="url(#clip0_147_83)">
							<path
								d="M8 0.273438C3.58866 0.273438 0 3.86209 0 8.27344C0 12.6848 3.58866 16.2734 8 16.2734C12.4113 16.2734 16 12.6848 16 8.27344C16 3.86209 12.4113 0.273438 8 0.273438ZM10.4713 8.74478L7.138 12.0781C7.008 12.2081 6.83734 12.2734 6.66666 12.2734C6.496 12.2734 6.32531 12.2081 6.19531 12.0781C5.93466 11.8174 5.93466 11.3961 6.19531 11.1354L9.05734 8.27344L6.19534 5.41144C5.93469 5.15078 5.93469 4.72944 6.19534 4.46878C6.456 4.20813 6.87734 4.20813 7.138 4.46878L10.4713 7.80212C10.732 8.06278 10.732 8.48409 10.4713 8.74478Z"
								fill="white" />
						</g>
						<defs>
							<clipPath>
								<rect width="16" height="16" fill="white"
									transform="translate(0 0.273438)" />
							</clipPath>
						</defs>
					</svg>
					<br>
				</span> '. $pr_details['pr_btn_txt2'] .' </span>
		</a>
	</div>';

	endforeach;

	echo' </div>
		</div>';
} elseif($settings['pricing_style'] == 'pr_stl_3') {
	echo '<div class="ak-height-125 ak-height-lg-50"></div>
			<div class="ak-bg">
				<div class="container">
					<div class="center-section-heading" data-aos="fade-up">
						<div class="ak-section-heading ak-style-1 ak-type-1">
							<div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
							'. $settings['pr_sec_tagline'] .'</div>
							<h2 class="ak-section-title">
							'. $settings['pr_sec_title'] .'</h2>
							<p class="ak-section-subtitle">'. $settings['pr_sec_content'] .'</p>
						</div>
					</div>
					<div class="ak-height-50 ak-height-lg-50"></div>
					<div class="pricing type-two">'; 	

	foreach ( $settings['pr_rptr'] as $pr_details ) :
	echo '<div class="pricing-card style-two '. $pr_details['pr_active_table'] .'" data-aos="fade-up">
		<div class="pricing-heading">
			<p class="title">'. $pr_details['pr_title'] .'</p>
			<h2 class="discount-price">'. $pr_details['pr_price'] .'</h2>
			<h5 class="main-price">'. $pr_details['pr_pre_price'] .'</h5>
		</div>
		<div class="opation-all">';
	if(!empty($pr_details['pr_feature1'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature1'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature2'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature2'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature3'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature3'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature4'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature4'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature5'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature5'] .'</p>
			</div>';
	} if(!empty($pr_details['pr_feature6'])) {
		echo'<div class="opation">
				<div class="icon"><svg width="27" height="27" viewBox="0 0 27 27" fill="none"
						xmlns="http://www.w3.org/2000/svg">
						<circle opacity="0.1" cx="13.5" cy="13.0654" r="13" fill="white" />
						<path
							d="M7.94379 12.4732C7.66765 12.4739 7.39737 12.5529 7.16423 12.7009C6.93108 12.8488 6.74459 13.0598 6.62634 13.3093C6.50808 13.5589 6.4629 13.8368 6.496 14.1109C6.52911 14.3851 6.63916 14.6442 6.81342 14.8585L10.5282 19.409C10.6606 19.5735 10.8304 19.704 11.0234 19.7897C11.2164 19.8753 11.4271 19.9137 11.6379 19.9016C12.0888 19.8774 12.4959 19.6362 12.7554 19.2396L20.4719 6.81218C20.4732 6.81012 20.4745 6.80806 20.4759 6.80603C20.5483 6.69486 20.5248 6.47455 20.3754 6.33615C20.3343 6.29815 20.2859 6.26895 20.2331 6.25035C20.1804 6.23176 20.1244 6.22416 20.0685 6.22803C20.0127 6.2319 19.9583 6.24716 19.9086 6.27286C19.8589 6.29856 19.815 6.33416 19.7796 6.37748C19.7768 6.38088 19.774 6.38423 19.771 6.38754L11.9888 15.1803C11.9592 15.2137 11.9233 15.241 11.883 15.2604C11.8428 15.2799 11.7991 15.2911 11.7545 15.2935C11.7099 15.2959 11.6652 15.2895 11.6231 15.2745C11.581 15.2595 11.5423 15.2363 11.5093 15.2062L8.92653 12.8559C8.65828 12.61 8.30768 12.4734 7.94379 12.4732Z"
							fill="white" />
					</svg>
				</div>
				<p class="title">'. $pr_details['pr_feature6'] .'</p>
			</div>';
	}
	echo'</div>
		<a href="'. $pr_details['pr_btn_url'] .'" class="get-started-btn">
			<span>'. $pr_details['pr_btn_txt1'] .' <span>
					<svg xmlns="http://www.w3.org/2000/svg" width="16" height="17" viewBox="0 0 16 17"
						fill="none">
						<g clip-path="url(#clip0_147_83)">
							<path
								d="M8 0.273438C3.58866 0.273438 0 3.86209 0 8.27344C0 12.6848 3.58866 16.2734 8 16.2734C12.4113 16.2734 16 12.6848 16 8.27344C16 3.86209 12.4113 0.273438 8 0.273438ZM10.4713 8.74478L7.138 12.0781C7.008 12.2081 6.83734 12.2734 6.66666 12.2734C6.496 12.2734 6.32531 12.2081 6.19531 12.0781C5.93466 11.8174 5.93466 11.3961 6.19531 11.1354L9.05734 8.27344L6.19534 5.41144C5.93469 5.15078 5.93469 4.72944 6.19534 4.46878C6.456 4.20813 6.87734 4.20813 7.138 4.46878L10.4713 7.80212C10.732 8.06278 10.732 8.48409 10.4713 8.74478Z"
								fill="white" />
						</g>
						<defs>
							<clipPath>
								<rect width="16" height="16" fill="white"
									transform="translate(0 0.273438)" />
							</clipPath>
						</defs>
					</svg>
					<br>
				</span> '. $pr_details['pr_btn_txt2'] .' </span>
		</a>
	</div>';

	endforeach;

	echo' </div>
		</div>
	</div>';

} 		

}
	
	protected function _content_template() {

    }
	
	
}