<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_osrv extends Widget_Base {
	
	public function get_name() {
		return 'our-services';
	}
	
	public function get_title() {
		return 'Our Services';
	}
	
	public function get_icon() {
		return 'eicon-favorite';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Services Content', 'cras' ),
			]
		);

		$this->add_control(
			'srv_style',
			[
				'label' => esc_html__( 'Service Styles', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'srv_stl'  => esc_html__( 'Select Service Style', 'cras' ),
					'srv_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'srv_stl_2' => esc_html__( 'Style Two', 'cras' ),
					'srv_stl_3' => esc_html__( 'Style Three', 'cras' ),
				],
				'default' => 'srv_stl_1',
			]
		);

		$this->add_control(
			'srv_tagline',
			[
				'label' => esc_html__( 'Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Services', 'cras' ),
				'condition' => [
					'srv_style' => ['srv_stl_1', 'srv_stl_3']
				],
                'placeholder' => esc_html__( 'Enter the tagline', 'cras' ),
			]
		);
		
		$this->add_control(
			'srv_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Dedicated Services', 'cras' ),
				'condition' => [
					'srv_style' => ['srv_stl_1', 'srv_stl_3']
				],
				'placeholder' => esc_html__( 'Enter the title', 'cras' ),
			]
		);

		$this->add_control(
			'srv_desc',
			[
				'label' => esc_html__( 'Section Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
				'condition' => [
					'srv_style' => ['srv_stl_1', 'srv_stl_3']
				],
				'placeholder' => esc_html__( 'Enter the Content', 'cras' ),
			]
		);

		$this->add_control(
			'srv_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'VIEW All SERVICES', 'cras' ),
				'condition' => [
					'srv_style' => 'srv_stl_1',
				],
                'placeholder' => esc_html__( 'Enter required Button Text', 'cras' ),
			]
		);

		$this->add_control(
			'srv_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
				'condition' => [
					'srv_style' => 'srv_stl_1',
				],
                'placeholder' => esc_html__( 'Enter required Button URL', 'cras' ),
			]
		);

		$this->add_control(
			'srv_pocat',
			[
				'label' => esc_html__( 'Post Category / Slug Name', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your required post category', 'cras' ),
			]
		);

		$this->add_control(
			'srv_post_no',
			[
				'label' => esc_html__( 'Post Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '3', 'cras' ),
                'placeholder' => esc_html__( 'Enter your required post number', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your require class', 'cras' ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

	$settings = $this->get_settings_for_display();

if($settings['srv_style'] == 'srv_stl_1') {	
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="d-flex justify-content-center '. $settings['ex_class'] .'">
			<div class="sticky-content container">
				<div class="content style_2">
					<div class="service">';

	global $post;
	$args=array('post_type' => 'services', 'services_category'=> $settings['srv_pocat'], 'showposts' => $settings['srv_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();             

	$srvs_image_port = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');
	$service_category = get_terms('services_category');
	$services_category = get_the_terms($post->ID ,'services_category');
	$services_categories = strip_tags( get_the_term_list($post->ID, 'services_category', '', ' , ', '') );

	echo' 			<div class="service-card" data-aos="fade-left">
						<a href="'. get_the_permalink() .'" class="card-img">
							<img src="'. $srvs_image_port .'" class="ak-bg" alt="'. get_bloginfo('display', 'name') .'">
						</a>
						<div class="card-info">
							<a href="'. get_the_permalink() .'" class="card-title">'. get_the_title() .'</a>
							<p class="card-desp">'. get_the_excerpt() .'</p>
							<a href="'. get_the_permalink() .'" class="more-btn">VIEW MORE</a>
						</div>
					</div>';

	endwhile;	
	wp_reset_postdata();

	echo'		</div>
			</div>
			<div class="sidebar width-none">
				<div class="services-content">
					<div class="ak-section-heading ak-style-1">
						<div class="background-text" data-aos="fade-right" data-aos-duration="1000">'. $settings['srv_tagline'] .'</div>
						<h2 class="ak-section-title">'. $settings['srv_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['srv_desc'] .'</p>
					</div>
					<div class="ak-height-50 ak-height-lg-10"></div>
					<a href="'. $settings['srv_btn_url'] .'" class="more-btn">'. $settings['srv_btn_txt'] .'</a>
				</div>
			</div>
		</div>
		</div>
		<div class="scroll-end-point"></div>';	

 } elseif ($settings['srv_style'] == 'srv_stl_2') {
	echo '<div class="ak-height-75 ak-height-lg-80"></div>
		<div class="container">
			<div class="row row-cols-xl-3 row-cols-md-2 row-cols-1 g-4">';

	global $post;	
	$args=array('post_type' => 'services', 'services_category'=> $settings['srv_pocat'], 'showposts' => $settings['srv_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();    
	$srvs_image_port = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');   
	
	add_filter('body_class', 'add_post_title_as_body_class');

	echo'		<div class="col">
					<div class="service-card-style-2" data-aos="fade-up">
						<div class="service-icon">
							<img src="'. $srvs_image_port .'" width="46" height="47" alt="'. get_bloginfo('display' ,'name') .'">
						</div>
						<div class="service-desp">
							<a href="'. get_the_permalink() .'" class="title">'. get_the_title() .'</a>
							<p class="desp">'. get_the_excerpt() .'</p>
							<a href="'. get_the_permalink() .'" class="more-btn">VIEW MORE</a>
						</div>
					</div>
				</div>';

	endwhile;
	wp_reset_postdata();

	echo'	</div>
		</div>';	
} elseif ($settings['srv_style'] == 'srv_stl_3') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container">
        <div class="center-section-heading" data-aos="fade-up">
            <div class="ak-section-heading ak-style-1">
                <div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
                    '. $settings['srv_tagline'] .'
                </div>
                <div class="text-md-center">
                    <h2 class="ak-section-title">'. $settings['srv_title'] .'</h2>
                    <p class="ak-section-subtitle"> '. $settings['srv_desc'] .' </p>
                </div>
            </div>
        </div>
        <div class="ak-height-50 ak-height-lg-50"></div>
        <div class="row row-cols-xl-3 row-cols-md-2 row-cols-1 g-4">';

	global $post;	
	$args=array('post_type' => 'services', 'services_category'=> $settings['srv_pocat'], 'showposts' => $settings['srv_post_no'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post();    
	$srvs_image_port = wp_get_attachment_image_url(get_post_thumbnail_id(), 'full');   
	
	add_filter('body_class', 'add_post_title_as_body_class');

	echo'		<div class="col">
					<div class="service-card-style-2 type-two" data-aos="fade-up">
						<div class="service-icon">
							<img src="'. $srvs_image_port .'" width="47" height="47" alt="'. get_bloginfo('display' ,'name') .'">
						</div>
						<div class="service-desp">
							<a href="'. get_the_permalink() .'" class="title">'. get_the_title() .'</a>
							<p class="desp">'. get_the_excerpt() .'</p>
							<div class=" view-more-btn">
								<a href="'. get_the_permalink() .'" class="more-btn">VIEW MORE</a>
							</div>
						</div>
					</div>
				</div>';

	endwhile;
	wp_reset_postdata();

	echo'	</div>
		</div>';	
}	

	}	

	protected function _content_template() {

    }
	
}