<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_htw_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-htw';
	}
	
	public function get_title() {
		return 'How We Work';
	}
	
	public function get_icon() {
		return 'eicon-hypster';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'htw_section',
            [
                'label' => esc_html__( 'HTW Content', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'htw_style',
			[
				'label' => esc_html__( 'Choose Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'htw_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'htw_stl_2' => esc_html__( 'Style Two', 'cras' ),
					'htw_stl_3' => esc_html__( 'Style Three', 'cras'),
                    'htw_stl_4' => esc_html__( 'Style Four', 'cras'),
				],
				'default' => 'htw_stl_1',
			]
		);
        
        $this->add_control(
			'htw_sec_tagline',
			[
				'label' => esc_html__( 'Section Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Proc/Feat', 'cras' ),
                'placeholder' => esc_html__( 'Enter the tagline', 'cras' ),
				'condition' => [
					'htw_style' => 'htw_stl_2',
				],
			]
		);
		
		$this->add_control(
			'htw_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Process / Feature', 'cras' ),
				'placeholder' => esc_html__( 'Enter the title', 'cras' ),
				'condition' => [
					'htw_style' => 'htw_stl_2',
				],
			]
		);

		$this->add_control(
			'htw_sec_content',
			[
				'label' => esc_html__( 'Section Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan. Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'cras' ),
				'placeholder' => esc_html__( 'Enter the Content', 'cras' ),
				'condition' => [
					'htw_style' => 'htw_stl_2',
				],
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'htw_rptr',
            [
                'label' => esc_html__( 'Idea Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
                        'name' => 'htw_num',
                        'label' => esc_html__( 'Stroke Number', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '01', 'cras' ),
                        
                    ],
                    [
						'name' => 'htw_img',
						'label' => esc_html__( 'Stroke Image', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                    [
                        'name' => 'htw_title',
                        'label' => esc_html__( 'Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'PERFOMANCE CHECK', 'cras' ),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'htw_content',
                        'label' => esc_html__( 'Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
                        'show_label' => false,
					]
                ],
                'title_field' => '{{{ htw_title }}}',
            ],
			
        );

        $this->end_controls_section();
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

if($settings['htw_style'] == 'htw_stl_1') {    
    echo '<div class="ak-height-125 ak-height-lg-80"></div>
        <section class="container '.  $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
            <div class="row row-cols-1 row-cols-xl-3 g-4">';

    foreach ( $settings['htw_rptr'] as $htw_details ) :    
        echo '<div class="service-progress-card" data-aos="fade-up">
                    <div class="progress-item">
                        <h4 class="ak-stroke-number">'. $htw_details['htw_num'] .'</h4>
                        <div class="ak-border-width"></div>
                    </div>
                    <div class="service-item">
                        <div class="heartbeat-icon">
                            <span class="ak-heartbeat-btn"><img src="'. $htw_details['htw_img']['url'] .'" alt="'. get_bloginfo( 'name', 'display' ) .'"></span>
                        </div>
                        <div class="service-info">
                            <h4 class="title">'. $htw_details['htw_title'] .'</h4>
                            <p class="desp">'. $htw_details['htw_content'] .'</p>
                        </div>
                    </div>
                </div>';
    endforeach;

    echo'   </div>
        </section>';

} elseif($settings['htw_style'] == 'htw_stl_2') { 
    echo '<div class="ak-height-125 ak-height-lg-80"></div>
    <div class="container '. $settings['ex_class'] .'">';
if(!empty($settings['htw_sec_title'])){
    echo'<div class="center-section-heading" data-aos="fade-down">
            <div class="ak-section-heading ak-style-1 ak-type-1">
                <div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
                    '. $settings['htw_sec_tagline'] .'
                </div>
                <h2 class="ak-section-title">'. $settings['htw_sec_title'] .'</h2>
                <p class="ak-section-subtitle">'. $settings['htw_sec_content'] .'</p>
            </div>
        </div>';
}
    echo'<div class="ak-height-50 ak-height-lg-50"></div>
        <div class="row  row-cols-1 row-cols-xl-3 g-4 ">';

    foreach ( $settings['htw_rptr'] as $htw_details ) :    
        echo '<div class="service-progress-card" data-aos-duration="600" data-aos="flip-left" data-aos-delay="100">
                    <div class="progress-item">
                        <h4 class="ak-stroke-number">'. $htw_details['htw_num'] .'</h4>
                        <div class="ak-border-width"></div>
                    </div>
                    <div class="service-item">
                        <div class="heartbeat-icon">
                            
                                <span class="ak-heartbeat-btn"><img src="'. $htw_details['htw_img']['url'] .'" alt="'. get_bloginfo( 'name', 'display' ) .'"></span>
                          
                        </div>
                        <div class="service-info">
                            <h4 class="title">'. $htw_details['htw_title'] .'</h4>
                            <p class="desp">'. $htw_details['htw_content'] .'</p>
                        </div>
                    </div>
                </div>';
    endforeach;

    echo'   </div>
        </div>';
} elseif($settings['htw_style'] == 'htw_stl_3') {    
    echo '<section class="container '.  $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
            <div class="row row-cols-1 row-cols-xl-3 g-4 service-progress-card-position-changes">';

    foreach ( $settings['htw_rptr'] as $htw_details ) :    
        echo '<div class="service-progress-card style-two">

                    <div class="service-item">

                        <div class="heartbeat-icon">
                            <span class="ak-heartbeat-btn"><img src="'. $htw_details['htw_img']['url'] .'" alt="'. get_bloginfo( 'name', 'display' ) .'"></span>                            
                        </div>

                        <div class="service-info">
                            <h4 class="title">'. $htw_details['htw_title'] .'</h4>
                            <p class="desp">'. $htw_details['htw_content'] .'</p>
                        </div>

                    </div>

                </div>';
    endforeach;

    echo'   </div>
        </section>';

} elseif($settings['htw_style'] == 'htw_stl_4') {    
    echo '<div class="ak-height-125 ak-height-lg-80"></div>
        <section class="container '.  $settings['ex_class'] .'"><h2 class="disp">Section Heading</h2>
            <div class="row row-cols-1 row-cols-xl-3 g-4">';

    foreach ( $settings['htw_rptr'] as $htw_details ) :    
        echo '<div class="service-progress-card style-three" data-aos="fade-up">
                    <div class="progress-item">
                        <h4 class="ak-stroke-number color-white">'. $htw_details['htw_num'] .'</h4>
                        <div class="ak-border-width"></div>
                    </div>
                    <div class="service-item">
                        <div class="heartbeat-icon">
                            <span class="ak-heartbeat-btn"><img src="'. $htw_details['htw_img']['url'] .'" alt="'. get_bloginfo( 'name', 'display' ) .'"></span>
                        </div>
                        <div class="service-info">
                            <h4 class="title">'. $htw_details['htw_title'] .'</h4>
                            <p class="desp">'. $htw_details['htw_content'] .'</p>
                        </div>
                    </div>
                </div>';
    endforeach;

    echo'   </div>
        </section>';       

	}

}
	
	protected function _content_template() {

    }	
}

