<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class Custom_git_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-git';
	}
	
	public function get_title() {
		return 'Get in Touch';
	}
	
	public function get_icon() {
		return 'eicon-pojome';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'git_section',
            [
                'label' => esc_html__( 'Content Details', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'git_title',
			[
				'label' => esc_html__( 'Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get in touch with our experts', 'cras' ),
                'placeholder' => esc_html__( 'Enter the Title', 'cras' ),
			]
		);

		$this->add_control(
			'git_desc',
			[
				'label' => esc_html__( 'Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Digital agency! We specialize in helping businesses like yours succeed online. From website design and development to digital marketing and advertising, we have the tools and expertise to elevate your online presence. Let us help you lione evolving world of digital to drive growth and reach your goals.', 'cras' ),
                'placeholder' => esc_html__( 'Enter Content', 'cras' ),
			]
		);

		$this->add_control(
			'git_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get in touch with us', 'cras' ),
                'placeholder' => esc_html__( 'Enter the Button Text', 'cras' ),
			]
		);

		$this->add_control(
			'git_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter the Button URL', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->end_controls_section();
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container '. $settings['ex_class'] .'">
			<div class="cta" data-aos="fade-right">';
if(!empty($settings['git_title'])) {			
	echo'		<span class="border-pr"></span>
				<span class="border-wh"></span>';
}				
	echo'		<div class="cta-info">
					<h2 class="cta-title" data-aos="fade-left" data-aos-delay="100">'. $settings['git_title'] .'</h2>
					<p class="cta-desp">'. $settings['git_desc'] .'</p>
					<a href="'. $settings['git_btn_url'] .'" class="cta-btn">
						<img src="'. get_template_directory_uri() .'/images/phone.svg" alt="'. get_bloginfo('name', 'display') .'">
						<span class="ms-2"> '. $settings['git_btn_txt'] .'</span>
					</a>
				</div>
			</div>
		</div>';		

	}
	
	protected function _content_template() {

    }	
}

