<?php
namespace Elementor;

class cras_widget_gallery extends Widget_Base {
	
	public function get_name() {
		return 'Our Gallery';
	}
	
	public function get_title() {
		return 'Gallery';
	}
	
	public function get_icon() {
		return 'eicon-gallery-grid';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Gallery Content', 'cras' ),
			]
		);

		$this->add_control(
			'gl_pono',
			[
				'label' => esc_html__( 'Post Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your required post number', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your require class', 'cras' ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

        $settings = $this->get_settings_for_display();
    
    echo '<div class="ak-height-75 ak-height-lg-80"></div>
		<section class="container '. $settings['ex_class'] .'">
			<div class="gallery" id="static-thumbnails">';

		global $post;	
		$args=array('post_type' => 'gallery', 'showposts' => $settings['gl_pono']);
		$query=new \WP_Query($args);
		while($query->have_posts()) : $query->the_post();	        

        $gl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), '');
        $portfolio_category = wp_get_post_terms($post->ID,'gallery_category');   
		$gl_type = get_post_meta($post->ID,'cras_gl_type', true);   

        echo '<div class="item ' . $gl_type . '">
				<a href="'. esc_url( $gl_image_port[0] ) .'">
					<img src="'. esc_url( $gl_image_port[0] ) .'" alt="'.get_bloginfo( 'name', 'display' ).'">
					<div class="frame gallery-hover-icon">
						<span>
							<img src="'. get_template_directory_uri() .'/images/zoom.svg" alt="'.get_bloginfo( 'name', 'display' ).'">
						</span>
					</div>
				</a>
			</div>';

        endwhile;
		wp_reset_postdata();		

		echo '	</div>
			</section>';    
	
	}

	protected function _content_template() {

    }
	
	
}