<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_FunFact_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-funfact';
	}
	
	public function get_title() {
		return 'FunFact';
	}
	
	public function get_icon() {
		return 'eicon-counter';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'funfact_section',
            [
                'label' => esc_html__( 'FunFact Content', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
			'funfact_style',
			[
				'label' => esc_html__( 'Choose Funfuct Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'fnf_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'fnf_stl_2' => esc_html__( 'Style Two', 'cras' )
				],
				'default' => 'fnf_stl_1',
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'funfact_rptr',
            [
                'label' => esc_html__( 'FunFact Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					
                    [
                        'name' => 'funfact_title',
                        'label' => esc_html__( 'Counter Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'Project Completed', 'cras' ),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'funfact_number',
                        'label' => esc_html__( 'Counter Number', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( '18500', 'cras' ),
                        'show_label' => false,
                    ],
                ],
                'title_field' => '{{{ funfact_title }}}',
            ],
			
        );

        $this->end_controls_section();
    }

	protected function render() {

    $settings = $this->get_settings_for_display();

if($settings['funfact_style'] == 'fnf_stl_1') {
	echo '<div class="ak-height-125 ak-height-lg-80 "></div>
        <div class="container '. $settings['ex_class'] .'">
            <div class="row align-items-center gap-lg-0 gap-3" id="counter">';

foreach ( $settings['funfact_rptr'] as $funfact_details ) :
	echo '<div class="col-lg-4">
          <div class="ak-funfact ak-style1" data-aos="fade-up">
              <div class="ak-funfact-number">
                  <div>
                      <span class="ak-stroke-number counter" data-target="'. $funfact_details['funfact_number'] .'">255</span>
                  </div>
                  <div><span class="ak-stroke-number">+</span></div>
              </div>
              <div class="ak-funfact-text">
                  <p>'. $funfact_details['funfact_title'] .'</p>
              </div>
          </div>
        </div>';
endforeach;					
			
	echo'		  </div>
        </div>';

} elseif($settings['funfact_style'] == 'fnf_stl_2') {
    echo '<div class="ak-height-125 ak-height-lg-80"></div>
        <div class="ak-primary-bg '. $settings['ex_class'] .'">
            <div class="ak-height-65 ak-height-lg-50"></div>
            <div class="container">
                <div class="row align-items-center gap-lg-0">';

foreach ( $settings['funfact_rptr'] as $funfact_details ) :
	echo '<div class="col-lg-4">
            <div class="ak-funfact ak-style1" data-aos="fade-up">
                <div class="ak-funfact-number color-1">
                    <div>
                        <span class="ak-stroke-number color-white">'. $funfact_details['funfact_number'] .'</span>
                    </div>
                    <div><span class="ak-stroke-number color-white">+</span></div>
                </div>
                <div class="ak-funfact-text">
                    <p>'. $funfact_details['funfact_title'] .'</p>
                </div>
            </div>
        </div>';
endforeach;					
			
	echo'	    </div>
            </div>
            <div class="ak-height-65 ak-height-lg-50"></div>
        </div>';
}
             

	}
	
	protected function _content_template() {

    }	
}

