<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class Custom_fesm_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-fesm';
	}
	
	public function get_title() {
		return 'Featured Member';
	}
	
	public function get_icon() {
		return 'eicon-expand';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'fesm_section',
            [
                'label' => esc_html__( 'Member Details', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'fesm_img',
			[
				'label' => esc_html__( 'Member Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			],
		);

		$this->add_control(
			'fesm_name',
			[
				'label' => esc_html__( 'Name', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Michael Jack', 'cras' ),
                'placeholder' => esc_html__( 'Enter Name', 'cras' ),
			]
		);

		$this->add_control(
			'fesm_desg',
			[
				'label' => esc_html__( 'Designation', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Founder of Company', 'cras' ),
                'placeholder' => esc_html__( 'Enter Designation', 'cras' ),
			]
		);

		$this->add_control(
			'fesm_desc',
			[
				'label' => esc_html__( 'Description', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '“There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form injected humour, or randomised”', 'cras' ),
                'placeholder' => esc_html__( 'Enter Description', 'cras' ),
			]
		);

		$this->add_control(
			'fesm_vd',
			[
				'label' => esc_html__( 'Video URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'https://www.youtube.com/watch?v=VcaAVWtP48A', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Video URL', 'cras' ),
			]
		);

		$this->add_control(
			'fesm_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'https://www.youtube.com/watch?v=VcaAVWtP48A', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Button URL', 'cras' ),
			]
		);

		$this->add_control(
			'fesm_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'View More', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Button Text', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->end_controls_section();
    }

	protected function render() {


        $settings = $this->get_settings_for_display();

	echo '<div class="ak-height-75 ak-height-lg-75"></div>
			<div class="container '. $settings['ex_class'] .'">
				<div class="ceo-content">
					<div class="left-info" data-aos="fade-left" data-aos-delay="800">
						<img src="'. $settings['fesm_img']['url'] .'" alt="'. get_bloginfo('name', 'display') .'" class="img-fluid">
					</div>
					<div class="right-info" data-aos="fade-right" data-aos-delay="800">
						<div class="ceo-title">
							<div>
								<h5>'. $settings['fesm_name'] .'</h5>
								<p>'. $settings['fesm_desg'] .'</p>
							</div>
							<div>
								<span>
									<svg xmlns="http://www.w3.org/2000/svg" width="109" height="81" viewBox="0 0 109 81"
										fill="none">
										<g opacity="0.54" clip-path="url(#clip0_263_19)">
											<path
												d="M44.7042 9.09224L44.7046 9.09264C47.6942 12.2444 49.5884 15.4614 50.4749 18.952C51.3617 22.4437 51.2498 26.2476 50.1666 30.588C49.3293 33.9216 47.4174 38.4247 44.9636 43.3834C42.5138 48.3342 39.5389 53.7094 36.5939 58.7778C31.7042 67.1928 26.9046 74.7485 24.7444 78.0876C24.908 72.0925 25.2227 55.5759 24.9863 51.0284L24.9685 50.6853L24.6417 50.5789C19.667 48.96 16.0628 47.7354 13.0661 46.026C10.0899 44.3283 7.69924 42.1431 5.1941 38.5787C1.98444 34.0042 1.02823 27.9457 2.04838 22.0177C3.06824 16.0914 6.05577 10.3464 10.6624 6.41529C19.3069 -0.957044 35.1929 -0.95774 44.7042 9.09224Z"
												stroke="#FF3D24" />
											<path
												d="M106.512 30.5874L106.511 30.5881C105.678 33.9215 103.769 38.4246 101.317 43.3836C98.8697 48.3343 95.8964 53.7095 92.9523 58.7778C88.0609 67.1986 83.2583 74.7589 81.1003 78.0945C81.2559 72.1087 81.5832 55.5778 81.3467 51.0284L81.3289 50.6851L81.0019 50.5788C76.0194 48.9599 72.4114 47.7353 69.4147 46.026C66.4387 44.3284 64.0522 42.1435 61.5549 38.5793L61.5544 38.5786C58.3371 34.0042 57.3808 27.9459 58.4029 22.0178C59.4247 16.0916 62.416 10.3465 67.0229 6.41528C75.6675 -0.957189 91.5533 -0.957528 101.049 9.09193L101.049 9.09263C104.039 12.2446 105.937 15.4617 106.826 18.9522C107.714 22.4437 107.602 26.2474 106.512 30.5874Z"
												stroke="#FF3D24" />
										</g>
										<defs>
											<clipPath id="clip0_263_19">
												<rect width="108.235" height="80" fill="white"
													transform="translate(0 0.570953)" />
											</clipPath>
										</defs>
									</svg>
								</span>
							</div>
						</div>
						<div class="ceo-desp">
							<p class="desp">
							'. $settings['fesm_desc'] .'
							</p>
						</div>
						<div class="d-flex gap-3 align-items-center">
							<div>
								<a href="'. $settings['fesm_vd'] .'"
									class="ak-video-block ak-style1 ak-video-open type_2">
									<span class="ak-heartbeat-btn">
										<span></span>
									</span>
								</a>
							</div>
							<div>
								<a href="'. $settings['fesm_btn_url'] .'" class="more-btn ak-video-block ak-video-open">'. $settings['fesm_btn_txt'] .'</a>
							</div>
						</div>
					</div>
				</div>
			</div>';

	echo'	<div class="container">
				<div class="ak-height-75 ak-height-lg-75"></div>
				<div class="primary-color-border"></div>
				<div class="ak-height-75 ak-height-lg-75"></div>
			</div>';	 

	}
	
	protected function _content_template() {

    }	
}

