<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_FAQ_Widget extends \Elementor\Widget_Base {

	public function get_name() {
		return 'widget-faq';
	}
	
	public function get_title() {
		return 'FAQ';
	}
	
	public function get_icon() {
		return 'eicon-tabs';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}

    protected function _register_controls() {
        $this->start_controls_section(
            'faq_section',
            [
                'label' => esc_html__( 'FAQ', 'cras' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

		$this->add_control(
			'faq_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Frequently Asked Questions', 'cras' ),
                'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'faq_cnt_info_img',
			[
				'label' => esc_html__( 'Contact Info Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$this->add_control(
			'faq_cnt_info_title',
			[
				'label' => esc_html__( 'Contact Info Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Get in touch with our experts', 'cras' ),
                'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'faq_cnt_info_pn',
			[
				'label' => esc_html__( 'Contact / Phone No', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '(406) 555-0120', 'cras' ),
                'placeholder' => esc_html__( 'Enter Pnone Number', 'cras' ),
			]
		);

		$this->add_control(
			'faq_cnt_info_mail',
			[
				'label' => esc_html__( 'Contact Mail', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'example@email.com', 'cras' ),
                'placeholder' => esc_html__( 'Enter Mail Address', 'cras' ),
			]
		);

		$this->add_control(
			'faq_cnt_info_addr',
			[
				'label' => esc_html__( 'Contact Address', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '901 N Pitt Str., Suite 170 Alexandria, NY, USA', 'cras' ),
                'placeholder' => esc_html__( 'Enter Address', 'cras' ),
			]
		);

		$this->add_control(
			'faq_cnt_info_oph',
			[
				'label' => esc_html__( 'Open Hours', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sun - Thu: Open 27/7', 'cras' ),
                'placeholder' => esc_html__( 'Enter Mail Address', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter Required Extra Class', 'cras' ),
			]
		);

        $this->add_control(
            'faq_rptr',
            [
                'label' => esc_html__( 'FAQ Details', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
                    [
                        'name' => 'faq_title',
                        'label' => esc_html__( 'FAQ Title', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXT,
                        'default' => esc_html__( 'What is the design process for branding?', 'cras' ),
                        'label_block' => true,
                    ],
                    [
                        'name' => 'faq_content',
                        'label' => esc_html__( 'FAQ Content', 'cras' ),
                        'type' => \Elementor\Controls_Manager::TEXTAREA,
                        'default' => esc_html__( 'Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying conse quences lalin karar or one avoids a pain that produces no resultant pleasure. ', 'cras' ),
                        'show_label' => false,
                    ]
                ],
                'title_field' => '{{{ faq_title }}}',
            ],
			
        );

        $this->end_controls_section();
    }

	protected function render() {


        $settings = $this->get_settings_for_display();

	echo '<div class="ak-height-75 ak-height-lg-80"></div>
		<div class="container '. $settings['ex_class'].'">
			<h4 class="faq-images-title" data-aos="fade-left" data-aos-delay="700">'. $settings['faq_sec_title'] .'</h4>
			<div class="faq-images">
				<div class="faq" data-aos="fade-up" data-aos-delay="750">
					<div class="ak-accordion">';

foreach ( $settings['faq_rptr'] as $faq_details ) :
	echo 				'<div class="ak-accordion-item" data-aos="fade-up">
							<div class="ak-accordion-title">
								<h6>'. $faq_details['faq_title'] .'</h6>
							</div>
							<div class="ak-accordion-tab">
								'. $faq_details['faq_content'] .'
							</div>
						</div>';
endforeach;					
			
	echo'			</div>
				</div>

				<div class="images" data-aos="fade-up" data-aos-delay="950">
					<img src="'. $settings['faq_cnt_info_img']['url'] .'" class="img-bg-faq" alt="'. get_bloginfo('name', 'display') .'">
					<div class="images-info">
						<div class="cta-info d-flex align-items-center">
						<h2 class="cta-title" data-aos="fade-left" data-aos-delay="100">
						'. $settings['faq_cnt_info_title'] .'
						</h2>
					</div>
						<div class="d-flex align-items-center gap-3">
							<div class="heartbeat-icon">
								<a href="tel:'. $settings['faq_cnt_info_pn'] .'">
									<span class="ak-heartbeat-btn"><img src="'. get_template_directory_uri() .'/images/phone.svg" alt="'. get_bloginfo('name', 'display') .'"></span>
								</a>
							</div>
							<h3>'. $settings['faq_cnt_info_pn'] .'</h3>
						</div>
						<div class="d-flex align-items-center gap-3">
							<div class="heartbeat-icon">
								<a href="emailto:'. $settings['faq_cnt_info_mail'] .'">
									<span class="ak-heartbeat-btn"><img src="'. get_template_directory_uri() .'/images/email.svg" alt="'. get_bloginfo('name', 'display') .'"></span>
								</a>
							</div>
							<h3> '. $settings['faq_cnt_info_mail'] .'</h3>
						</div>
						<div class="ak-location">
							<a href="#" class="location text-hover-animaiton">
								<span class="me-1">
									<svg xmlns="http://www.w3.org/2000/svg" width="15" height="19" viewBox="0 0 15 19"
										fill="none">
										<path
											d="M7.83533 0.501953C3.9756 0.501953 0.835327 3.4927 0.835327 7.16863C0.835327 8.27215 1.12502 9.36629 1.67574 10.3368L7.45253 18.2871C7.52943 18.4198 7.67598 18.502 7.83533 18.502C7.99467 18.502 8.14122 18.4198 8.21813 18.2871L13.9971 10.3335C14.5456 9.36629 14.8353 8.27211 14.8353 7.16859C14.8353 3.4927 11.6951 0.501953 7.83533 0.501953ZM7.83533 10.502C5.90546 10.502 4.33535 9.0066 4.33535 7.16863C4.33535 5.33066 5.90546 3.83531 7.83533 3.83531C9.76519 3.83531 11.3353 5.33066 11.3353 7.16863C11.3353 9.0066 9.76519 10.502 7.83533 10.502Z"
											fill="white" />
									</svg>
								</span>
								'. $settings['faq_cnt_info_addr'] .'
							</a>
						</div>
						<div class="ak-date-time">
							<a href="#" class="date text-hover-animaiton d-flex align-items-center">
								<span class="me-1">
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="20" viewBox="0 0 21 20"
										fill="none">
										<g clip-path="url(#clip0_365_24357)">
											<path
												d="M5.33535 2.66895C5.42375 2.66895 5.50854 2.63383 5.57105 2.57131C5.63356 2.5088 5.66868 2.42402 5.66868 2.33561V1.00228C5.66868 0.913873 5.63356 0.829089 5.57105 0.766576C5.50854 0.704064 5.42375 0.668945 5.33535 0.668945C5.24694 0.668945 5.16216 0.704064 5.09965 0.766576C5.03713 0.829089 5.00201 0.913873 5.00201 1.00228V2.33561C5.00201 2.42402 5.03713 2.5088 5.09965 2.57131C5.16216 2.63383 5.24694 2.66895 5.33535 2.66895Z"
												fill="white" />
											<path
												d="M9.33535 2.66895C9.42375 2.66895 9.50854 2.63383 9.57105 2.57131C9.63356 2.5088 9.66868 2.42402 9.66868 2.33561V1.00228C9.66868 0.913873 9.63356 0.829089 9.57105 0.766576C9.50854 0.704064 9.42375 0.668945 9.33535 0.668945C9.24694 0.668945 9.16216 0.704064 9.09964 0.766576C9.03713 0.829089 9.00201 0.913873 9.00201 1.00228V2.33561C9.00201 2.42402 9.03713 2.5088 9.09964 2.57131C9.16216 2.63383 9.24694 2.66895 9.33535 2.66895Z"
												fill="white" />
											<path
												d="M17.3353 2.66895C17.4238 2.66895 17.5085 2.63383 17.5711 2.57131C17.6336 2.5088 17.6687 2.42402 17.6687 2.33561V1.00228C17.6687 0.913873 17.6336 0.829089 17.5711 0.766576C17.5085 0.704064 17.4238 0.668945 17.3353 0.668945C17.2469 0.668945 17.1622 0.704064 17.0996 0.766576C17.0371 0.829089 17.002 0.913873 17.002 1.00228V2.33561C17.002 2.42402 17.0371 2.5088 17.0996 2.57131C17.1622 2.63383 17.2469 2.66895 17.3353 2.66895Z"
												fill="white" />
											<path
												d="M13.3353 2.66895C13.4238 2.66895 13.5085 2.63383 13.5711 2.57131C13.6336 2.5088 13.6687 2.42402 13.6687 2.33561V1.00228C13.6687 0.913873 13.6336 0.829089 13.5711 0.766576C13.5085 0.704064 13.4238 0.668945 13.3353 0.668945C13.2469 0.668945 13.1622 0.704064 13.0996 0.766576C13.0371 0.829089 13.002 0.913873 13.002 1.00228V2.33561C13.002 2.42402 13.0371 2.5088 13.0996 2.57131C13.1622 2.63383 13.2469 2.66895 13.3353 2.66895Z"
												fill="white" />
											<path d="M12.6687 9.95215L11.029 12.0018H12.6687V9.95215Z" fill="white" />
											<path
												d="M2.00201 17.6689C2.00254 18.1108 2.17831 18.5344 2.49075 18.8469C2.8032 19.1593 3.22682 19.3351 3.66868 19.3356H19.002C19.4439 19.3351 19.8675 19.1593 20.1799 18.8469C20.4924 18.5344 20.6682 18.1108 20.6687 17.6689V4.66895H2.00201V17.6689ZM15.002 14.0023V12.3356C15.002 12.2472 15.0371 12.1624 15.0996 12.0999C15.1622 12.0374 15.2469 12.0023 15.3353 12.0023C15.4238 12.0023 15.5085 12.0374 15.5711 12.0999C15.6336 12.1624 15.6687 12.2472 15.6687 12.3356V13.0636C15.7754 13.0241 15.8882 13.0034 16.002 13.0023C16.2672 13.0023 16.5216 13.1076 16.7091 13.2952C16.8967 13.4827 17.002 13.7371 17.002 14.0023V14.3356C17.002 14.424 16.9669 14.5088 16.9044 14.5713C16.8419 14.6338 16.7571 14.6689 16.6687 14.6689C16.5803 14.6689 16.4955 14.6338 16.433 14.5713C16.3705 14.5088 16.3353 14.424 16.3353 14.3356V14.0023C16.3353 13.9139 16.3002 13.8291 16.2377 13.7666C16.1752 13.7041 16.0904 13.6689 16.002 13.6689C15.9136 13.6689 15.8288 13.7041 15.7663 13.7666C15.7038 13.8291 15.6687 13.9139 15.6687 14.0023V14.3356C15.6687 14.424 15.6336 14.5088 15.5711 14.5713C15.5085 14.6338 15.4238 14.6689 15.3353 14.6689C15.2469 14.6689 15.1622 14.6338 15.0996 14.5713C15.0371 14.5088 15.002 14.424 15.002 14.3356V14.0023ZM10.075 12.1273L12.7417 8.79395C12.7848 8.73999 12.8437 8.70077 12.9101 8.68171C12.9765 8.66266 13.0472 8.66472 13.1124 8.68759C13.1776 8.71047 13.2341 8.75304 13.274 8.80942C13.3139 8.86579 13.3354 8.93319 13.3353 9.00228V12.0023H14.002C14.0904 12.0023 14.1752 12.0374 14.2377 12.0999C14.3002 12.1624 14.3353 12.2472 14.3353 12.3356C14.3353 12.424 14.3002 12.5088 14.2377 12.5713C14.1752 12.6338 14.0904 12.6689 14.002 12.6689H13.3353V14.3356C13.3353 14.424 13.3002 14.5088 13.2377 14.5713C13.1752 14.6338 13.0904 14.6689 13.002 14.6689C12.9136 14.6689 12.8288 14.6338 12.7663 14.5713C12.7038 14.5088 12.6687 14.424 12.6687 14.3356V12.6689H10.3353C10.2725 12.669 10.211 12.6512 10.1578 12.6178C10.1046 12.5844 10.062 12.5366 10.0348 12.48C10.0076 12.4234 9.99692 12.3602 10.004 12.2978C10.0112 12.2354 10.0358 12.1763 10.075 12.1273ZM7.60201 8.66895C8.27068 8.66895 9.53535 9.05728 9.53535 10.5259C9.53535 11.9176 8.07835 13.2523 7.08101 14.0023H10.002C10.0904 14.0023 10.1752 14.0374 10.2377 14.0999C10.3002 14.1624 10.3353 14.2472 10.3353 14.3356C10.3353 14.424 10.3002 14.5088 10.2377 14.5713C10.1752 14.6338 10.0904 14.6689 10.002 14.6689H6.00201C5.92903 14.6689 5.85807 14.645 5.80001 14.6008C5.74195 14.5565 5.70002 14.4945 5.68064 14.4241C5.66126 14.3538 5.66551 14.279 5.69273 14.2113C5.71996 14.1436 5.76866 14.0866 5.83135 14.0493C6.67601 13.5456 8.86868 11.9306 8.86868 10.5259C8.86868 9.37928 7.73035 9.33661 7.60201 9.33561C7.43866 9.3226 7.2744 9.34393 7.11979 9.39825C6.96519 9.45256 6.82367 9.53865 6.70435 9.65097C6.58503 9.76329 6.49055 9.89935 6.427 10.0504C6.36344 10.2014 6.33222 10.3641 6.33535 10.5279C6.33456 10.6158 6.29909 10.6998 6.23666 10.7617C6.17424 10.8236 6.0899 10.8583 6.00201 10.8583C5.9139 10.8578 5.82954 10.8225 5.76739 10.7601C5.70524 10.6976 5.67035 10.6131 5.67035 10.5249C5.66524 10.2733 5.71231 10.0234 5.80858 9.79086C5.90485 9.55834 6.04824 9.34827 6.22972 9.17391C6.41119 8.99954 6.62681 8.86466 6.863 8.77775C7.09918 8.69084 7.3508 8.65379 7.60201 8.66895Z"
												fill="white" />
											<path
												d="M19.002 2.00195H18.3353V2.33529C18.3353 2.6005 18.23 2.85486 18.0425 3.04239C17.8549 3.22993 17.6006 3.33529 17.3353 3.33529C17.0701 3.33529 16.8158 3.22993 16.6282 3.04239C16.4407 2.85486 16.3353 2.6005 16.3353 2.33529V2.00195H14.3353V2.33529C14.3353 2.6005 14.23 2.85486 14.0425 3.04239C13.8549 3.22993 13.6006 3.33529 13.3353 3.33529C13.0701 3.33529 12.8158 3.22993 12.6282 3.04239C12.4407 2.85486 12.3353 2.6005 12.3353 2.33529V2.00195H10.3353V2.33529C10.3353 2.6005 10.23 2.85486 10.0425 3.04239C9.85492 3.22993 9.60056 3.33529 9.33535 3.33529C9.07013 3.33529 8.81578 3.22993 8.62824 3.04239C8.4407 2.85486 8.33535 2.6005 8.33535 2.33529V2.00195H6.33535V2.33529C6.33535 2.6005 6.22999 2.85486 6.04245 3.04239C5.85492 3.22993 5.60056 3.33529 5.33535 3.33529C5.07013 3.33529 4.81578 3.22993 4.62824 3.04239C4.4407 2.85486 4.33535 2.6005 4.33535 2.33529V2.00195H3.66868C3.22682 2.00248 2.8032 2.17825 2.49075 2.49069C2.17831 2.80314 2.00254 3.22675 2.00201 3.66862V4.00195H20.6687V3.66862C20.6682 3.22675 20.4924 2.80314 20.1799 2.49069C19.8675 2.17825 19.4439 2.00248 19.002 2.00195Z"
												fill="white" />
										</g>
										<defs>
											<clipPath id="clip0_365_24357">
												<rect width="20" height="20" fill="white"
													transform="translate(0.835327 0.00195312)" />
											</clipPath>
										</defs>
									</svg>
								</span>
								'. $settings['faq_cnt_info_oph'] .'
							</a>
						</div>
					</div>
				</div>
			</div>
			</div>';	 

	}
	
	protected function _content_template() {

    }	
}

