<?php
namespace Elementor;

class cras_widget_contact extends Widget_Base {
	
	public function get_name() {
		return 'widget-cnt';
	}
	
	public function get_title() {
		return 'Contact';
	}
	
	public function get_icon() {
		return 'eicon-envelope';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Contact Content', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_style',
			[
				'label' => esc_html__( 'Contact Styles', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'cnt_stl'  => esc_html__( 'Select Contact Style', 'cras' ),
					'cnt_stl_1'  => esc_html__( 'Contact Form', 'cras' ),
					'cnt_stl_2' => esc_html__( 'Contact Info', 'cras' )
				],
				'default' => 'cnt_stl_2',
			]
		);

//Style One		
		$this->add_control(
			'cnt_page_title',
			[
				'label' => esc_html__( 'Page Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact Us', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_1',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'How can we help?', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_1',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);
		
		$this->add_control(
			'cnt_sec_desc',
			[
				'label' => esc_html__( 'Section Description', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_1',
				],
				'placeholder' => esc_html__( 'Enter Description', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_fsrtc',
			[
				'label' => esc_html__( 'Enter the Shortcode From Contact Form-7', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'condition' => [
					'cnt_style' => 'cnt_stl_1',
				],
				'placeholder' => esc_html__( 'Enter Shortcode', 'cras' ),
			]
		);

//Style Two

		$this->add_control(
			'cnt_sec_tagline',
			[
				'label' => esc_html__( 'Section Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Tagline', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_sec_title2',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Contact', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_sec_desc2',
			[
				'label' => esc_html__( 'Section Description', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form.', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Description', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_title1',
			[
				'label' => esc_html__( 'Email Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Email :', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_desc1',
			[
				'label' => esc_html__( 'Email Address', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'example@email.com', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Email Address', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_title2',
			[
				'label' => esc_html__( 'Address Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Location :', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_desc2',
			[
				'label' => esc_html__( 'Address', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '901 N Pitt Str., Suite 170 Alexandria, NY, USA', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Address', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_title3',
			[
				'label' => esc_html__( 'Phone Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Phone :', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_desc3',
			[
				'label' => esc_html__( 'Phone Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( '(406) 555-0120', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Phone Number', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_title4',
			[
				'label' => esc_html__( 'Open Hour Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Open Hour :', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'cnt_info_desc4',
			[
				'label' => esc_html__( 'Open Hour', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Sun - Thu: Open 27/7', 'cras' ),
				'condition' => [
					'cnt_style' => 'cnt_stl_2',
				],
				'placeholder' => esc_html__( 'Enter Open Hour', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter require class', 'cras' ),
			]
		);	

		$this->end_controls_section();
	}
	
	protected function render() {

    $settings = $this->get_settings_for_display();

	if($settings['cnt_style'] == 'cnt_stl_1') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container">
			<div class="contact-content">
				<div class="contact-title-section" data-aos="fade-up" data-aos-delay="700">
					<h2 class="contact-form-title ak-white-color text-uppercase">'. $settings['cnt_page_title'] .'</h2>
					<p>'. esc_html__('Home /', 'cras').' '. get_the_title() .'</p>
				</div>
				<div class="ak-height-25 ak-height-lg-20"></div>
				<div class="contact-form" data-aos="fade-up" data-aos-delay="750">
					<div>
						<h5 class="mb-3">'. $settings['cnt_sec_title'] .'</h5>
						<p>'. $settings['cnt_sec_desc'] .'</p>
						<div class="ak-height-45 ak-height-lg-30"></div>
					</div>
					'. do_shortcode($settings['cnt_fsrtc']) .'
				</div>
			</div>
		</div>';

} elseif($settings['cnt_style'] == 'cnt_stl_2') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
			<section class="container">
				<div class="contact-info">
					<div class="left-info" data-aos="fade-right">
						<div class="content">
							<div class="ak-section-heading ak-style-1">
								<div class="background-text">'. $settings['cnt_sec_tagline'] .'</div>
								<h2 class="ak-section-title">'. $settings['cnt_sec_title2'] .'</h2>
								<p class="ak-section-subtitle">
								'. $settings['cnt_sec_desc2'] .'
								</p>
							</div>
						</div>
					</div>
					
					<div class="right-info">';

	echo'				<div class="info-card" data-aos="fade-left">
							<p> '. $settings['cnt_info_title1'] .'</p>
							<div class="d-flex gap-2">
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="17" viewBox="0 0 21 17"
										fill="none">
										<g clip-path="url(#clip0_288_1253)">
											<path
												d="M18.9875 16.3572C19.4371 16.3572 19.8266 16.2087 20.1578 15.9156L14.4914 10.2491C14.3555 10.3464 14.2237 10.4411 14.0992 10.5311C13.6752 10.8435 13.331 11.0873 13.0668 11.262C12.8025 11.4371 12.451 11.6156 12.0121 11.7978C11.573 11.9802 11.1639 12.0711 10.7843 12.0711H10.7732H10.7621C10.3825 12.0711 9.97343 11.9803 9.53432 11.7978C9.0952 11.6156 8.74364 11.4371 8.47966 11.262C8.21542 11.0873 7.87145 10.8436 7.44719 10.5311C7.32896 10.4444 7.19784 10.3493 7.05608 10.2476L1.38867 15.9156C1.71979 16.2087 2.10959 16.3572 2.55913 16.3572H18.9875Z"
												fill="white" />
											<path
												d="M1.90079 6.68088C1.47678 6.3982 1.10078 6.07445 0.773438 5.70978V14.331L5.76771 9.33668C4.76857 8.63914 3.48123 7.75489 1.90079 6.68088Z"
												fill="white" />
											<path
												d="M19.6575 6.68088C18.1373 7.7098 16.8453 8.59557 15.7812 9.33868L20.7735 14.3312V5.70978C20.4534 6.06712 20.0815 6.39065 19.6575 6.68088Z"
												fill="white" />
											<path
												d="M18.9874 0.642822H2.55904C1.9859 0.642822 1.54527 0.836361 1.23659 1.22304C0.927651 1.6099 0.773438 2.09371 0.773438 2.67392C0.773438 3.14259 0.978087 3.6504 1.3872 4.1975C1.79632 4.74438 2.23166 5.17395 2.69299 5.4864C2.9459 5.66509 3.70858 6.19531 4.98103 7.07687C5.66793 7.55287 6.26528 7.96776 6.77861 8.32579C7.21616 8.63066 7.59351 8.89468 7.90506 9.11378C7.94082 9.13887 7.99707 9.1791 8.07172 9.23248C8.15215 9.29025 8.25393 9.36356 8.3795 9.45423C8.62129 9.62911 8.82217 9.77046 8.98215 9.87845C9.14192 9.98648 9.3355 10.1071 9.56259 10.2411C9.7895 10.3749 10.0035 10.4756 10.2044 10.5425C10.4053 10.6094 10.5913 10.6429 10.7624 10.6429H10.7735H10.7846C10.9557 10.6429 11.1417 10.6094 11.3426 10.5425C11.5435 10.4756 11.7573 10.3752 11.9844 10.2411C12.2113 10.1071 12.4046 9.98623 12.5649 9.87845C12.7249 9.77046 12.9257 9.62914 13.1676 9.45423C13.2929 9.36356 13.3946 9.29021 13.4751 9.23266C13.5498 9.17907 13.606 9.13909 13.642 9.11378C13.8847 8.94489 14.2629 8.68197 14.7714 8.32888C15.6967 7.68599 17.0594 6.73976 18.8652 5.4864C19.4083 5.10706 19.862 4.64929 20.2267 4.11373C20.5907 3.57818 20.7732 3.01641 20.7732 2.4286C20.7732 1.9375 20.5963 1.51727 20.2432 1.16726C19.8896 0.817697 19.471 0.642822 18.9874 0.642822Z"
												fill="white" />
										</g>
										<defs>
											<clipPath id="clip0_288_1253">
												<rect width="21" height="17" fill="white" />
											</clipPath>
										</defs>
									</svg>
								</div>
								<div>
									<p>'. $settings['cnt_info_desc1'] .'</p>
								</div>
							</div>
						</div>
						<div class="info-card" data-aos="fade-left">
							<p> '. $settings['cnt_info_title2'] .'</p>
							<div class="d-flex gap-2 ">
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="14" height="18" viewBox="0 0 14 18"
										fill="none">
										<path
											d="M7 0C3.14027 0 0 2.99074 0 6.66668C0 7.7702 0.289693 8.86434 0.840408 9.8348L6.6172 17.7852C6.69411 17.9178 6.84065 18 7 18C7.15935 18 7.30589 17.9178 7.3828 17.7852L13.1617 9.83152C13.7103 8.86434 14 7.77016 14 6.66664C14 2.99074 10.8597 0 7 0ZM7 10C5.07014 10 3.50002 8.50465 3.50002 6.66668C3.50002 4.82871 5.07014 3.33336 7 3.33336C8.92986 3.33336 10.5 4.82871 10.5 6.66668C10.5 8.50465 8.92986 10 7 10Z"
											fill="white" />
									</svg>
								</div>
								<div>
									<p>'. $settings['cnt_info_desc2'] .'</p>
								</div>
							</div>
						</div>
						<div class="info-card" data-aos="fade-left">
							<p class="phone"> '. $settings['cnt_info_title3'] .'</p>
							<div class="d-flex gap-2 align-items-center">
								<div>
									<svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
										fill="none">
										<g clip-path="url(#clip0_1774_2)">
											<path
												d="M18.7604 13.6277C17.536 13.6277 16.3337 13.4362 15.1943 13.0597C14.6361 12.8693 13.9498 13.044 13.609 13.3939L11.3602 15.0915C8.75227 13.6994 7.14581 12.0934 5.77268 9.50505L7.42034 7.31484C7.84841 6.88734 8.00195 6.26286 7.818 5.67693C7.43987 4.53161 7.24779 3.3299 7.24779 2.1049C7.24784 1.21995 6.52789 0.5 5.64299 0.5H1.97008C1.08518 0.5 0.365234 1.21995 0.365234 2.10484C0.365234 12.2481 8.61721 20.5 18.7604 20.5C19.6453 20.5 20.3653 19.7801 20.3653 18.8952V15.2325C20.3652 14.3477 19.6453 13.6277 18.7604 13.6277Z"
												fill="white" />
										</g>
										<defs>
											<clipPath id="clip0_1774_2">
												<rect width="20" height="20" fill="white" transform="translate(0.365234 0.5)" />
											</clipPath>
										</defs>
									</svg>
								</div>
								<div>
									<p>'. $settings['cnt_info_desc3'] .'</p>
								</div>
							</div>
						</div>
						<div class="info-card" data-aos="fade-left">
							<p> '. $settings['cnt_info_title4'] .'</p>
							<div class="d-flex gap-2 align-items-center">
								<div class="mb-1">
									<svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
										fill="none">
										<path
											d="M4.49935 3.16699C4.58775 3.16699 4.67254 3.13187 4.73505 3.06936C4.79756 3.00685 4.83268 2.92206 4.83268 2.83366V1.50033C4.83268 1.41192 4.79756 1.32714 4.73505 1.26462C4.67254 1.20211 4.58775 1.16699 4.49935 1.16699C4.41094 1.16699 4.32616 1.20211 4.26365 1.26462C4.20113 1.32714 4.16602 1.41192 4.16602 1.50033V2.83366C4.16602 2.92206 4.20113 3.00685 4.26365 3.06936C4.32616 3.13187 4.41094 3.16699 4.49935 3.16699Z"
											fill="white" />
										<path
											d="M8.49935 3.16699C8.58775 3.16699 8.67254 3.13187 8.73505 3.06936C8.79756 3.00685 8.83268 2.92206 8.83268 2.83366V1.50033C8.83268 1.41192 8.79756 1.32714 8.73505 1.26462C8.67254 1.20211 8.58775 1.16699 8.49935 1.16699C8.41094 1.16699 8.32616 1.20211 8.26365 1.26462C8.20113 1.32714 8.16602 1.41192 8.16602 1.50033V2.83366C8.16602 2.92206 8.20113 3.00685 8.26365 3.06936C8.32616 3.13187 8.41094 3.16699 8.49935 3.16699Z"
											fill="white" />
										<path
											d="M16.4993 3.16699C16.5878 3.16699 16.6725 3.13187 16.7351 3.06936C16.7976 3.00685 16.8327 2.92206 16.8327 2.83366V1.50033C16.8327 1.41192 16.7976 1.32714 16.7351 1.26462C16.6725 1.20211 16.5878 1.16699 16.4993 1.16699C16.4109 1.16699 16.3262 1.20211 16.2636 1.26462C16.2011 1.32714 16.166 1.41192 16.166 1.50033V2.83366C16.166 2.92206 16.2011 3.00685 16.2636 3.06936C16.3262 3.13187 16.4109 3.16699 16.4993 3.16699Z"
											fill="white" />
										<path
											d="M12.4993 3.16699C12.5878 3.16699 12.6725 3.13187 12.7351 3.06936C12.7976 3.00685 12.8327 2.92206 12.8327 2.83366V1.50033C12.8327 1.41192 12.7976 1.32714 12.7351 1.26462C12.6725 1.20211 12.5878 1.16699 12.4993 1.16699C12.4109 1.16699 12.3262 1.20211 12.2636 1.26462C12.2011 1.32714 12.166 1.41192 12.166 1.50033V2.83366C12.166 2.92206 12.2011 3.00685 12.2636 3.06936C12.3262 3.13187 12.4109 3.16699 12.4993 3.16699Z"
											fill="white" />
										<path d="M11.833 10.4502L10.1934 12.4999H11.833V10.4502Z" fill="white" />
										<path
											d="M1.16602 18.167C1.16654 18.6089 1.34231 19.0325 1.65476 19.3449C1.9672 19.6574 2.39082 19.8331 2.83268 19.8337H18.166C18.6079 19.8331 19.0315 19.6574 19.3439 19.3449C19.6564 19.0325 19.8322 18.6089 19.8327 18.167V5.16699H1.16602V18.167ZM14.166 14.5003V12.8337C14.166 12.7453 14.2011 12.6605 14.2636 12.598C14.3262 12.5354 14.4109 12.5003 14.4993 12.5003C14.5878 12.5003 14.6725 12.5354 14.7351 12.598C14.7976 12.6605 14.8327 12.7453 14.8327 12.8337V13.5617C14.9394 13.5222 15.0522 13.5014 15.166 13.5003C15.4312 13.5003 15.6856 13.6057 15.8731 13.7932C16.0607 13.9808 16.166 14.2351 16.166 14.5003V14.8337C16.166 14.9221 16.1309 15.0068 16.0684 15.0694C16.0059 15.1319 15.9211 15.167 15.8327 15.167C15.7443 15.167 15.6595 15.1319 15.597 15.0694C15.5345 15.0068 15.4993 14.9221 15.4993 14.8337V14.5003C15.4993 14.4119 15.4642 14.3271 15.4017 14.2646C15.3392 14.2021 15.2544 14.167 15.166 14.167C15.0776 14.167 14.9928 14.2021 14.9303 14.2646C14.8678 14.3271 14.8327 14.4119 14.8327 14.5003V14.8337C14.8327 14.9221 14.7976 15.0068 14.7351 15.0694C14.6725 15.1319 14.5878 15.167 14.4993 15.167C14.4109 15.167 14.3262 15.1319 14.2636 15.0694C14.2011 15.0068 14.166 14.9221 14.166 14.8337V14.5003ZM9.23902 12.6253L11.9057 9.29199C11.9488 9.23803 12.0077 9.19881 12.0741 9.17976C12.1405 9.16071 12.2112 9.16276 12.2764 9.18564C12.3416 9.20852 12.3981 9.25109 12.438 9.30747C12.4779 9.36384 12.4994 9.43123 12.4993 9.50033V12.5003H13.166C13.2544 12.5003 13.3392 12.5354 13.4017 12.598C13.4642 12.6605 13.4993 12.7453 13.4993 12.8337C13.4993 12.9221 13.4642 13.0068 13.4017 13.0694C13.3392 13.1319 13.2544 13.167 13.166 13.167H12.4993V14.8337C12.4993 14.9221 12.4642 15.0068 12.4017 15.0694C12.3392 15.1319 12.2544 15.167 12.166 15.167C12.0776 15.167 11.9928 15.1319 11.9303 15.0694C11.8678 15.0068 11.8327 14.9221 11.8327 14.8337V13.167H9.49935C9.43654 13.167 9.375 13.1493 9.32182 13.1159C9.26865 13.0824 9.226 13.0347 9.19879 12.9781C9.17158 12.9214 9.16092 12.8583 9.16804 12.7959C9.17515 12.7335 9.19976 12.6744 9.23902 12.6253ZM6.76602 9.16699C7.43468 9.16699 8.69935 9.55533 8.69935 11.024C8.69935 12.4157 7.24235 13.7503 6.24502 14.5003H9.16602C9.25442 14.5003 9.33921 14.5354 9.40172 14.598C9.46423 14.6605 9.49935 14.7453 9.49935 14.8337C9.49935 14.9221 9.46423 15.0068 9.40172 15.0694C9.33921 15.1319 9.25442 15.167 9.16602 15.167H5.16602C5.09303 15.167 5.02207 15.143 4.96401 15.0988C4.90596 15.0546 4.86402 14.9925 4.84464 14.9222C4.82526 14.8518 4.82951 14.777 4.85674 14.7093C4.88396 14.6416 4.93266 14.5847 4.99535 14.5473C5.84002 14.0437 8.03268 12.4287 8.03268 11.024C8.03268 9.87733 6.89435 9.83466 6.76602 9.83366C6.60266 9.82064 6.4384 9.84198 6.28379 9.89629C6.12919 9.95061 5.98767 10.0367 5.86835 10.149C5.74903 10.2613 5.65455 10.3974 5.591 10.5484C5.52744 10.6995 5.49623 10.8622 5.49935 11.026C5.49856 11.1139 5.46309 11.1979 5.40066 11.2598C5.33824 11.3216 5.2539 11.3563 5.16602 11.3563C5.0779 11.3559 4.99354 11.3206 4.93139 11.2581C4.86924 11.1956 4.83435 11.1111 4.83435 11.023C4.82924 10.7714 4.87631 10.5214 4.97258 10.2889C5.06885 10.0564 5.21224 9.84632 5.39372 9.67196C5.57519 9.49759 5.79081 9.3627 6.027 9.2758C6.26318 9.18889 6.51481 9.15184 6.76602 9.16699Z"
											fill="white" />
										<path
											d="M18.166 2.5H17.4993V2.83333C17.4993 3.09855 17.394 3.3529 17.2065 3.54044C17.0189 3.72798 16.7646 3.83333 16.4993 3.83333C16.2341 3.83333 15.9798 3.72798 15.7922 3.54044C15.6047 3.3529 15.4993 3.09855 15.4993 2.83333V2.5H13.4993V2.83333C13.4993 3.09855 13.394 3.3529 13.2065 3.54044C13.0189 3.72798 12.7646 3.83333 12.4993 3.83333C12.2341 3.83333 11.9798 3.72798 11.7922 3.54044C11.6047 3.3529 11.4993 3.09855 11.4993 2.83333V2.5H9.49935V2.83333C9.49935 3.09855 9.39399 3.3529 9.20646 3.54044C9.01892 3.72798 8.76457 3.83333 8.49935 3.83333C8.23413 3.83333 7.97978 3.72798 7.79224 3.54044C7.60471 3.3529 7.49935 3.09855 7.49935 2.83333V2.5H5.49935V2.83333C5.49935 3.09855 5.39399 3.3529 5.20646 3.54044C5.01892 3.72798 4.76457 3.83333 4.49935 3.83333C4.23413 3.83333 3.97978 3.72798 3.79224 3.54044C3.60471 3.3529 3.49935 3.09855 3.49935 2.83333V2.5H2.83268C2.39082 2.50053 1.9672 2.67629 1.65476 2.98874C1.34231 3.30119 1.16654 3.7248 1.16602 4.16667V4.5H19.8327V4.16667C19.8322 3.7248 19.6564 3.30119 19.3439 2.98874C19.0315 2.67629 18.6079 2.50053 18.166 2.5Z"
											fill="white" />
									</svg>
								</div>
								<div>
									<p>'. $settings['cnt_info_desc4'] .'</p>
								</div>
							</div>
						</div>';				
								
	echo'			</div>
        		</div>
    		</section>';					
	} 

	}
	
	protected function _content_template() {

    }
	
}