<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}
class cras_widget_clients extends Widget_Base {
	
	public function get_name() {
		return 'widget-clients';
	}
	
	public function get_title() {
		return 'Our Clients';
	}
	
	public function get_icon() {
		return 'eicon-parallax';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Clients Content', 'cras' ),
			]
		);

		$this->add_control(
			'clt_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Trusted Clients', 'cras' ),
                'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true, 
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter a class if you need', 'cras' ),
			]
		);

		$this->add_control(
            'clt_rptr',
            [
                'label' => esc_html__( 'Client Logo', 'cras' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => [
					[
						'name' => 'clt_logo',
						'label' => esc_html__( 'Client Logo', 'cras' ),
						'type' => \Elementor\Controls_Manager::MEDIA,
						'default' => [
						'url' => \Elementor\Utils::get_placeholder_image_src(),
						],
					],
                ],
            ],
			
        );

		$this->end_controls_section();
	}
	
	protected function render() {

	$settings = $this->get_settings_for_display();
	$clt_sec_title = $settings['clt_sec_title'];

	echo '<div class="ak-height-125 ak-height-lg-80"></div>
				<div class="container '. $settings['ex_class'] .'">
					<div class="ak-slider ak-trusted-client-slider">';
					
if(!empty($clt_sec_title)){					
	echo'				<h4 class="title">'. $settings['clt_sec_title'] .'</h4>';
}	
	echo'					<div class="swiper-wrapper">';

foreach ( $settings['clt_rptr'] as $client_logo ) :		
	echo'<div class="swiper-slide">
			<div class="trusted-client">
				<img src="'. $client_logo['clt_logo']['url'] .'" alt="'.get_bloginfo( 'name', 'display' ).'">
			</div>
		</div>';
endforeach;	

	echo'</div></div></div>'; 

	}
	
	protected function _content_template() {

    }
	
	
}