<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_brdc extends Widget_Base {
	
	public function get_name() {
		return 'widget-brdc';
	}
	
	public function get_title() {
		return 'Breadcrumb';
	}
	
	public function get_icon() {
		return 'eicon-banner';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Breadcrumb Content', 'cras' ),
			]
		);

		$this->add_control(
			'br_style',
			[
				'label' => esc_html__( 'Styles', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'br_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'br_stl_2' => esc_html__( 'Style Two', 'cras' )
				],
				'default' => 'br_stl_1',
			]
		);

		$this->add_control(
			'brdc_bg',
			[
				'label' => esc_html__( 'Section Background Image', 'cras' ),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [
				'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'br_style' => 'br_stl_1',
				],
			]
		);

		$this->add_control(
			'brdc_wlc_title',
			[
				'label' => esc_html__( 'Custom Title / Welcome Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => 'Required Page Title',
                'placeholder' => esc_html__( 'Enter your description', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter require class', 'cras' ),
			]
		);	

		$this->end_controls_section();
	}
	
	protected function render() {


    $settings = $this->get_settings_for_display();
	$wlcTitle = $settings['brdc_wlc_title'];

if($settings['br_style'] == 'br_stl_1') { 
	echo'<div data-src="'. $settings['brdc_bg']['url'] .'" class="ak-bg"  '. $settings['ex_class'] .'>
			<div class="ak-height-100 ak-height-lg-100"></div>
			<div class="ak-height-125 ak-height-lg-40"></div>
			<div class="container">
				<div class="common-page-title">
					<h3 class="page-title">'. $settings['brdc_wlc_title'] .'</h3>
					<div class="d-flex gap-2 align-items-center">
						<p>'. esc_html__('Home /', 'cras') .'</p>
						<a href="/'. get_the_permalink() .'">'. get_the_title() .'</a>
					</div>
				</div>
			</div>
			<div class="ak-height-100 ak-height-lg-100"></div>
		</div>';

} elseif($settings['br_style'] == 'br_stl_2') {
	echo'<div class="ak-height-125 ak-height-lg-80"></div>
			<div class="container '. $settings['ex_class'] .'">
				<div class="common-page-title">
					<h3 class="page-title">'. $settings['brdc_wlc_title'] .'</h3>
					<div class="d-flex gap-2 align-items-center">
						<p>'. esc_html__('Home /', 'cras') .'</p>
						<a href="/'. get_the_permalink() .'">'. get_the_title() .'</a>
					</div>
				</div>
				<div class="primary-color-border"></div>
			</div>';
} 			 

	}
	
	protected function _content_template() {

    }
	
	
}