<?php
namespace Elementor;

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

class cras_widget_blog extends Widget_Base {
	
	public function get_name() {
		return 'blog-post';
	}
	
	public function get_title() {
		return 'Blog Post';
	}
	
	public function get_icon() {
		return 'eicon-post';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Post Content', 'cras' ),
			]
		);
		
		$this->add_control(
			'bl_style',
			[
				'label' => esc_html__( 'Choose Blog Styles', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'bl_stl_1'  => esc_html__( 'Blog Style One', 'cras' ),
					'bl_stl_2' => esc_html__( 'Blog Style Two', 'cras' ),
					'bl_stl_3' => esc_html__( 'Blog Style Three', 'cras' ),
					'bl_stl_4' => esc_html__( 'Blog Style Four', 'cras' ),
				],
				'default' => 'bl_stl_1',
			]
		);

		// $options = array();

		// $posts = get_posts( array(
		// 	'post_type'  => 'post'
		// ) );

		// foreach ( $posts as $key => $post ) {
		// 	$options[$post->ID] = get_the_title($post->ID);
		// }
    
        
        // $this->add_control(
        //     'bl_post_title',
        //     [
        //         'label' => __( 'Select Posts', 'cras' ),
        //         'label_block' => ('bool'),
        //         'type' => \Elementor\Controls_Manager::SELECT,
        //         'multiple' => true,
        //         'options' => $options,
		// 		'condition' => [
		// 			'bl_style' => 'bl_stl_3',
		// 		],
        //     ]
        // );
		
		$this->add_control(
			'bl_tagline',
			[
				'label' => esc_html__( 'Tagline', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Our Blog', 'cras' ),
				'placeholder' => esc_html__( 'Enter Section Tagline', 'cras' ),
				'condition' => [
					'bl_style' => ['bl_stl_1', 'bl_stl_4']
				],
			]
		);

		$this->add_control(
			'bl_title',
			[
				'label' => esc_html__( 'Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Blog / News', 'cras' ),
                'placeholder' => esc_html__( 'Enter Section Title', 'cras' ),
				'condition' => [
					'bl_style' => ['bl_stl_1', 'bl_stl_4']
				],
			]
		);

		$this->add_control(
			'bl_sec_desc',
			[
				'label' => esc_html__( 'Section Content', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
                'placeholder' => esc_html__( 'Enter Section Description', 'cras' ),
				'condition' => [
					'bl_style' => ['bl_stl_1', 'bl_stl_4']
				],
			]
		);
		$this->add_control(
			'bl_btn_txt',
			[
				'label' => esc_html__( 'Button Text', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Blog / News', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required Text', 'cras' ),
				'condition' => [
					'bl_style' => 'bl_stl_4',
				],
			]
		);
		$this->add_control(
			'bl_btn_url',
			[
				'label' => esc_html__( 'Button URL', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( '#', 'cras' ),
                'placeholder' => esc_html__( 'Enter Required URL', 'cras' ),
				'condition' => [
					'bl_style' => 'bl_stl_4',
				],
			]
		);

		$this->add_control(
			'bl_pocat',
			[
				'label' => esc_html__( 'Post Category / Slug Name', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your required post category', 'cras' ),
			]
		);

		$this->add_control(
			'bl_pono',
			[
				'label' => esc_html__( 'Post Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::NUMBER,
                'placeholder' => esc_html__( 'Enter your required post number', 'cras' ),
			]
		);

		$this->add_control(
			'ex_class',
			[
				'label' => esc_html__( 'Extra Class', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter required Extra Class', 'cras' ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

	$settings = $this->get_settings_for_display();
	$bl_title = $settings['bl_title'];

if($settings['bl_style'] == 'bl_stl_1') {    
	echo'<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="container ' . $settings['ex_class'] . '">';
if(!empty($bl_title)) {	
	echo'	<div class="center-section-heading" data-aos="fade-up">
				<div class="ak-section-heading ak-style-1">
					<div class="background-text" data-aos="fade-left" data-aos-delay="200" data-aos-duration="1000">
						'. $settings['bl_tagline'] .'
					</div>
					<div class="text-md-center">
						<h2 class="ak-section-title">'. $settings['bl_title'] .'</h2>
						<p class="ak-section-subtitle">'. $settings['bl_sec_desc'] .'</p>
					</div>
				</div>
			</div>';
}				
	echo'	<div class="ak-height-50 ak-height-lg-50"></div>
			<div class="row row-cols-1 row-cols-md-1 row-cols-lg-3 g-5 g-lg-4">';		

	global $post;	
	$args=array('post_type' => 'post', 'post_status' => 'publish', 'orderby' => 'DESC', 'category_name'=> $settings['bl_pocat'], 'showposts' => $settings['bl_pono']);
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post(); 	        

	$bl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'blog_thumb');
	$comment = '';
	$year  = get_the_time( 'Y' ); 
	$month = get_the_time( 'm' ); 
	$day   = get_the_time( 'd' );

	echo '<div class="col">
			<div class="h-100">
				<div class="blog-card" data-aos="fade-up" data-aos-delay="100">';
if(!empty($bl_image_port)) {				
	echo'			<a href="'. get_the_permalink() .'">
						<div class="blog-header-info">
							<img src="'. esc_url( $bl_image_port[0] ) .'" alt="'. get_bloginfo( 'name', 'display' ) .'">
						</div>
					</a>';
}
	echo'			<div class="blog-body-info">
						<p class="blog-text">'. get_the_date('m. j. Y') .'</p>
						<a href="'. get_the_permalink() .'" class="blog-title">
							'. get_the_title() .'
						</a>
					</div>
					<div class="blog-footer-info">
						<a href="'. get_the_permalink() .'" class="more-btn">READ MORE</a>
					</div>

				</div>
			</div>
		</div>';

	endwhile;
	wp_reset_postdata();		

	echo ' </div>
		</div>';		

} elseif($settings['bl_style'] == 'bl_stl_2') {    
	echo'
		<div class="ak-height-50 ak-height-lg-50"></div>
		<div class="container">
			<div class="row row-cols-1 row-cols-md-1 row-cols-lg-3 g-5 g-lg-4 pagination-wrapper">';		

global $post;	
$args=array('post_type' => 'post', 'post_status' => 'publish', 'orderby' => 'DESC', 'category_name'=> $settings['bl_pocat'], 'showposts' => $settings['bl_pono']);
$query=new \WP_Query($args);
while($query->have_posts()) : $query->the_post(); 	        

$bl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'blog_thumb');
$comment = '';
$year  = get_the_time( 'Y' ); 
$month = get_the_time( 'm' ); 
$day   = get_the_time( 'd' );

echo '<div class="col">
		<div class="blog-card" data-aos="fade-up">';

if(!empty($bl_image_port)) {				
echo'		<a href="'. get_the_permalink() .'">
				<div class="blog-header-info">
					<img src="'. esc_url( $bl_image_port[0] ) .'" alt="'. get_bloginfo( 'name', 'display' ) .'">
				</div>
			</a>';
}
echo'		<div class="blog-body-info">
				<p class="blog-text">'. get_the_date('m. j. Y') .'</p>
				<a href="'. get_the_permalink() .'" class="blog-title">
					'. get_the_title() .'
				</a>
			</div>
			<div class="blog-footer-info">
				<a href="'. get_the_permalink() .'" class="more-btn">READ MORE</a>
			</div>
		</div>
	</div>';

endwhile;
wp_reset_postdata();		

echo '  </div>
		<div class="ak-height-100 ak-height-lg-60"></div>
		<div id="pagination-container" class="pagination-style"></div>

	</div>';	

} elseif($settings['bl_style'] == 'bl_stl_3') {
	echo'<div class="ak-height-75 ak-height-lg-80"></div>
    	<section class="container  ' . $settings['ex_class'] . '"><h2 class="disp">Section Heading</h2>';

	global $post;	
	$args=array('post_type' => 'post', 'post_status' => 'publish', 'orderby' => 'DESC', 'category_name'=> $settings['bl_pocat'], 'showposts' => $settings['bl_pono'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post(); 	        

	$bl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
	$comment = '';
	$year  = get_the_time( 'Y' ); 
	$month = get_the_time( 'm' ); 
	$day   = get_the_time( 'd' );

	echo '<div class="blog-feature '. $settings['bl_post_title'] .'">
			<div class="feature-content" data-aos="fade-right" data-aos-delay="600">
				<p class="data">'. get_the_date('m. j. Y') .'</p>
				<h4 class="title">'. get_the_title() .'</h4>
				<p class="desp">'. get_the_excerpt() .'</p>
				<a href="'. get_the_permalink() .'" class="more-btn">READ MORE</a>
			</div>
			<div class="feature-img" data-aos="fade-left" data-aos-delay="600">
				<img src="'. esc_url( $bl_image_port[0] ) .'" alt="'. get_bloginfo( 'name', 'display' ) .'">
			</div>
		</div>';

	endwhile;
	wp_reset_postdata();		

	echo '</section>';	
} elseif($settings['bl_style'] == 'bl_stl_4') {
	echo'<div class="ak-height-125 ak-height-lg-80"></div>
		<div class="d-flex justify-content-center ' . $settings['ex_class'] . '">
			<div class="sticky-content style-two container">
				<div class="blog_4 content style_2">
					<div class="service">';

	global $post;	
	$args=array('post_type' => 'post', 'post_status' => 'publish', 'orderby' => 'DESC', 'category_name'=> $settings['bl_pocat'], 'showposts' => $settings['bl_pono'] );
	$query=new \WP_Query($args);
	while($query->have_posts()) : $query->the_post(); 	        

	$bl_image_port = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'blog_thumb_home3');
	$comment = '';
	$year  = get_the_time( 'Y' ); 
	$month = get_the_time( 'm' ); 
	$day   = get_the_time( 'd' );

	echo '<div class="service-card type-two" data-aos="fade-left">
			<a href="'. get_the_permalink() .'" class="card-img">
				<img src="'. esc_url( $bl_image_port[0] ) .'" class="ak-bg" alt="'.get_bloginfo('name', 'display').'" />
			</a>
			<div class="card-info">
				<a href="'. get_the_permalink() .'" class="card-title">'. get_the_title() .'</a>
				<p class="card-desp">
					'. get_the_excerpt() .'
				</p>
				<a href="'. get_the_permalink() .'" class="more-btn">VIEW MORE</a>
			</div>
		</div>';

	endwhile;
	wp_reset_postdata();		

	echo '</div>
            </div>
            <div class="style-two width-none">
                <div class="services-content">
                    <div class="ak-section-heading ak-style-1">
                        <div class="background-text" data-aos="fade-right" data-aos-duration="1000">
                            '. $settings['bl_tagline'] .'
                        </div>
                        <h2 class="ak-section-title">'. $settings['bl_title'] .'</h2>
                        <p class="ak-section-subtitle">
                            '. $settings['bl_sec_desc'] .'
                        </p>
                    </div>
                    <div class="ak-height-50 ak-height-lg-10"></div>
                    <a href="'. $settings['bl_btn_url'] .'" class="more-btn">'. $settings['bl_btn_txt'] .'</a>
                </div>
            </div>
        </div>
    </div>
    <div class="scroll-end-point style-two"></div>';	
}   

}
	
	protected function _content_template() {

    }
	
	
}