<?php
namespace Elementor;

class cras_widget_Appointment extends Widget_Base {
	
	public function get_name() {
		return 'widget-appointment';
	}
	
	public function get_title() {
		return 'Appointment';
	}
	
	public function get_icon() {
		return 'eicon-envelope';
	}
	
	public function get_categories() {
		return [ 'cras-category' ];
	}
	
	protected function _register_controls() {

		$this->start_controls_section(
			'section_title',
			[
				'label' => esc_html__( 'Appointment Content', 'cras' ),
			]
		);

		$this->add_control(
			'apnt_style',
			[
				'label' => esc_html__( 'Choose Required Style', 'cras' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'apnt_stl_1'  => esc_html__( 'Style One', 'cras' ),
					'apnt_stl_2' => esc_html__( 'Style Two', 'cras' )
				],
				'default' => 'apnt_stl_1',
			]
		);

		$this->add_control(
			'apnt_sec_title',
			[
				'label' => esc_html__( 'Section Title', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Request for a appointment', 'cras' ),
				'placeholder' => esc_html__( 'Enter Title', 'cras' ),
			]
		);
		
		$this->add_control(
			'apnt_sec_desc',
			[
				'label' => esc_html__( 'Section Description', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__( 'Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industrys stan.', 'cras' ),
				'placeholder' => esc_html__( 'Enter Description', 'cras' ),
			]
		);
		$this->add_control(
			'apnt_phn',
			[
				'label' => esc_html__( 'Phone Number', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Request for a appointment', 'cras' ),
				'placeholder' => esc_html__( '(406) 555-0120', 'cras' ),
				'condition' => [
					'apnt_style' => 'apnt_stl_2',
				],
			]
		);
		$this->add_control(
			'apnt_mail',
			[
				'label' => esc_html__( 'Email', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'example@email.com', 'cras' ),
				'placeholder' => esc_html__( 'Enter Required Email', 'cras' ),
				'condition' => [
					'apnt_style' => 'apnt_stl_2',
				],
			]
		);
		$this->add_control(
			'apnt_opnh',
			[
				'label' => esc_html__( 'Open Hour', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__( 'Sun - Thu: Open 27/7', 'cras' ),
				'placeholder' => esc_html__( 'Enter Required Open Hour', 'cras' ),
				'condition' => [
					'apnt_style' => 'apnt_stl_2',
				],
			]
		);

		$this->add_control(
			'apnt_fsrtc2',
			[
				'label' => esc_html__( 'Enter the Shortcode From Contact Form-7', 'cras' ),
				'label_block' => true,
				'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter Shortcode', 'cras' ),
			]
		);

		$this->end_controls_section();
	}
	
	protected function render() {

    $settings = $this->get_settings_for_display();

if($settings['apnt_style'] == 'apnt_stl_1') { 	
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
			<div class="container">
				<div class="contact-content">
					<div class="contact-title-section" data-aos="fade-up" data-aos-delay="700">
						<h2 class="contact-form-title ak-white-color text-uppercase">'. $settings['apnt_sec_title'] .'</h2>
						<p>'. $settings['apnt_sec_desc'] .'</p>
					</div>
					<div class="ak-height-25 ak-height-lg-20"></div>
					<div class="contact-form" data-aos="fade-up" data-aos-delay="750">
						'. do_shortcode($settings['apnt_fsrtc2']) .'
					</div>
        		</div>
    		</div>';
} elseif($settings['apnt_style'] == 'apnt_stl_2') {
	echo '<div class="ak-height-125 ak-height-lg-80"></div>
    <div class="container">
        <div class="contact-content style-two">
            <div class="contact-title-section" data-aos="fade-up" data-aos-delay="700">
                <h2 class="contact-form-title ak-white-color text-uppercase mb-2">
                    '. $settings['apnt_sec_title'] .'
                </h2>
                <p class="mb-2">
                    '. $settings['apnt_sec_desc'] .'
                </p>
                <div class="ak-height-40 ak-height-lg-30"></div>
                <div class="images" data-aos="fade-up" data-aos-delay="150">
                    <div class="images-info">
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="21" viewBox="0 0 21 21"
                                    fill="none">
                                    <g clip-path="url(#clip0_736_3001)">
                                        <path
                                            d="M19.2604 13.2371C18.0359 13.2371 16.8336 13.0456 15.6943 12.6691C15.136 12.4786 14.4497 12.6533 14.109 13.0033L11.8602 14.7009C9.25221 13.3088 7.64575 11.7028 6.27262 9.11443L7.92028 6.92422C8.34835 6.49672 8.50189 5.87224 8.31793 5.2863C7.93981 4.14099 7.74773 2.93927 7.74773 1.71427C7.74778 0.829323 7.02783 0.109375 6.14293 0.109375H2.47002C1.58512 0.109375 0.865173 0.829323 0.865173 1.71422C0.865173 11.8574 9.11715 20.1094 19.2604 20.1094C20.1453 20.1094 20.8652 19.3894 20.8652 18.5045V14.8419C20.8652 13.957 20.1452 13.2371 19.2604 13.2371Z"
                                            fill="#FF3D24" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_736_3001">
                                            <rect width="20" height="20" fill="white"
                                                transform="translate(0.865173 0.109375)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </span>
                            <p class="ak-font-24 ak-primary-font ak-white-color ak-bold">
                                '. $settings['apnt_phn'] .'
                            </p>
                        </div>
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="21" height="18" viewBox="0 0 21 18"
                                    fill="none">
                                    <g clip-path="url(#clip0_736_3009)">
                                        <path
                                            d="M18.304 16.3088C18.7535 16.3088 19.1431 16.1604 19.4742 15.8673L13.8079 10.2007C13.672 10.2981 13.5402 10.3928 13.4157 10.4828C12.9917 10.7952 12.6475 11.039 12.3832 11.2137C12.119 11.3888 11.7674 11.5672 11.3286 11.7495C10.8894 11.9319 10.4803 12.0228 10.1008 12.0228H10.0897H10.0786C9.69901 12.0228 9.28989 11.9319 8.85078 11.7495C8.41167 11.5672 8.06011 11.3888 7.79613 11.2137C7.53189 11.039 7.18791 10.7952 6.76365 10.4828C6.64543 10.3961 6.51431 10.301 6.37255 10.1992L0.705139 15.8673C1.03626 16.1604 1.42606 16.3088 1.87559 16.3088H18.304Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M1.21714 6.63321C0.79313 6.35053 0.417128 6.02678 0.0897827 5.66211V14.2833L5.08406 9.28901C4.08492 8.59148 2.79758 7.70723 1.21714 6.63321Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M18.9738 6.63321C17.4536 7.66213 16.1616 8.5479 15.0975 9.29101L20.0898 14.2835V5.66211C19.7697 6.01945 19.3978 6.34298 18.9738 6.63321Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M18.304 0.594727H1.87563C1.30249 0.594727 0.861857 0.788265 0.553176 1.17494C0.24424 1.5618 0.0900269 2.04561 0.0900269 2.62583C0.0900269 3.09449 0.294676 3.60231 0.703794 4.14941C1.11291 4.69629 1.54825 5.12585 2.00958 5.43831C2.26249 5.61699 3.02517 6.14721 4.29762 7.02877C4.98452 7.50477 5.58187 7.91967 6.0952 8.27769C6.53275 8.58256 6.9101 8.84658 7.22165 9.06568C7.25741 9.09077 7.31366 9.13101 7.38831 9.18438C7.46874 9.24215 7.57052 9.31547 7.69609 9.40614C7.93788 9.58101 8.13876 9.72237 8.29874 9.83036C8.45851 9.93838 8.65209 10.059 8.87918 10.193C9.10609 10.3268 9.3201 10.4275 9.52098 10.4944C9.72189 10.5613 9.90787 10.5948 10.079 10.5948H10.0901H10.1012C10.2723 10.5948 10.4583 10.5613 10.6592 10.4944C10.8601 10.4275 11.0739 10.3271 11.301 10.193C11.5279 10.059 11.7212 9.93813 11.8815 9.83036C12.0414 9.72237 12.2423 9.58105 12.4841 9.40614C12.6095 9.31547 12.7112 9.24212 12.7917 9.18457C12.8664 9.13097 12.9226 9.09099 12.9586 9.06568C13.2013 8.8968 13.5795 8.63387 14.088 8.28078C15.0133 7.63789 16.3759 6.69166 18.1818 5.43831C18.7249 5.05896 19.1786 4.60119 19.5433 4.06564C19.9073 3.53008 20.0898 2.96831 20.0898 2.38051C20.0898 1.8894 19.9129 1.46917 19.5597 1.11917C19.2062 0.769601 18.7876 0.594727 18.304 0.594727Z"
                                            fill="#FF3D24" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_736_3009">
                                            <rect width="21" height="17" fill="white"
                                                transform="translate(-6.10352e-05 0.109375)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </span>
                            <p class="ak-font-24 ak-primary-font ak-white-color ak-bold">
                                '. $settings['apnt_mail'] .'
                            </p>
                        </div>
                        <div class="d-flex align-items-center gap-3 mb-3">
                            <span>
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21"
                                    fill="none">
                                    <g clip-path="url(#clip0_736_3019)">
                                        <path
                                            d="M4.49929 2.77637C4.58769 2.77637 4.67248 2.74125 4.73499 2.67874C4.7975 2.61622 4.83262 2.53144 4.83262 2.44303V1.1097C4.83262 1.0213 4.7975 0.93651 4.73499 0.873998C4.67248 0.811486 4.58769 0.776367 4.49929 0.776367C4.41088 0.776367 4.3261 0.811486 4.26359 0.873998C4.20107 0.93651 4.16595 1.0213 4.16595 1.1097V2.44303C4.16595 2.53144 4.20107 2.61622 4.26359 2.67874C4.3261 2.74125 4.41088 2.77637 4.49929 2.77637Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M8.49929 2.77637C8.58769 2.77637 8.67248 2.74125 8.73499 2.67874C8.7975 2.61622 8.83262 2.53144 8.83262 2.44303V1.1097C8.83262 1.0213 8.7975 0.93651 8.73499 0.873998C8.67248 0.811486 8.58769 0.776367 8.49929 0.776367C8.41088 0.776367 8.3261 0.811486 8.26359 0.873998C8.20107 0.93651 8.16595 1.0213 8.16595 1.1097V2.44303C8.16595 2.53144 8.20107 2.61622 8.26359 2.67874C8.3261 2.74125 8.41088 2.77637 8.49929 2.77637Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M16.4993 2.77637C16.5877 2.77637 16.6725 2.74125 16.735 2.67874C16.7975 2.61622 16.8326 2.53144 16.8326 2.44303V1.1097C16.8326 1.0213 16.7975 0.93651 16.735 0.873998C16.6725 0.811486 16.5877 0.776367 16.4993 0.776367C16.4109 0.776367 16.3261 0.811486 16.2636 0.873998C16.2011 0.93651 16.166 1.0213 16.166 1.1097V2.44303C16.166 2.53144 16.2011 2.61622 16.2636 2.67874C16.3261 2.74125 16.4109 2.77637 16.4993 2.77637Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M12.4993 2.77637C12.5877 2.77637 12.6725 2.74125 12.735 2.67874C12.7975 2.61622 12.8326 2.53144 12.8326 2.44303V1.1097C12.8326 1.0213 12.7975 0.93651 12.735 0.873998C12.6725 0.811486 12.5877 0.776367 12.4993 0.776367C12.4109 0.776367 12.3261 0.811486 12.2636 0.873998C12.2011 0.93651 12.166 1.0213 12.166 1.1097V2.44303C12.166 2.53144 12.2011 2.61622 12.2636 2.67874C12.3261 2.74125 12.4109 2.77637 12.4993 2.77637Z"
                                            fill="#FF3D24" />
                                        <path d="M11.833 10.0596L10.1933 12.1092H11.833V10.0596Z" fill="#FF3D24" />
                                        <path
                                            d="M1.16595 17.7764C1.16648 18.2182 1.34225 18.6418 1.65469 18.9543C1.96714 19.2667 2.39076 19.4425 2.83262 19.443H18.166C18.6078 19.4425 19.0314 19.2667 19.3439 18.9543C19.6563 18.6418 19.8321 18.2182 19.8326 17.7764V4.77637H1.16595V17.7764ZM14.166 14.1097V12.443C14.166 12.3546 14.2011 12.2698 14.2636 12.2073C14.3261 12.1448 14.4109 12.1097 14.4993 12.1097C14.5877 12.1097 14.6725 12.1448 14.735 12.2073C14.7975 12.2698 14.8326 12.3546 14.8326 12.443V13.171C14.9394 13.1316 15.0521 13.1108 15.166 13.1097C15.4312 13.1097 15.6855 13.2151 15.8731 13.4026C16.0606 13.5901 16.166 13.8445 16.166 14.1097V14.443C16.166 14.5314 16.1308 14.6162 16.0683 14.6787C16.0058 14.7412 15.921 14.7764 15.8326 14.7764C15.7442 14.7764 15.6594 14.7412 15.5969 14.6787C15.5344 14.6162 15.4993 14.5314 15.4993 14.443V14.1097C15.4993 14.0213 15.4642 13.9365 15.4017 13.874C15.3391 13.8115 15.2544 13.7764 15.166 13.7764C15.0775 13.7764 14.9928 13.8115 14.9303 13.874C14.8677 13.9365 14.8326 14.0213 14.8326 14.1097V14.443C14.8326 14.5314 14.7975 14.6162 14.735 14.6787C14.6725 14.7412 14.5877 14.7764 14.4993 14.7764C14.4109 14.7764 14.3261 14.7412 14.2636 14.6787C14.2011 14.6162 14.166 14.5314 14.166 14.443V14.1097ZM9.23895 12.2347L11.9056 8.90137C11.9488 8.84741 12.0076 8.80819 12.074 8.78914C12.1404 8.77008 12.2111 8.77214 12.2763 8.79502C12.3415 8.81789 12.398 8.86047 12.4379 8.91684C12.4779 8.97322 12.4993 9.04061 12.4993 9.1097V12.1097H13.166C13.2544 12.1097 13.3391 12.1448 13.4017 12.2073C13.4642 12.2698 13.4993 12.3546 13.4993 12.443C13.4993 12.5314 13.4642 12.6162 13.4017 12.6787C13.3391 12.7412 13.2544 12.7764 13.166 12.7764H12.4993V14.443C12.4993 14.5314 12.4642 14.6162 12.4017 14.6787C12.3391 14.7412 12.2544 14.7764 12.166 14.7764C12.0775 14.7764 11.9928 14.7412 11.9303 14.6787C11.8677 14.6162 11.8326 14.5314 11.8326 14.443V12.7764H9.49929C9.43648 12.7764 9.37494 12.7587 9.32176 12.7252C9.26859 12.6918 9.22594 12.644 9.19873 12.5874C9.17152 12.5308 9.16086 12.4677 9.16798 12.4053C9.17509 12.3429 9.1997 12.2837 9.23895 12.2347ZM6.76595 8.77637C7.43462 8.77637 8.69929 9.1647 8.69929 10.6334C8.69929 12.025 7.24229 13.3597 6.24495 14.1097H9.16595C9.25436 14.1097 9.33915 14.1448 9.40166 14.2073C9.46417 14.2698 9.49929 14.3546 9.49929 14.443C9.49929 14.5314 9.46417 14.6162 9.40166 14.6787C9.33915 14.7412 9.25436 14.7764 9.16595 14.7764H5.16595C5.09297 14.7764 5.02201 14.7524 4.96395 14.7082C4.90589 14.664 4.86396 14.6019 4.84458 14.5315C4.8252 14.4612 4.82945 14.3864 4.85667 14.3187C4.8839 14.251 4.9326 14.1941 4.99529 14.1567C5.83995 13.653 8.03262 12.038 8.03262 10.6334C8.03262 9.4867 6.89429 9.44403 6.76595 9.44303C6.6026 9.43002 6.43834 9.45136 6.28373 9.50567C6.12913 9.55998 5.98761 9.64607 5.86829 9.75839C5.74897 9.87071 5.65449 10.0068 5.59094 10.1578C5.52738 10.3089 5.49616 10.4715 5.49929 10.6354C5.4985 10.7233 5.46303 10.8073 5.4006 10.8691C5.33818 10.931 5.25384 10.9657 5.16595 10.9657C5.07784 10.9653 4.99348 10.9299 4.93133 10.8675C4.86918 10.805 4.83429 10.7205 4.83429 10.6324C4.82918 10.3808 4.87625 10.1308 4.97252 9.89828C5.06879 9.66576 5.21218 9.4557 5.39366 9.28133C5.57513 9.10697 5.79075 8.97208 6.02694 8.88517C6.26312 8.79826 6.51474 8.76122 6.76595 8.77637Z"
                                            fill="#FF3D24" />
                                        <path
                                            d="M18.166 2.10938H17.4993V2.44271C17.4993 2.70792 17.3939 2.96228 17.2064 3.14982C17.0189 3.33735 16.7645 3.44271 16.4993 3.44271C16.2341 3.44271 15.9797 3.33735 15.7922 3.14982C15.6046 2.96228 15.4993 2.70792 15.4993 2.44271V2.10938H13.4993V2.44271C13.4993 2.70792 13.3939 2.96228 13.2064 3.14982C13.0189 3.33735 12.7645 3.44271 12.4993 3.44271C12.2341 3.44271 11.9797 3.33735 11.7922 3.14982C11.6046 2.96228 11.4993 2.70792 11.4993 2.44271V2.10938H9.49929V2.44271C9.49929 2.70792 9.39393 2.96228 9.2064 3.14982C9.01886 3.33735 8.7645 3.44271 8.49929 3.44271C8.23407 3.44271 7.97972 3.33735 7.79218 3.14982C7.60464 2.96228 7.49929 2.70792 7.49929 2.44271V2.10938H5.49929V2.44271C5.49929 2.70792 5.39393 2.96228 5.2064 3.14982C5.01886 3.33735 4.7645 3.44271 4.49929 3.44271C4.23407 3.44271 3.97972 3.33735 3.79218 3.14982C3.60464 2.96228 3.49929 2.70792 3.49929 2.44271V2.10938H2.83262C2.39076 2.1099 1.96714 2.28567 1.65469 2.59812C1.34225 2.91056 1.16648 3.33418 1.16595 3.77604V4.10938H19.8326V3.77604C19.8321 3.33418 19.6563 2.91056 19.3439 2.59812C19.0314 2.28567 18.6078 2.1099 18.166 2.10938Z"
                                            fill="#FF3D24" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_736_3019">
                                            <rect width="20" height="20" fill="white"
                                                transform="translate(-6.10352e-05 0.109375)" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </span>
                            <p class="ak-font-24 ak-primary-font ak-white-color ak-bold">
                                '. $settings['apnt_opnh'] .'
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            <div class="contact-form form-bg" data-aos="fade-up" data-aos-delay="750">
                <div id="ak-alert"></div>
					'. do_shortcode($settings['apnt_fsrtc2']) .'
				</div>
			</div>
		</div>';
}
	}
	
	protected function _content_template() {

    }
	
}