<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

// If plugin - 'Elementor' not exist then return.
if ( ! class_exists( '\Elementor\Plugin' ) ) {
	return;
}

//Widget Ordering in Top
function add_elementor_widget_categories( $elements_manager ) {

	$categories = [];
    $categories['cras-category'] =
		
		[
			'title' => esc_html__( 'Cras Widgets', 'cras' ),
			'icon' => 'fa fa-plug',
			'active' => true,
		];

	$old_categories = [];		
	$old_categories = $elements_manager->get_categories();
    $categories = array_merge($categories, $old_categories);

    $set_categories = function ( $categories ) {
        $this->categories = $categories;
    };

    $set_categories->call( $elements_manager, $categories );

}
add_action( 'elementor/elements/categories_registered', 'add_elementor_widget_categories' );

//Widget-Breadcrumb
class cras_Widget_Breadcrumb {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-breadcrumb.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_brdc() );
	}

}

add_action( 'init', 'cras_elementor_brc_init' );
function cras_elementor_brc_init() {
	cras_Widget_Breadcrumb::get_instance();
}


//Widget-Slider
class cras_Widget_Slider {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-slider.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_sld() );
	}

}

add_action( 'init', 'cras_elementor_init' );
function cras_elementor_init() {
	cras_Widget_Slider::get_instance();
}


//Widget-Slider2
class cras_Widget_Slider2 {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-slider2.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_sld2() );
	}

}

add_action( 'init', 'cras_elementor_hero_init' );
function cras_elementor_hero_init() {
	cras_Widget_Slider2::get_instance();
}


//Widget-Slider3
class cras_Widget_Slider3 {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-slider3.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_sld3() );
	}

}

add_action( 'init', 'cras_elementor_video_slider_init' );
function cras_elementor_video_slider_init() {
	cras_Widget_Slider3::get_instance();
}


//Widget-Pricing
class cras_Widget_Pricing {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-pricing.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_pricing() );
	}

}

add_action( 'init', 'cras_elementor_pricing_init' );
function cras_elementor_pricing_init() {
	cras_Widget_Pricing::get_instance();
}


//Widget-About_Us
class cras_Widget_Aboutus {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-aboutus.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_abus() );
	}

}

add_action( 'init', 'cras_elementor_about_init' );
function cras_elementor_about_init() {
	cras_Widget_Aboutus::get_instance();
}

//Widget-Services
class cras_Widget_Services {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-our-services.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_osrv() );
	}

}

add_action( 'init', 'cras_elementor_srv_init' );
function cras_elementor_srv_init() {
	cras_Widget_Services::get_instance();
}

//Widget-Gallery
class cras_Widget_Gallery {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-gallery.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_gallery() );
	}

}

add_action( 'init', 'cras_elementor_gallery_init' );
function cras_elementor_gallery_init() {
	cras_Widget_Gallery::get_instance();
}

//Widget-Team
class cras_Widget_Team {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-team.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_team() );
	}

}

add_action( 'init', 'cras_elementor_team_init' );
function cras_elementor_team_init() {
	cras_Widget_Team::get_instance();
}


//Widget-Blog
class cras_Widget_Blog {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-blog.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_blog() );
	}

}

add_action( 'init', 'cras_elementor_blog_init' );
function cras_elementor_blog_init() {
	cras_Widget_Blog::get_instance();
}


//Widget-Contact
class cras_Widget_Contact {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-contact.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_contact() );
	}

}

add_action( 'init', 'cras_elementor_contact_init' );
function cras_elementor_contact_init() {
	cras_Widget_Contact::get_instance();
}


//Widget-FAQ
class cras_Widget_FAQ {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-faq.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_FAQ_Widget() );
	}

}

add_action( 'init', 'cras_elementor_faq_init' );
function cras_elementor_faq_init() {
	cras_Widget_FAQ::get_instance();
}


//Widget-Testimonials
class cras_Widget_Testimonials {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-testimonials.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_Testimonials_Widget() );
	}

}

add_action( 'init', 'cras_elementor_testimonials_init' );
function cras_elementor_testimonials_init() {
	cras_Widget_Testimonials::get_instance();
}


//Widget-Clients
class cras_Widget_Clients {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-clients.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_clients() );
	}

}

add_action( 'init', 'cras_elementor_clients_init' );
function cras_elementor_clients_init() {
	cras_Widget_Clients::get_instance();
}


//Widget-Video
class cras_Widget_vd {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-video.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_video() );
	}

}

add_action( 'init', 'cras_elementor_video_init' );
function cras_elementor_video_init() {
	cras_Widget_vd::get_instance();
}

//Widget-Awards
class cras_Widget_fesm {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-featuredmember.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Custom_fesm_Widget() );
	}

}

add_action( 'init', 'cras_elementor_fesm_init' );
function cras_elementor_fesm_init() {
	cras_Widget_fesm::get_instance();
}


//Widget-FunFact
class cras_Widget_FunFact {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-funfact.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_FunFact_Widget() );
	}

}

add_action( 'init', 'cras_elementor_funfact_init' );
function cras_elementor_funfact_init() {
	cras_Widget_FunFact::get_instance();
}


//Widget-Subscriptions
class cras_Widget_Subscriptions {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-subscriptions.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_Subscriptions_Widget() );
	}

}

add_action( 'init', 'cras_elementor_subs_init' );
function cras_elementor_subs_init() {
	cras_Widget_Subscriptions::get_instance();
}


//Widget-HowtoWork
class cras_Widget_htw {

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-howtowork.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_htw_Widget() );
	}

}

add_action( 'init', 'cras_elementor_htw_init' );
function cras_elementor_htw_init() {
	cras_Widget_htw::get_instance();
}

//Widget-Tab
class cras_Widget_Tab{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-tab.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_tab() );
	}

}

add_action( 'init', 'cras_elementor_tab_init' );
function cras_elementor_tab_init() {
	cras_Widget_Tab::get_instance();
}


//Widget-Features
class cras_Widget_Features{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-features.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_Features_Widget() );
	}

}

add_action( 'init', 'cras_elementor_fetr_init' );
function cras_elementor_fetr_init() {
	cras_Widget_Features::get_instance();
}


//Widget-GetInTouch
class cras_Widget_GIT{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-git.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\Custom_git_Widget() );
	}

}

add_action( 'init', 'cras_elementor_git_init' );
function cras_elementor_git_init() {
	cras_Widget_GIT::get_instance();
}


//Widget-WorkingProcess
class cras_Widget_WhyChooseUs{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-whychooseus.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_wcu_Widget() );
	}

}

add_action( 'init', 'cras_elementor_wcu_init' );
function cras_elementor_wcu_init() {
	cras_Widget_WhyChooseUs::get_instance();
}

//Widget-Appointment
class cras_Widget_Appointment{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-appointment.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_Appointment() );
	}

}

add_action( 'init', 'cras_elementor_apnt_init' );
function cras_elementor_apnt_init() {
	cras_Widget_Appointment::get_instance();
}

//Widget Project Slider
class cras_Widget_ProSld{

	protected static $instance = null;

	public static function get_instance() {
		if ( ! isset( static::$instance ) ) {
			static::$instance = new static;
		}

		return static::$instance;
	}

	protected function __construct() {
		require_once('widget-projects-slider.php');
		add_action( 'elementor/widgets/widgets_registered', [ $this, 'register_widgets' ] );
	}

	public function register_widgets() {
		\Elementor\Plugin::instance()->widgets_manager->register_widget_type( new \Elementor\cras_widget_project_sld() );
	}

}

add_action( 'init', 'cras_elementor_prosld_init' );
function cras_elementor_prosld_init() {
	cras_Widget_ProSld::get_instance();
}


