<?php
/**
 * ReduxFramework Sample Config File
 * For full documentation, please visit: http://docs.reduxframework.com/
 */

if (!class_exists('Redux')) {
    return;
}


// This is your option name where all the Redux data is stored.
$opt_name = "cras_options";

// This line is only for altering the demo. Can be easily removed.
$opt_name = apply_filters('cras_options/opt_name', $opt_name);

/*
 *
 * --> Used within different fields. Simply examples. Search for ACTUAL DECLARATION for field examples
 *
 */

$sampleHTML = '';
if (file_exists(dirname(__FILE__) . '/info-html.html')) {
    Redux_Functions::initWpFilesystem();
    
    global $wp_filesystem;
    
    $sampleHTML = $wp_filesystem->get_contents(dirname(__FILE__) . '/info-html.html');
}

/**
 * ---> SET ARGUMENTS
 * All the possible arguments for Redux.
 * For full documentation on arguments, please refer to: https://github.com/ReduxFramework/ReduxFramework/wiki/Arguments
 * */

$theme = wp_get_theme(); // For use with some settings. Not necessary.

$args = array(
    // TYPICAL -> Change these values as you need/desire
    'opt_name' => $opt_name,
    // This is where your data is stored in the database and also becomes your global variable name.
    'display_name' => $theme->get('Name'),
    // Name that appears at the top of your panel
    'display_version' => $theme->get('Version'),
    // Version that appears at the top of your panel
    'menu_type' => 'menu',
    //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
    'allow_sub_menu' => true,
    // Show the sections below the admin menu item or not
    'menu_title' => esc_html__('Cras Options', 'cras'),
    'page_title' => esc_html__('Cras Options', 'cras'),
    // You will need to generate a Google API key to use this feature.
    // Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
    'google_api_key' => '',
    // Set it you want google fonts to update weekly. A google_api_key value is required.
    'google_update_weekly' => false,
    // Must be defined to add google fonts to the typography module
    'async_typography' => true,
    // Use a asynchronous font on the front end or font string
    //'disable_google_fonts_link' => true,                    // Disable this in case you want to create your own google fonts loader
    'admin_bar' => true,
    // Show the panel pages on the admin bar
    'admin_bar_icon' => 'dashicons-layout',
    // Choose an icon for the admin bar menu
    'admin_bar_priority' => 50,
    // Choose an priority for the admin bar menu
    'global_variable' => '',
    // Set a different name for your global variable other than the opt_name
    'dev_mode' => false,
    // Show the time the page took to load, etc
    'update_notice' => true,
    // If dev_mode is enabled, will notify developer of updated versions available in the GitHub Repo
    'customizer' => true,
    // Enable basic customizer support
    //'open_expanded'     => true,                    // Allow you to start the panel in an expanded way initially.
    //'disable_save_warn' => true,                    // Disable the save warning when a user changes a field
    
    // OPTIONAL -> Give you extra features
    'page_priority' => 30,
    // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
    'page_parent' => 'themes.php',
    // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
    'page_permissions' => 'manage_options',
    // Permissions needed to access the options panel.
    'menu_icon' => 'dashicons-portfolio',
    // Specify a custom URL to an icon
    'last_tab' => '',
    // Force your panel to always open to a specific tab (by id)
    'page_icon' => 'icon-themes',
    // Icon displayed in the admin panel next to your menu_title
    'page_slug' => '',
    // Page slug used to denote the panel, will be based off page title then menu title then opt_name if not provided
    'save_defaults' => true,
    // On load save the defaults to DB before user clicks save or not
    'default_show' => false,
    // If true, shows the default value next to each field that is not the default value.
    'default_mark' => '',
    // What to print by the field's title if the value shown is default. Suggested: *
    'show_import_export' => true,
    // Shows the Import/Export panel when not used as a field.
    
    'show_options_object' => false,
    // Removes the options_object panel when not used.
    
    // CAREFUL -> These options are for advanced use only
    'transient_time' => 60 * MINUTE_IN_SECONDS,
    'output' => true,
    // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
    'output_tag' => true,
    // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
    // 'footer_credit'     => '',                   // Disable the footer credit of Redux. Please leave if you can help it.
    
    // FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
    'database' => '',
    // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
    'use_cdn' => true,
    // If you prefer not to use the CDN for Select2, Ace Editor, and others, you may download the Redux Vendor Support plugin yourself and run locally or embed it in your code.
    
    // HINTS
    'hints' => array(
        'icon' => 'el el-question-sign',
        'icon_position' => 'right',
        'icon_color' => 'lightgray',
        'icon_size' => 'normal',
        'tip_style' => array(
            'color' => 'red',
            'shadow' => true,
            'rounded' => false,
            'style' => ''
        ),
        'tip_position' => array(
            'my' => 'top left',
            'at' => 'bottom right'
        ),
        'tip_effect' => array(
            'show' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'mouseover'
            ),
            'hide' => array(
                'effect' => 'slide',
                'duration' => '500',
                'event' => 'click mouseleave'
            )
        )
    )
);

// SOCIAL ICONS -> Setup custom links in the footer for quick links in your panel footer icons.
$args['share_icons'][] = array(
    'url' => 'https://github.com/ReduxFramework/ReduxFramework',
    'title' => 'Visit us on GitHub',
    'icon' => 'el el-github'
    //'img'   => '', // You can use icon OR img. IMG needs to be a full URL.
);
$args['share_icons'][] = array(
    'url' => 'https://www.facebook.com/pages/Redux-Framework/243141545850368',
    'title' => 'Like us on Facebook',
    'icon' => 'el el-facebook'
);
$args['share_icons'][] = array(
    'url' => 'http://twitter.com/reduxframework',
    'title' => 'Follow us on Twitter',
    'icon' => 'el el-twitter'
);
$args['share_icons'][] = array(
    'url' => 'http://www.linkedin.com/company/redux-framework',
    'title' => 'Find us on LinkedIn',
    'icon' => 'el el-linkedin'
);

// Panel Intro text -> before the form
if (!isset($args['global_variable']) || $args['global_variable'] !== false) {
    if (!empty($args['global_variable'])) {
        $v = $args['global_variable'];
    } else {
        $v = str_replace('-', '_', $args['opt_name']);
    }
    $args['intro_text'] = sprintf(esc_html__(' Customize your website using the cras theme options panel.', 'cras'), $v);
} else {
    $args['intro_text'] = esc_html__(' Customize your website using the cras theme options panel.', 'cras');
}

// Add content after the form.
$args['footer_text'] = esc_html__('If you like our theme and support, please rate us 5 stars on ThemeForest.', 'cras');

Redux::setArgs($opt_name, $args);

/*
 * ---> END ARGUMENTS
 */


/*
 * ---> START HELP TABS
 */

$tabs = array(
    array(
        'id' => 'redux-help-tab-1',
        'title' => esc_html__('Theme Information 1', 'cras'),
        'content' => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'cras')
    ),
    array(
        'id' => 'redux-help-tab-2',
        'title' => esc_html__('Theme Information 2', 'cras'),
        'content' => esc_html__('<p>This is the tab content, HTML is allowed.</p>', 'cras')
    )
);
Redux::set_help_tab($opt_name, $tabs);

// Set the help sidebar
$content = esc_html__('<p>This is the sidebar content, HTML is allowed.</p>', 'cras');
Redux::set_help_sidebar($opt_name, $content);


/*
 * <--- END HELP TABS
 */


/*
 *
 * ---> START SECTIONS
 *
 */

/*
As of Redux 3.5+, there is an extensive API. This API can be used in a mix/match mode allowing for
*/

// -> START Panel OPtions

/*
 *
 * --> General Sections Tab
 *
 */

Redux::setSection($opt_name, array(
    'id' => 'general_tab',
    'title' => esc_html__('General Settings', 'cras'),
    'desc' => esc_html__('All the general settings options are listed here', 'cras'),
    'icon' => 'el el-globe',
    'fields' => array(
        
        // -> Preloader Options
        array(
            'id' => 'cras_pageLoader',
            'type' => 'switch',
            'title' => esc_html__('Preloader', 'cras'), 
            'subtitle' => esc_html__( 'Enable or Disable Preloader', 'cras' ),
            'default' => 'false',
            'on' =>'Enabled',
            'off' =>'Disabled',
            ),

        array(
            'id' => 'cras_preloader_img',    
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Preloader Image/Icon', 'cras'),
            'compiler' => 'true',
            'subtitle' => esc_html__('Upload required Preloader Image/Icon from your hard drive or specify an existing url.', 'cras'),
            'default' => array(
            'url' => ''
            )
        ),
        array(
            'id' => 'cras_pageLoader_bg',
            'type' => 'color_rgba',
            'output' => array('background-color' => '.preloader-content' ),
            'title' => esc_html__('Preloader Background color', 'cras'),
            'subtitle' => esc_html__('Choose Background color.', 'cras'),
            'default' => '',
        ),
       
        // -> Favicon
        array(
            'id' => 'cras_favicon',    
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Favicon', 'cras'),
            'compiler' => 'true',
            'subtitle' => esc_html__('Upload a favicon from your hard drive or specify an existing url.', 'cras'),
            'default' => array(
            'url' => ''
            )
        ),

        // -> Membership enable or disable option
        array(
            'id' => 'member_display',
            'type' => 'switch',
            'title' => esc_html__('User Membership', 'cras'), 
            'subtitle' => esc_html__( 'Enable or Disable Membership', 'cras' ),
            'default' => '1',
            'on' =>'Enabled',
            'off' =>'Disabled',
            ),          

        // -> Back to top switch        
        array(
            'id' => 'cras_back_top',
            'type' => 'switch',
            'title' => esc_html__('Bottom to Top', 'cras'), 
            'subtitle' => esc_html__( 'Enable or Disable Back to Top', 'cras' ),
            'default' => '1',
            'on' =>'Enabled',
            'off' =>'Disabled',
            ),          
    )
));

// -> START Top Header Setting
Redux::setSection( $opt_name, array(
'title'            => esc_html__( 'Top Header Settings', 'cras' ),
'id'               => 'cras_header_options',
'customizer_width' => '400px',
'icon'             => 'el el-opensource',
'fields'           => array(

    array(
        'id'       => 'cras_sh_phn',
        'type'     => 'text',
        'title'    => esc_html__( 'Phone Number', 'cras' ),
        'subtitle' => esc_html__( 'Enter Required Phone Number', 'cras' ),
        'default'  => ''
    ),
    array(
        'id'       => 'cras_sh_mail',
        'type'     => 'text',
        'title'    => esc_html__( 'Email Address', 'cras' ),
        'subtitle' => esc_html__( 'Enter Required Email Address', 'cras' ),
        'default'  => ''
    ),

)));


// -> START Page Settings
Redux::setSection( $opt_name, array(
'title'            => esc_html__( 'Page Settings', 'cras' ),
'id'               => 'cras_page_layout',
'customizer_width' => '400px',
'icon'             => 'el el-livejournal',
'fields'           => array(
    array(
        'id'       => 'cras_page_layout',
        'type'     => 'image_select',
        'title'    => esc_html__('Page Layout', 'cras'),
        'subtitle' => esc_html__('Page layout content for theme sidebar alignment. Choose from Fullwidth, Left sidebar or Right sidebar layout. (Its only enable for default page settings.)', 'cras'),
        'options'  => array(
        '1'      => array(
            'alt'   => '1 Column',
            'img'   => ReduxFramework::$_url.'assets/img/1col.png'
        ),
        '2'      => array(
            'alt'   => '2 Column Left',
            'img'   => ReduxFramework::$_url.'assets/img/2cl.png'
        ),
        '3'      => array(
            'alt'   => '2 Column Right',
            'img'  => ReduxFramework::$_url.'assets/img/2cr.png'
        )
    )),
    'default' => '2',
    
    array(
        'id'       => 'cras_page_comment',
        'type'     => 'switch',
        'title'    => esc_html__('Globally enable or disable page comments', 'cras'),
        'subtitle' => esc_html__('Enable or Disabled Page Comments. (Its only enable for default page settings.)', 'cras'),
        'on'       => 'Enabled',
        'off'      => 'Disabled',
        'default'  => true
    ),

)));


 // START -> Blog Settings
 Redux::setSection( $opt_name, array(
'title'            => esc_html__( 'Blog Settings', 'cras' ),
'id'               => 'blog-settings',
'customizer_width' => '400px',
'icon'             => 'el el-edit',
'fields'           => array(

    array(
        'id'       => 'cras_social_share',
        'type'     => 'switch',
        'title'    => esc_html__('Social Share', 'cras'),
        'subtitle' => esc_html__('Blog single Social Share.', 'cras'),
        'on'       => 'show',
        'off'      => 'hide',
        'default'  => false,
    ),
    array(
        'id'       => 'cras_bl_page_title',
        'type'     => 'text',
        'title'    => esc_html__( 'Defult Blog Page Title', 'cras' ),
        'subtitle' => esc_html__( 'Enter the Title here', 'cras' ),
        'default'  => ''
    ),
    
    
    array(
        'id'       => 'cras_bl_single_title',
        'type'     => 'text',
        'title'    => esc_html__( 'Blog Single Page Title', 'cras' ),
        'subtitle' => esc_html__( 'Enter the Title here', 'cras' ),
        'default'  => ''
    ),

    array(
            'id'       => 'cras_relp_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Related Post Section Title', 'cras' ),
            'subtitle' => esc_html__( 'Enter a Title here', 'cras' ),
            'default'  => ''
    ),

    array(
            'id'       => 'cras_relp_tagline',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Related Post Section Tagline', 'cras' ),
            'subtitle' => esc_html__( 'Enter a Tagline', 'cras' ),
            'default'  => ''
    ),

    array(
            'id'       => 'cras_relp_desc',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Blog Related Post Section Description', 'cras' ),
            'subtitle' => esc_html__( 'Enter a Description', 'cras' ),
            'default'  => ''
    ),

    array(
        'id'       => 'cras_relp_no',
        'type'     => 'text',
        'title'    => esc_html__( 'Blog Related Post Number', 'cras' ),
        'subtitle' => esc_html__( 'Enter Post Number', 'cras' ),
        'default'  => ''
    ),

    array(
        'id'       => 'cras_switch_navigation',
        'type'     => 'switch',
        'title'    => esc_html__('Post navigation', 'cras'),
        'subtitle' => esc_html__('Blog single post navigation.', 'cras'),
        'on'       => 'show',
        'off'      => 'hide',
        'default'  => false,
    ),
    array(
        'id'       => 'cras_author_bio',
        'type'     => 'switch',
        'title'    => esc_html__('Author Information', 'cras'),
        'subtitle' => esc_html__('Author Information Button.', 'cras'),
        'on'       => 'show',
        'off'      => 'hide',
        'default'  => false,
    ),
)));


 // START -> Single Page Title
 Redux::setSection( $opt_name, array(
    'title'            => esc_html__( 'Single Page Title', 'cras' ),
    'id'               => 'single-page-settings',
    'customizer_width' => '400px',
    'icon'             => 'el el-edit',
    'fields'           => array(
    
        array(
            'id'       => 'cras_bl_single_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Blog Single Page Title', 'cras' ),
            'subtitle' => esc_html__( 'Enter the Title', 'cras' ),
            'default'  => ''
        ),
        
        array(
            'id'       => 'cras_tm_single_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Team Single Page Title', 'cras' ),
            'subtitle' => esc_html__( 'Enter the Title', 'cras' ),
            'default'  => ''
        ),

        array(
            'id'       => 'cras_srv_single_title',
            'type'     => 'text',
            'title'    => esc_html__( 'Services Single Page Title', 'cras' ),
            'subtitle' => esc_html__( 'Enter the Title', 'cras' ),
            'default'  => ''
        ),

    )
)
);


/*
 *
 * --> Social Connections Tab
 *
 */
Redux::setSection($opt_name, array(
    'id' => 'social_tab',
    'title' => esc_html__('Social Connections', 'cras'),
    'desc' => esc_html__('All the Social Connections related options are listed here', 'cras'),
    'icon' => 'el el-facebook',
    'fields' => array(
        array(
            'id' => 'cras_fblink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Facebook', 'cras'),
            'subtitle' => esc_html__('Enter Facebook Link.', 'cras'),
            'default' => '#'
        ),      
        array(
            'id' => 'cras_twlink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Twitter', 'cras'),
            'subtitle' => esc_html__('Enter Twitter Link', 'cras'),
            'default' => '#'
        ),
        array(
            'id' => 'cras_ldlink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Linkedin', 'cras'),
            'subtitle' => esc_html__('Enter Linkedin Link', 'cras'),
            'default' => '#'
        ),
        array(
            'id' => 'cras_gplink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Google Plus', 'cras'),
            'subtitle' => esc_html__('Enter Google Plus Link', 'cras'),
            'default' => '#'
        ),
        array(
            'id' => 'cras_drlink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Dribbble', 'cras'),
            'subtitle' => esc_html__('Enter Dribbble Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_tumblink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Tumblr', 'cras'),
            'subtitle' => esc_html__('Tumblr Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_inslink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Instagram', 'cras'),
            'subtitle' => esc_html__('Enter Instagram Link', 'cras'),
            'default' => '#'
        ),
        array(
            'id' => 'cras_behlink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Behance', 'cras'),
            'subtitle' => esc_html__('Enter Behance Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_youtube',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('You Tube', 'cras'),
            'subtitle' => esc_html__('Enter You Tube Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_vmlink',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Vimeo Link', 'cras'),
            'subtitle' => esc_html__('Enter Vimeo Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_git',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('GitHub', 'cras'),
            'subtitle' => esc_html__('Enter GitHub Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_pt',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Pinterest', 'cras'),
            'subtitle' => esc_html__('Enter Pinterest Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_flc',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Flickr', 'cras'),
            'subtitle' => esc_html__('Enter Flickr Link', 'cras'),
            'default' => ''
        ),
        array(
            'id' => 'cras_skp',
            'type' => 'text',
            'url' => true,
            'title' => esc_html__('Skype Link', 'cras'),
            'subtitle' => esc_html__('Enter Skype Link', 'cras'),
            'default' => ''
        ),

    )
));


/*
 *
 * --> Colors Sections Tab
 *
 */

// -> Section Title
Redux::setSection( $opt_name, array(
    'id' => 'colors',
    'title' => esc_html__('Color Options', 'cras'),
    'desc' => esc_html__('All the Color options of the theme are listed here', 'cras'),
    'customizer_width' => '400px',
    'icon' => 'el el-barcode',    
) );

Redux::setSection($opt_name, array(
    'id' => 'menu_colors',
    'title' => esc_html__('Header & Menu', 'cras'),
    'desc' => esc_html__('All the menu Color options of the theme are listed here', 'cras'),
    'icon' => '',
    'subsection'       => true,
    'customizer_width' => '450px',
    'fields' => array(  
        
        array(
            'id' => 'cras_primary_color',
            'type' => 'color',
            'title' => esc_html__('Primary Color', 'cras'),
            'subtitle' => esc_html__('Insert your required color.', 'cras'),
            'validate' => 'color',
            'default' => '',
        ),
        
        array(
            'id' => 'menu_cl_background',
            'type' => 'color_rgba',
            'title' => esc_html__('Navbar/Menubar Background Color', 'cras'),
            'subtitle' => esc_html__('Insert your Menu background color', 'cras'),
            'default' => array(
                'color' => '',
                'alpha' => '1'
            ),
            'validate' => 'colorrgba',
            'output' => array(
                'background' => '.ak-sticky_header'
            ),
        ),
        array(
            'id'       => 'menu_navbar_border',
            'type'     => 'color_rgba',
            'title'    => esc_html__( 'Navbar/Menubar border color', 'cras' ),
            'subtitle' => esc_html__( 'Choose Navbar border color.', 'cras' ),
            'default'  => '',
            'validate' => 'color',
            'output'   => array( 
                 'background-color' => '.nav-bar-border'
            ),
        ),
        array(
            'id' => 'menu_text_link',
            'type' => 'link_color',
            'title' => esc_html__('Menu item Text colors', 'cras'),
            'subtitle' => esc_html__('Insert the text colors for the navigation menu item', 'cras'),
            'default' => array(
                'regular' => '',
            ),
            'validate' => 'color',
            'output' => array( 'a.text-hover-animaiton, .ak-nav .ak-nav_list a, .ak-nav .ak-nav_list > li > a, .ak-nav .ak-nav_list li:not(.ak-mega_menu) a' )
        ), 
        array(
            'id'       => 'menu_plus_icon',
            'type'     => 'color_rgba',
            'title'    => esc_html__( 'Menu Item Plus Icon color', 'cras' ),
            'subtitle' => esc_html__( 'Choose icon color.', 'cras' ),
            'default'  => '',
            'validate' => 'color',
            'output'   => array( 
                 'background-color' => '.ak-munu_dropdown_toggle_1:before, .ak-munu_dropdown_toggle_1:after, .ak-munu_dropdown_toggle:before, .ak-munu_dropdown_toggle:after'
            ),
        ),       
        
        array(
            'id'       => 'submenu_border',
            'type'     => 'border',
            'title'    => esc_html__( 'Sub-menu Border top color', 'cras' ),
            'subtitle' => esc_html__( 'Select the border style and color for the navigation submenu top border.', 'cras' ),
            'output'   => array( '.navbar-nav > li > ul.sub-menu' ),
            // An array of CSS selectors to apply this font style to
            'desc'     => esc_html__( 'This is the description field, again good for additional info.', 'cras' ),
            'default'  => array(
                'border-color'  => '', 
                'border-style'  => 'solid',
                'border-color'  => '',
                'border-style'  => '',
                'border-top'    => '',
            )
        ),
    )
) );

Redux::setSection($opt_name, array(
    'id' => 'content_colors',
    'title' => esc_html__('Content', 'cras'),
    'desc' => esc_html__('All the Content Color options of the theme are listed here', 'cras'),
    'icon' => '',
    'subsection'       => true,
    'customizer_width' => '450px',
    'fields' => array(        
        array(
            'id' => 'headings_color',
            'type' => 'color',
            'output' => array( 'h1, h2, .ak-section-heading.ak-style-1 .ak-section-title, .service-card .card-info .card-title, .social-hero .social-link, h3, h4, h5, h6' ),
            'title' => esc_html__('Headings / Title Text Color', 'cras'),
            'subtitle' => esc_html__('Choose (h1, h2, h3, h4, h5, h6) text color for all the headings.', 'cras'),
            'validate' => 'color',
            'default' => '',
            'important' => true
        ),
        array(
            'id' => 'page_subtitle_color',
            'type' => 'color',
            'output' => array( '.title h3, .title-personal h1, .title-about h2 span ' ),
            'title' => esc_html__('Second Headings and Sub-title Text Color', 'cras'),
            'subtitle' => esc_html__('Choose Second Headings and Sub-title Text Color.', 'cras'),
            'validate' => 'color',
            'default' => ''
        ),
        array(
            'id' => 'paragraph_color',
            'type' => 'color',
            'output' => array( 'p, li, .sub, .text, .ak-funfact.ak-style1 .ak-funfact-text p, .ak-white-color, .ak-white-color-hover:hover, .custom-file .custom-file-upload' ),
            'title' => esc_html__('Paragraph & List Text Color ( p, li )', 'cras'),
            'subtitle' => esc_html__('Insert your text color for all the paragraphs & List.', 'cras'),
            'validate' => 'color',
        ),
        array(
            'id' => 'all_page_link',
            'type' => 'link_color',
            'title' => esc_html__('Link colors', 'cras'),
            'subtitle' => esc_html__('Insert your link colors for the all page', 'cras'),
            'default' => '',
            'output' => array( 'ul li a, li a, a,  .more-btn, .copyright a, .service-card .card-info .card-title:hover, .blog-card .blog-body-info .blog-title, .team-card .team-info .team-title a'  ),
        ),
        array(
            'id' => 'cras_stroke_text_color',
            'type' => 'color',
            'title' => esc_html__('Stroke Text Color', 'cras'),
            'subtitle' => esc_html__('Insert your text color for all the stroke text.', 'cras'),
            'validate' => 'color',
            'default' => '',
        ),
        array(
            'id' => 'button_color',
            'type' => 'color',
            'output' => array('background-color' => '.common-btn, .footer.style-1 .footer-email .footer-heading-email .email-form .submit-btn, .cta .cta-info .cta-btn, .more-btn::after, .company-tab .tabs .active-tab:after, .cta .border-pr, .primary-color-border, .ak-testimonal-controll .testimonal-controll .button:hover, .pricing-card.active, .get-started-btn:hover' ),
            'title' => esc_html__('Button & Line/Border color', 'cras'),
            'subtitle' => esc_html__('Choose Required color.', 'cras'),
            'default' => '',
        ),
        array(
            'id' => 'icon_bg_color',
            'type' => 'color',
            'title' => esc_html__('Icon Background color', 'cras'),
            'subtitle' => esc_html__('Choose Icon Background color.', 'cras'),
            'default' => '',
            'output' => array('background-color' => '.ak-heartbeat-btn:before, .ak-heartbeat-btn:after'),
            'important' => true
        ), 
        array(
            'id' => 'cras_addricon_color',
            'type' => 'color',
            'title' => esc_html__('Slider Icon Background color', 'cras'),
            'subtitle' => esc_html__('Choose Icon Background color.', 'cras'),
            'default' => '',
            'important' => true
        ), 
        array(
            'id' => 'pagination_txt',
            'type' => 'link_color',
            'title' => esc_html__( 'Pagination text color', 'cras' ),
            'subtitle' => esc_html__( 'Insert your text colors for the Pagination', 'cras' ),
            'default' => array(
                'regular' => '', 
                'hover' => '', 
                'active' => '' 
            ),            
            'validate' => 'color',
            'output' => array( '.page-link, .pagination-style .current.next, .pagination-style .current.prev' ),
        ),
        array(
            'id' => 'pagination_txt_current',
            'type' => 'color',
            'output' => array( '.pagination-style .current ' ),
            'title' => esc_html__('Current Pagination text color', 'cras'),
            'subtitle' => esc_html__('Current Pagination text color.', 'cras'),
            'validate' => 'color',
            'default' => ''
        ),
        array(
            'id' => 'contact_form_field',
            'type' => 'border',
            'title' => esc_html__( 'Contact Form Field color', 'cras' ),
            'subtitle' => esc_html__( 'Insert the color for Contact Form Field', 'cras' ),
            'default' => array(
                'border-color'  => '', 
                'border-style'  => 'solid',
                'border-top' => '1px', 
                'border-bottom' => '1px', 
                'border-left' => '1px', 
                'border-right' => '1px' 
            ),            
            'output' => array( '.contact-form .from-inputs .type_1 input, .contact-form .from-textarea .type_1 textarea' ),
        ),
        array(
            'id' => 'subscribe_form_field',
            'type' => 'border',
            'title' => esc_html__( 'Subscribe Form Field color', 'cras' ),
            'subtitle' => esc_html__( 'Insert the color for Subscribe Form Field', 'cras' ),
            'default' => array(
                'border-color'  => '', 
                'border-style'  => 'solid',
                'border-top' => '', 
                'border-bottom' => '1px', 
                'border-left' => '', 
                'border-right' => '' 
            ),            
            'output' => array( '.footer.style-1 .footer-email .footer-heading-email .email-form' ),
        ),
    )
) );

Redux::setSection($opt_name, array(
    'id' => 'footer_colors',
    'title' => esc_html__('Footer', 'cras'),
    'desc' => esc_html__('All the Footer Color options of the theme are listed here', 'cras'),
    'icon' => '',
    'subsection'       => true,
    'customizer_width' => '450px',
    'fields' => array(                
        array(
            'id' => 'footer_txt',
            'type' => 'color',
            'title' => esc_html__('Footer text color', 'cras'),
            'subtitle' => esc_html__('Insert your text colors for the Footer paragraphs.', 'cras'),
            'default' => '', 
            'validate' => 'color',
            'output' => array( '.footer p, .footer.style-1 .footer-content .footer-menu .menu-title, .footer.style-1 .footer-content .footer-address .adress-title', ),
        ),        
        array(
            'id' => 'footer_links',
            'type' => 'link_color',
            'title' => esc_html__('Footer Link color', 'cras'),
            'subtitle' => esc_html__('Insert your text colors for the Footer links.', 'cras'),
            'default'  => array(
                    'regular'  => '', 
                    'hover'    => '', 
                    'active'   => '',  
                    'important'   => 'true',  
                ),
            'validate' => 'color',
            'output' => array( '.footer.style-1 a.text-hover-animaiton, .footer.style-1 .footer-content .footer-info .phone ' ),
        ),        
        array(
            'id' => 'cras_copyright_txt',
            'type' => 'color',
            'title' => esc_html__('Copyright text color', 'cras'),
            'subtitle' => esc_html__('Insert your text colors for the Copyright paragraphs.', 'cras'),
            'default' => '',
            'validate' => 'color',
            'output' => array( 'p.title' ),
        ),        
        array(
            'id' => 'copyright_links',
            'type' => 'link_color',
            'title' => esc_html__('Copyright Link color', 'cras'),
            'subtitle' => esc_html__('Choose your text colors for the Copyright links.', 'cras'),
            'default'  => array(
                    'regular'  => '',
                    'hover'    => '',
                    'active'   => '',
                ),
            'validate' => 'color',
            'output' => array( '.copy-right a.text-hover-animaiton' ),
        ),       
    )
));


/*
 *
 * --> Comming Soon Tab
 *
 */

// Redux::setSection( $opt_name, array(
//         'id'         => 'comming_soon_tab',
//         'title'      => esc_html__( 'Comming Soon Settings', 'cras' ),
//         'desc'       => esc_html__( 'All those Comming Soon related options are listed here ', 'cras' ),
//         'icon'   => 'el el-website',
//         'fields'     => array(
//         array(
//             'id' => 'cras_cs_title',
//             'type' => 'text',
//             'title' => esc_html__('Title', 'cras'), 
//             'subtitle' => esc_html__( 'Enter Required Title', 'cras' ),
//             'default' => '',
//             ),
            
//             array(
//             'id' => 'cras_cs_wlc_desc',
//             'type' => 'textarea',
//             'title' => esc_html__('Welcome Description', 'cras'), 
//             'subtitle' => esc_html__( 'Enter Welcome Description', 'cras' ),
//             'default' => '',
//             ),
            
//         array(
//             'id'       => 'cras_cs_sc',
//             'type'     => 'editor',
//             'title'    => esc_html__( 'Subscribe Form Shortcode', 'cras' ),
//             'subtitle' => esc_html__( 'Enter Subscribe Shortcode from [Contact form 7]', 'cras' ),
//             'default'  => ''
//             )

//         )
//     ) );
    
    
/*
 *
 * --> Search Tab
 *
 */

Redux::setSection( $opt_name, array(
        'id'         => 'search_tab',
        'title'      => esc_html__( 'Search Settings', 'cras' ),
        'desc'       => esc_html__( 'All those Search related options are listed here ', 'cras' ),
        'icon'   => 'el el-website',
        'fields'     => array(

        
        array(
            'id' => 'cras_search_page_title',
            'type' => 'text',
            'title' => esc_html__('Search Page Title', 'cras'), 
            'subtitle' => esc_html__( 'Enter Required Title', 'cras' ),
            'default' => 'Search Result for',
        ),   
        array(
            'id' => 'cras_search_title',
            'type' => 'text',
            'title' => esc_html__('Nothing Found Title', 'cras'), 
            'subtitle' => esc_html__( 'Enter Required Title', 'cras' ),
            'default' => 'Nothing Found',
        ),

        array(
            'id' => 'cras_search_text',
            'type' => 'textarea',
            'title' => esc_html__('Nothing Found Subtitle', 'cras'), 
            'subtitle' => esc_html__( 'Enter Required Text', 'cras' ),
        ),    
        
        array(
            'id' => 'cras_search_btn',
            'type' => 'text',
            'title' => esc_html__('Nothing Found Button Text', 'cras'), 
            'subtitle' => esc_html__( 'Enter Button Text', 'cras' ),
            'default' => 'Back to Home',
        ),

        )
    ) );    
    
    
/*
 *
 * --> 404 Tab
 *
 */

Redux::setSection( $opt_name, array(
        'id'         => 'error_tab',
        'title'      => esc_html__( '404 Settings', 'cras' ),
        'desc'       => esc_html__( 'All those 404 related options are listed here ', 'cras' ),
        'icon'   => 'el el-website',
        'fields'     => array(

        
        array(
            'id' => 'cras_error_bg',
            'type' => 'media',
            'url' => true,
            'title' => esc_html__('Background Image', 'cras'),
            'compiler' => 'true',
            'subtitle' => esc_html__('Upload a Image from your hard drive or specify an existing url.', 'cras'),
            'default' => array(
            'url' => ''
            )
        ),    
        array(
            'id' => 'cras_error_title',
            'type' => 'text',
            'title' => esc_html__('Error Title', 'cras'), 
            'subtitle' => esc_html__( 'Enter Required Title', 'cras' ),
            'default' => 'Sorry! The page is not found here',
        ),

        array(
            'id' => 'cras_error_text',
            'type' => 'textarea',
            'title' => esc_html__('Error Text', 'cras'), 
            'subtitle' => esc_html__( 'Enter Required Text', 'cras' ),
            'default' => 'Fortunately, since it is mainly a client-side issue, it is relatively easy for website owners to fix the 404 error. This article will explain the possible causes of error 404 and show four effective methods to resolve it.Fortunately, since it is mainly a client-side issue, it is relatively easy for website owners to fix the 404 error.',
        ),    
        
        array(
            'id' => 'cras_error_btn',
            'type' => 'text',
            'title' => esc_html__('Button Text', 'cras'), 
            'subtitle' => esc_html__( 'Enter Button Text', 'cras' ),
            'default' => 'Back to Home',
        ),

        )
    ) );    


/*
 *
 * --> Custom CSS/JS Sections Tab
 *
 */
    Redux::setSection( $opt_name, array(
           'title'  => esc_html__( 'Custom CSS / JS', 'cras' ),
           'id'     => 'custom-css-js',
           'icon'   => 'el el-css',
           'fields' => array(

             array(
                        'id'        => 'cras_custom_css',
                        'type'      => 'ace_editor',
                        'title'     => esc_html__('Custom CSS ', 'cras'),
                        'subtitle'  => esc_html__('Paste your custom CSS code here.', 'cras'),
                        'mode'      => 'css',
                        'theme'     => 'monokai',
                    ),
                    array(
                        'id'        => 'cras_custom_js',
                        'type'      => 'ace_editor',
                        'title'     => esc_html__('Custom JS', 'cras'),
                        'subtitle'  => esc_html__('Paste your JS code here.', 'cras'),
                        'mode'      => 'javascript',
                        'theme'     => 'chrome',
                    )

           )
           )
    );

/*
 *
 * --> Footer Sections Tab
 *
 */

Redux::setSection( $opt_name, array(
        'id'         => 'footer_tab',
        'title'      => esc_html__( 'Footer', 'cras' ),
        'desc'       => esc_html__( 'All the footer related options are listed here ', 'cras' ),
        'icon'   => 'el el-website',
        'fields'     => array(
   
        array(
            'id' => 'cras_footer_bg',
            'type' => 'background',
            'url' => true,
            'title' => esc_html__('Footer Background Image', 'cras'),
            'compiler' => 'true',
            'subtitle' => esc_html__('Upload a image from your hard drive or specify an existing url.', 'cras'),
            'default' => array(
            'url' => ''
            )
        ),                                                       
        array(
            'id'       => 'cras_footercright',
            'type'     => 'textarea',
            'title'    => esc_html__( 'Footer copyright text', 'cras' ),
            'subtitle' => esc_html__( 'Enter Footer copyright text here', 'cras' ),
            'default'  => ''
            )                     

        )
    ) );

 /*
 *
 * --> Footer Subscriptions Tab
 *
 */

Redux::setSection( $opt_name, array(
    'id'         => 'footer_subs_tab',
    'title'      => esc_html__( 'Footer Subscriptions', 'cras' ),
    'desc'       => esc_html__( 'All the Subscriptions related options are listed here ', 'cras' ),
    'icon'   => 'el el-envelope',
    'fields'     => array(
    
    array(
        'id'       => 'cras_subs_tagline',
        'type'     => 'text',
        'title'    => esc_html__( 'Footer copyright text', 'cras' ),
        'subtitle' => esc_html__( 'Enter Footer copyright text here', 'cras' ),
        'default'  => ''
    ),
    array(
        'id'       => 'cras_subs_title',
        'type'     => 'textarea',
        'title'    => esc_html__( 'Footer copyright text', 'cras' ),
        'subtitle' => esc_html__( 'Enter Footer copyright text here', 'cras' ),
        'default'  => ''
    ),        
    array(
        'id'       => 'cras_subs_nsl',
        'type'     => 'editor',
        'title'    => esc_html__( 'Newsletter Shortcode', 'cras' ),
        'subtitle' => esc_html__( 'Enter Newsletter Shortcode from [Contact form 7]', 'cras' ),
        'default'  => ''
        ),                                                                           

    )
) );
    

/*
 * <--- END SECTIONS
 */


/*
 *
 * YOU MUST PREFIX THE FUNCTIONS BELOW AND ACTION FUNCTION CALLS OR ANY OTHER CONFIG MAY OVERRIDE YOUR CODE.
 *
 */

/*
 *
 * --> Action hook examples
 *
 */

// If Redux is running as a plugin, this will remove the demo notice and links
//add_action( 'redux/loaded', 'remove_demo' );

// Function to test the compiler hook and demo CSS output.
// Above 10 is a priority, but 2 in necessary to include the dynamically generated CSS to be sent to the function.
//add_filter('redux/options/' . $opt_name . '/compiler', 'compiler_action', 10, 3);

// Change the arguments after they've been declared, but before the panel is created
//add_filter('redux/options/' . $opt_name . '/args', 'change_arguments' );

// Change the default value of a field after it's been set, but before it's been useds
//add_filter('redux/options/' . $opt_name . '/defaults', 'change_defaults' );

// Dynamically add a section. Can be also used to modify sections/fields
//add_filter('redux/options/' . $opt_name . '/sections', 'dynamic_section');

/**
 * This is a test function that will let you see when the compiler hook occurs.
 * It only runs if a field    set with compiler=>true is changed.
 * */
if (!function_exists('compiler_action')) {
    function compiler_action($options, $css, $changed_values)
    {
        echo '<h1>The compiler hook has run!</h1>';
        echo "<pre>";
        print_r($changed_values); // Values that have changed since the last save
        echo "</pre>";
        //print_r($options); //Option values
        //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
    }
}

/**
 * Custom function for the callback validation referenced above
 * */
if (!function_exists('redux_validate_callback_function')) {
    function redux_validate_callback_function($field, $value, $existing_value)
    {
        $error   = false;
        $warning = false;
        
        //do your validation
        if ($value == 1) {
            $error = true;
            $value = $existing_value;
        } elseif ($value == 2) {
            $warning = true;
            $value   = $existing_value;
        }
        
        $return['value'] = $value;
        
        if ($error == true) {
            $return['error'] = $field;
            $field['msg']    = 'your custom error message';
        }
        
        if ($warning == true) {
            $return['warning'] = $field;
            $field['msg']      = 'your custom warning message';
        }
        
        return $return;
    }
}

/**
 * Custom function for the callback referenced above
 */
if (!function_exists('redux_my_custom_field')) {
    function redux_my_custom_field($field, $value)
    {
        print_r($field);
        echo '<br/>';
        print_r($value);
    }
}

/**
 * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
 * Simply include this function in the child themes functions.php file.
 * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
 * so you must use get_template_directory_uri() if you want to use any of the built in icons
 * */
if (!function_exists('dynamic_section')) {
    function dynamic_section($sections)
    {
        //$sections = array();
        $sections[] = array(
            'title' => esc_html__('Section via hook', 'cras'),
            'desc' => esc_html__('<p class="description"> This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options. </p>', 'cras'),
            'icon' => 'el el-paper-clip',
            // Leave this as a blank section, no options just some intro text set above.
            'fields' => array()
        );
        
        return $sections;
    }
}

/**
 * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
 * */
if (!function_exists('change_arguments')) {
    function change_arguments($args)
    {
        //$args['dev_mode'] = true;
        
        return $args;
    }
}

/**
 * Filter hook for filtering the default value of any given field. Very useful in development mode.
 * */
if (!function_exists('change_defaults')) {
    function change_defaults($defaults)
    {
        $defaults['str_replace'] = 'Testing filter hook!';
        
        return $defaults;
    }
}

function newIconFont() {
    // Uncomment this to remove elusive icon from the panel completely
 
    wp_register_style(
        'redux-font-awesome', THEMEROOT . '/fonts/font-awesome/css/font-awesome.min.css',
        array(),
        time(),
        'all'
    );  
    wp_enqueue_style( 'redux-font-awesome' );
}
// This example assumes the opt_name is set to redux_demo.  Please replace it with your opt_name value.
add_action( 'redux/page/redux_demo/enqueue', 'newIconFont' );

