<?php
/**
 * cras back compat functionality
 *
 * Prevents cras from running on WordPress versions prior to 4.7,
 * since this theme is not meant to be backward compatible beyond that and
 * relies on many newer functions and markup changes introduced in 4.7.
 *
 * @package cras
 */

/**
 * Prevent switching to cras on old versions of WordPress.
 *
 * Switches to the default theme.
 *
 */
function cras_switch_theme() {
	switch_theme( WP_DEFAULT_THEME );
	unset( $_GET['activated'] );
	add_action( 'admin_notices', 'cras_upgrade_notice' );
}
add_action( 'after_switch_theme', 'cras_switch_theme' );

/**
 * Adds a message for unsuccessful theme switch.
 *
 * Prints an update nag after an unsuccessful attempt to switch to
 * cras on WordPress versions prior to 4.7.
 *
 * @since cras 1.0
 *
 * @global string $wp_version WordPress version.
 */
function cras_upgrade_notice() {
	$message = sprintf( esc_html__( 'cras requires at least WordPress version 4.6. You are running version %s. Please upgrade and try again.', 'cras' ), $GLOBALS['wp_version'] );
	printf( '<div class="error"><p>%s</p></div>', $message );
}

/**
 * Prevents the Customizer from being loaded on WordPress versions prior to 4.7.
 *
 * @since cras 1.0
 *
 * @global string $wp_version WordPress version.
 */
function cras_customize() {
	wp_die( sprintf( esc_html__( 'cras requires at least WordPress version 5.9. You are running version %s. Please upgrade and try again.', 'cras' ), $GLOBALS['wp_version'] ), '', array(
		'back_link' => true,
	) );
}
add_action( 'load-customize.php', 'cras_customize' );

/**
 * Prevents the Theme Preview from being loaded on WordPress versions prior to 4.7.
 *
 * @since cras 1.0
 *
 * @global string $wp_version WordPress version.
 */
function cras_preview() {
	if ( isset( $_GET['preview'] ) ) {
		wp_die( sprintf( esc_html__( 'cras requires at least WordPress version 5.9. You are running version %s. Please upgrade and try again.', 'cras' ), $GLOBALS['wp_version'] ) );
	}
}
add_action( 'template_redirect', 'cras_preview' );
