<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package cras
 */
$cras_options = get_option('cras_options'); ?>

<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?> >

<?php
    $pred_img = '';
    $header_layout = '';
    $header_top = '';
    $header_top_button = '';
    $cursor_animation = '';
    $show_preloader = '';
    $head_top_left_btn = '';
    $cras_trbtn_text = '';
    $cras_trbtn_url = '';
    $show_pagebutton_next = '';
    $show_pagebutton_next_url = '';
    
    if(isset($cras_options['cras_cursor_animation'])){
        $cursor_animation = $cras_options['cras_cursor_animation'];
    }

    if(isset($cras_options['cras_pageLoader'])){
        $show_preloader = $cras_options['cras_pageLoader'];
    }

    if(isset($cras_options['cras_header_top'])){
        $header_top = $cras_options['cras_header_top'];
    }

    if(isset($cras_options['cras_header_top_button'])){
        $header_top_button = $cras_options['cras_header_top_button'];
    }

    if(isset($cras_options['cras_header_layout'])){
        $header_layout = $cras_options['cras_header_layout'];
    }

    if(isset($cras_options['cras_pred_logo'])){
        $pred_img = $cras_options['cras_pred_logo'] ['url'];
    }    

    if(isset($cras_options['head_top_left_btn_url'])){
        $head_top_left_btn = $cras_options['head_top_left_btn_url'];
    }

    if(isset($cras_options['cras_pagebutton'])){
        $show_pagebutton = $cras_options['cras_pagebutton'];
    }

    if(isset($cras_options['cras_trbtn_text'])){
        $cras_trbtn_text = $cras_options['cras_trbtn_text'];
    }

    if(isset($cras_options['cras_trbtn_url'])){
        $cras_trbtn_url = $cras_options['cras_trbtn_url'];
    }
?>

    <!-- Preloader start -->
    <?php if ( $show_preloader == 1 ): ?>
        
        <?php get_template_part( 'template-extras/preloader' ); ?>

    <?php endif; ?>
    <!-- Preloader end -->
  

    <!-- Hesder Style start -->
    <?php if( ($header_layout == '1') || (is_page_template('page-templates/page-home1.php')) ) { ?>    
        <header class="ak-site_header ak-style1 ak-sticky_header">

    <?php } elseif( ($header_layout == '2') || (is_page_template('page-templates/page-home2.php')) ) { ?>
        <header class="ak-site_header ak-style1 ak-sticky_header">    

    <?php } elseif( ($header_layout == '3') || (is_page_template('page-templates/page-home3.php')) ) { ?>
        <header class="ak-site_header ak-style1 ak-sticky_header">    

    <?php } elseif( ($header_layout == '4') || (is_page_template('page-templates/page-home4.php')) ) { ?>
        <header class="ak-site_header ak-style1 ak-sticky_header">
            
    <?php } else { ?>        
        <header class="ak-site_header ak-style1 ak-sticky_header">    
    <?php } ?>        
        <div class="ak-main_header">
            <div class="container">
                <div class="ak-main_header_in">
                    <div class="ak-main-header-left">
                    <?php cras_the_custom_logo(); ?>
                    </div>
                    <div class="ak-main-header-center">
                        <?php get_template_part('template-parts/header/menu'); ?>
                    </div>
                    <?php get_template_part('template-parts/header/header', 'top'); ?>
                </div>
            </div>
        </div>
        <div class="nav-bar-border"></div>                                

    </header>
    <div class="ak-height-100 ak-height-lg-40"></div>   
    <!-- End Header Section -->
    

