<?php
/*
 * Dynamic style of stroke
 *
 * @package cras
 */

add_action('wp_head', 'cras_stroke_colors');
function cras_stroke_colors() {  
 	
 global $cras_options;
 ?>

<?php
    $cras_primary_color = '';
    
    if(isset($cras_options['cras_primary_color'])){
        $cras_primary_color = $cras_options['cras_primary_color'];
    }

    $stroke_text_color = '';
    
    if(isset($cras_options['cras_stroke_text_color'])){
        $stroke_text_color = $cras_options['cras_stroke_text_color'];
    }
?>

<style type="text/css">
<?php if(!empty($stroke_text_color)) { ?>    
    .ak-stroke-number {
        -webkit-text-stroke: 3px <?php echo esc_attr($stroke_text_color); ?>!important;
    }
<?php } else { ?>
    .ak-stroke-number {
    -webkit-text-stroke: 3px var(--primary-color);
}
<?php } ?>

<?php if(!empty($cras_primary_color)) { ?>    
    :root {
        --primary-color: <?php echo esc_attr($cras_primary_color); ?>!important;
    }
<?php } else { ?>
    :root {
        --primary-color: #ff3d24;
}
<?php } ?>
</style>

<?php } ?>