<?php
/* Template Name: page-404 */
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package cras
 */

get_header();
$cras_options = get_option('cras_options'); ?>

<?php 
    $error_bg = '';
    $error_title = '';
    $error_text = '';
    $error_btn = '';  
    
    if(isset($cras_options['cras_error_bg'])) {
        $error_bg = $cras_options['cras_error_bg']['url'];
    }
    
    if(isset($cras_options['cras_error_title'])) {
        $error_title = $cras_options['cras_error_title'];
    }

    if(isset($cras_options['cras_error_text'])) {
        $error_text = $cras_options['cras_error_text'];
    }

    if(isset($cras_options['cras_error_btn'])) {
        $error_btn = $cras_options['cras_error_btn'];
    } 
?>

    <div class="error-section mgb-125 ak-bg ak-center" data-src="<?php echo esc_url($error_bg); ?>">
        <div class="error-content">

            <h1 class="error-title ak-stroke-number color-white"><?php esc_html_e('404', 'cras'); ?></h1>

        <?php if(!empty($error_title)) { ?>     
            <h2 class="erro-sub-title"><?php echo esc_html( $error_title ); ?></h2>
        <?php } else { ?>
            <h2 class="erro-sub-title"><?php esc_html_e('Sorry! The page is not found here', 'cras'); ?></h2>  
        <?php } ?>      

        <?php if(!empty($error_text)) { ?>
            <p class="erro-desp"><?php echo esc_html( $error_text ); ?></p>
        <?php } else { ?> 
            <p class="erro-desp"><?php esc_html_e('Fortunately, since it is mainly a client-side issue, it is relatively easy for website
                owners to fix the 404 error. This article will explain the possible causes of error 404 and show four effective methods to
                resolve it.Fortunately, since it is mainly a client-side issue.', 'cras'); ?></p> 
        <?php } ?>             

        <?php if(!empty($error_btn)) { ?>     
            <div class="go-to-home">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="common-btn">
                    <?php echo esc_html( $error_btn ); ?>
                </a>
            </div>
        <?php } else { ?>
            <div class="go-to-home">
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="common-btn">
                    <?php esc_html_e('BACK TO HOME', 'cras'); ?>
                </a>
            </div>
        <?php } ?>   

        </div>
    </div>
<?php get_footer(); ?>