<?php
/*
Plugin Name: Cras Our Services Widget
Description: Cras Our Services Widget to display your services.
Author: 3jon
Version: 5.0
Author URI: https://themeforest.net/user/3jon
Text Domain: cras
*/

class cras_our_services extends WP_Widget {

    function __construct() {
        $widget_ops = array('classname' => 'widget_recent_entries', 'description' => esc_html__( "The most service posts on your site", "cras") );
        parent::__construct('cras-services', esc_html__('Cras - Our Services', 'cras'), $widget_ops);
        $this->alt_option_name = 'widget_recent_entries';

        add_action( 'save_post', array($this, 'cras_sr_widget_cache') );
        add_action( 'deleted_post', array($this, 'cras_sr_widget_cache') );
        add_action( 'switch_theme', array($this, 'cras_sr_widget_cache') );
    }

    function widget($args, $instance) {
        $cache = wp_cache_get('widget_recent_services', 'widget');

        if ( !is_array($cache) )
            $cache = array();

        if ( ! isset( $args['widget_id'] ) )
            $args['widget_id'] = $this->id;

        if ( isset( $cache[ $args['widget_id'] ] ) ) {
            echo $cache[ $args['widget_id'] ];
            return;
        }

        ob_start();
        extract($args);

        $title = ( ! empty( $instance['title'] ) ) ? $instance['title'] : ( ' ' );
        $srv_catw = ( ! empty( $instance['services_category'] ) ) ? $instance['services_category'] : ( 'With Icons' );
        $title = apply_filters( 'widget_title', $title, $instance, $this->id_base );
        $number = ( ! empty( $instance['number'] ) ) ? absint( $instance['number'] ) : 10;
        if ( ! $number )
            $number = 10;
   

        $r = new WP_Query( apply_filters( 'widget_posts_args', array('posts_per_page' => $number, 'services_category'=> $srv_catw, 'no_found_rows' => true, 'post_status' => 'publish', 'post_type'=>'services', 'ignore_sticky_posts' => true ) ) );
        if ($r->have_posts()) :
?>
        <?php echo $before_widget; ?>
        <?php if ( $title ) echo $before_title . $title . $after_title; ?>
        
            <?php
                global $post;
                while ( $r->have_posts() ) : $r->the_post(); ?>
                    <div class="service-card-style-2" data-aos="fade-up">
						<div class="service-icon">
							<img src="<?php the_post_thumbnail_url('full'); ?>" width="46" height="47" alt="<?php echo get_bloginfo('display' ,'name') ?>">
						</div>
						<div class="service-desp">
							<a href="<?php the_permalink(); ?>" class="title"><?php the_title(); ?></a>
							<div class="desp"><?php the_excerpt(); ?></div>
							<a href="<?php the_permalink(); ?>" class="more-btn"><?php esc_html_e('VIEW MORE', 'cras'); ?></a>
						</div>
					</div>
                <?php endwhile; ?>

        <?php echo $after_widget; ?>
<?php
        // Reset the global $the_post as this query will have stomped on it
        wp_reset_postdata();

        endif;

        $cache[$args['widget_id']] = ob_get_flush();
        wp_cache_set('widget_recent_services', $cache, 'widget');
    }

    function update( $new_instance, $old_instance ) {
        $instance = $old_instance;
        $instance['title'] = strip_tags($new_instance['title']);
        $instance['services_category'] = strip_tags($new_instance['services_category']);
        $instance['number'] = (int) $new_instance['number'];
        $this->cras_sr_widget_cache();

        $alloptions = wp_cache_get( 'alloptions', 'options' );
        if ( isset($alloptions['widget_recent_entries']) )
            delete_option('widget_recent_entries');

        return $instance;
    }

    function cras_sr_widget_cache() {
        wp_cache_delete('widget_recent_services', 'widget');
    }

    function form( $instance ) {
        $title     = isset( $instance['title'] ) ? esc_attr( $instance['title'] ) : '';
        $srv_catw     = isset( $instance['services_category'] ) ? esc_attr( $instance['services_category'] ) : '';
        $number    = isset( $instance['number'] ) ? absint( $instance['number'] ) : 6;
?>
        <p><label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php esc_html_e( 'Title:','cras' ); ?></label>
        <input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr($title); ?>" /></p>
        
        <p><label for="<?php echo $this->get_field_id( 'services_category' ); ?>"><?php esc_html_e( 'Title:','cras' ); ?></label>
        <input class="widefat" id="<?php echo $this->get_field_id( 'services_category' ); ?>" name="<?php echo $this->get_field_name( 'services_category' ); ?>" type="text" value="<?php echo esc_attr($srv_catw); ?>" /></p>

        <p><label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php esc_html_e( 'Number of posts to show:','cras' ); ?></label>
        <input id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" type="text" value="<?php echo esc_attr($number); ?>" size="3" /></p>
<?php
    }
}

function cras_register_services_widget() {
 
    register_widget( 'cras_our_services' );
 
}
add_action( 'widgets_init', 'cras_register_services_widget' );